/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.serialize;

import com.xxl.rpc.serialize.impl.Hessian1Serializer;
import com.xxl.rpc.serialize.impl.HessianSerializer;
import com.xxl.rpc.serialize.impl.JacksonSerializer;
import com.xxl.rpc.serialize.impl.ProtostuffSerializer;
import com.xxl.rpc.util.XxlRpcException;

public abstract class Serializer {
    public abstract <T> byte[] serialize(T var1);

    public abstract <T> Object deserialize(byte[] var1, Class<T> var2);

    public static enum SerializeEnum {
        HESSIAN(HessianSerializer.class),
        HESSIAN1(Hessian1Serializer.class),
        PROTOSTUFF(ProtostuffSerializer.class),
        JSON(JacksonSerializer.class);

        private Class<? extends Serializer> serializerClass;

        private SerializeEnum(Class<? extends Serializer> serializerClass) {
            this.serializerClass = serializerClass;
        }

        public Serializer getSerializer() {
            try {
                return this.serializerClass.newInstance();
            }
            catch (Exception e) {
                throw new XxlRpcException(e);
            }
        }

        public static SerializeEnum match(String name, SerializeEnum defaultSerializer) {
            for (SerializeEnum item : SerializeEnum.values()) {
                if (!item.name().equals(name)) continue;
                return item;
            }
            return defaultSerializer;
        }
    }
}

