/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.provider.impl;

import com.xxl.rpc.registry.ServiceRegistry;
import com.xxl.rpc.remoting.net.NetEnum;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.remoting.provider.annotation.XxlRpcService;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.IpUtil;
import com.xxl.rpc.util.NetUtil;
import com.xxl.rpc.util.XxlRpcException;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XxlRpcSpringProviderFactory
extends XxlRpcProviderFactory
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private String netType = NetEnum.JETTY.name();
    private String serialize = Serializer.SerializeEnum.HESSIAN.name();
    private String ip = IpUtil.getIp();
    private int port = 7080;
    private String accessToken;
    private Class<? extends ServiceRegistry> serviceRegistryClass;
    private Map<String, String> serviceRegistryParam;

    public void setNetType(String netType) {
        this.netType = netType;
    }

    public void setSerialize(String serialize) {
        this.serialize = serialize;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setServiceRegistryClass(Class<? extends ServiceRegistry> serviceRegistryClass) {
        this.serviceRegistryClass = serviceRegistryClass;
    }

    public void setServiceRegistryParam(Map<String, String> serviceRegistryParam) {
        this.serviceRegistryParam = serviceRegistryParam;
    }

    private void prepareConfig() {
        Serializer serializer;
        NetEnum netTypeEnum = NetEnum.autoMatch(this.netType, null);
        Serializer.SerializeEnum serializeEnum = Serializer.SerializeEnum.match(this.serialize, null);
        Serializer serializer2 = serializer = serializeEnum != null ? serializeEnum.getSerializer() : null;
        if (this.port <= 0) {
            throw new XxlRpcException("xxl-rpc provider port[" + this.port + "] is unvalid.");
        }
        if (NetUtil.isPortUsed(this.port)) {
            throw new XxlRpcException("xxl-rpc provider port[" + this.port + "] is used.");
        }
        super.initConfig(netTypeEnum, serializer, this.ip, this.port, this.accessToken, this.serviceRegistryClass, this.serviceRegistryParam);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map serviceBeanMap = applicationContext.getBeansWithAnnotation(XxlRpcService.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            for (Object serviceBean : serviceBeanMap.values()) {
                if (serviceBean.getClass().getInterfaces().length == 0) {
                    throw new XxlRpcException("xxl-rpc, service(XxlRpcService) must inherit interface.");
                }
                XxlRpcService xxlRpcService = serviceBean.getClass().getAnnotation(XxlRpcService.class);
                String iface = serviceBean.getClass().getInterfaces()[0].getName();
                String version = xxlRpcService.version();
                super.addService(iface, version, serviceBean);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.prepareConfig();
        super.start();
    }

    public void destroy() throws Exception {
        super.stop();
    }
}

