/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.jetty.server;

import com.xxl.rpc.remoting.net.Server;
import com.xxl.rpc.remoting.net.impl.jetty.server.JettyServerHandler;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServer
extends Server {
    private org.eclipse.jetty.server.Server server;
    private Thread thread;

    @Override
    public void start(final XxlRpcProviderFactory xxlRpcProviderFactory) throws Exception {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JettyServer.this.server = new org.eclipse.jetty.server.Server((ThreadPool)new QueuedThreadPool());
                ServerConnector connector = new ServerConnector(JettyServer.this.server);
                connector.setPort(xxlRpcProviderFactory.getPort());
                JettyServer.this.server.setConnectors(new Connector[]{connector});
                HandlerCollection handlerc = new HandlerCollection();
                handlerc.setHandlers(new Handler[]{new JettyServerHandler(xxlRpcProviderFactory)});
                JettyServer.this.server.setHandler((Handler)handlerc);
                try {
                    JettyServer.this.server.start();
                    logger.info(">>>>>>>>>>> xxl-rpc remoting server start success, nettype = {}, port = {}", (Object)JettyServer.class.getName(), (Object)xxlRpcProviderFactory.getPort());
                    JettyServer.this.onStarted();
                    JettyServer.this.server.join();
                }
                catch (Exception e) {
                    logger.error(">>>>>>>>>>> xxl-rpc remoting server start error.", (Throwable)e);
                }
                finally {
                    try {
                        JettyServer.this.stop();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            try {
                this.server.stop();
                this.server.destroy();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        this.onStoped();
        logger.info(">>>>>>>>>>> xxl-rpc remoting server destroy success.");
    }
}

