/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.invoker;

import com.xxl.rpc.registry.ServiceRegistry;
import com.xxl.rpc.remoting.net.params.BaseCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XxlRpcInvokerFactory {
    private Class<? extends ServiceRegistry> serviceRegistryClass;
    private Map<String, String> serviceRegistryParam;
    private static ServiceRegistry serviceRegistry;
    private static List<BaseCallback> stopCallbackList;

    public XxlRpcInvokerFactory() {
    }

    public XxlRpcInvokerFactory(Class<? extends ServiceRegistry> serviceRegistryClass, Map<String, String> serviceRegistryParam) {
        this.serviceRegistryClass = serviceRegistryClass;
        this.serviceRegistryParam = serviceRegistryParam;
    }

    public void start() throws Exception {
        if (this.serviceRegistryClass != null) {
            serviceRegistry = this.serviceRegistryClass.newInstance();
            serviceRegistry.start(this.serviceRegistryParam);
        }
    }

    public void stop() throws Exception {
        if (serviceRegistry != null) {
            serviceRegistry.stop();
        }
        if (stopCallbackList.size() > 0) {
            for (BaseCallback callback : stopCallbackList) {
                callback.run();
            }
        }
    }

    public static ServiceRegistry getServiceRegistry() {
        return serviceRegistry;
    }

    public static void addStopCallBack(BaseCallback callback) {
        stopCallbackList.add(callback);
    }

    static {
        stopCallbackList = new ArrayList<BaseCallback>();
    }
}

