/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletRequest;

public class BeanUtil {
    public static boolean isBean(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
    }

    public static Map<String, PropertyDescriptor> getFieldNamePropertyDescriptorMap(Class<?> clazz) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz)) {
            if (!ObjectUtil.equal(fieldName, propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMapIgnoreCase(map, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T fillBeanWithMap(final Map<?, ?> map, T bean, final boolean isIgnoreError) {
        return BeanUtil.fillBean(bean, new ValueProvider(){

            @Override
            public Object value(String name) {
                return map.get(name);
            }

            @Override
            public boolean isIgnoreError() {
                return isIgnoreError;
            }
        });
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        if (isToCamelCase) {
            HashMap map2 = new HashMap();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object key = entry.getKey();
                if (null != key && key instanceof String) {
                    String keyStr = (String)key;
                    map2.put(StrUtil.toCamelCase(keyStr), entry.getValue());
                    continue;
                }
                map2.put((String)key, entry.getValue());
            }
            return BeanUtil.fillBeanWithMap(map2, bean, isIgnoreError);
        }
        return BeanUtil.fillBeanWithMap(map, bean, isIgnoreError);
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, final boolean isIgnoreError) {
        final HashMap map2 = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                String keyStr = (String)key;
                map2.put(keyStr.toLowerCase(), entry.getValue());
                continue;
            }
            map2.put((String)key, entry.getValue());
        }
        return BeanUtil.fillBean(bean, new ValueProvider(){

            @Override
            public Object value(String name) {
                return map2.get(name.toLowerCase());
            }

            @Override
            public boolean isIgnoreError() {
                return isIgnoreError;
            }
        });
    }

    public static <T> T requestParamToBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithRequestParam(request, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T fillBeanWithRequestParam(final ServletRequest request, T bean, final boolean isIgnoreError) {
        final String beanName = StrUtil.lowerFirst(bean.getClass().getSimpleName());
        return BeanUtil.fillBean(bean, new ValueProvider(){

            @Override
            public Object value(String name) {
                String value = request.getParameter(name);
                if (StrUtil.isEmpty(value) && StrUtil.isEmpty(value = request.getParameter(beanName + "." + name))) {
                    value = null;
                }
                return value;
            }

            @Override
            public boolean isIgnoreError() {
                return isIgnoreError;
            }
        });
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider valueProvider) {
        return BeanUtil.fillBean(ClassUtil.newInstance(beanClass), valueProvider);
    }

    public static <T> T fillBean(T bean, ValueProvider valueProvider) {
        if (null == valueProvider) {
            return bean;
        }
        Class<?> beanClass = bean.getClass();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = BeanUtil.getPropertyDescriptors(beanClass)) {
                String propertyName = property.getName();
                Object value = valueProvider.value(propertyName);
                if (null == value) continue;
                try {
                    property.getWriteMethod().invoke(bean, Convert.convert(property.getPropertyType(), value));
                }
                catch (Exception e) {
                    if (valueProvider.isIgnoreError()) {
                        StaticLog.warn("Inject [{}] error: {}", property.getName(), e.getMessage());
                        continue;
                    }
                    throw new UtilException(e, "Inject [{}] error!", property.getName());
                }
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return bean;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        return BeanUtil.beanToMap(bean, false, false);
    }

    public static <T> Map<String, Object> beanToMap(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = BeanUtil.getPropertyDescriptors(bean.getClass())) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(bean, new Object[0]);
                if (ignoreNullValue && null == value) continue;
                map.put(isToUnderlineCase ? StrUtil.toUnderlineCase(key) : key, value);
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return map;
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtil.copyProperties(source, target, CopyOptions.create());
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtil.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        Map<String, PropertyDescriptor> sourcePdMap;
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        Class actualEditable = target.getClass();
        if (copyOptions.editable != null) {
            if (!copyOptions.editable.isInstance(target)) {
                throw new IllegalArgumentException(StrUtil.format("Target class [{}] not assignable to Editable class [{}]", target.getClass().getName(), copyOptions.editable.getName()));
            }
            actualEditable = copyOptions.editable;
        }
        PropertyDescriptor[] targetPds = null;
        try {
            sourcePdMap = BeanUtil.getFieldNamePropertyDescriptorMap(source.getClass());
            targetPds = BeanUtil.getPropertyDescriptors(actualEditable);
        }
        catch (IntrospectionException e) {
            throw new UtilException(e);
        }
        HashSet<String> ignoreSet = copyOptions.ignoreProperties != null ? CollectionUtil.newHashSet(copyOptions.ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreSet != null && ignoreSet.contains(targetPd.getName()) || (sourcePd = sourcePdMap.get(targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtil.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                Object value = ClassUtil.setAccessible(readMethod).invoke(source, new Object[0]);
                if (null == value && copyOptions.isIgnoreNullValue) continue;
                ClassUtil.setAccessible(writeMethod).invoke(target, value);
            }
            catch (Throwable ex) {
                if (copyOptions.isIgnoreError) {
                    StaticLog.warn("Copy property [{}] to [{}] error: {}", sourcePd.getName(), targetPd.getName(), ex.getMessage());
                    continue;
                }
                throw new UtilException(ex, "Copy property [{}] to [{}] error: {}", sourcePd.getName(), targetPd.getName(), ex.getMessage());
            }
        }
    }

    public static class CopyOptions {
        private Class<?> editable;
        private boolean isIgnoreNullValue;
        private String[] ignoreProperties;
        private boolean isIgnoreError;

        public static CopyOptions create() {
            return new CopyOptions();
        }

        public static CopyOptions create(Class<?> editable, boolean isIgnoreNullValue, String ... ignoreProperties) {
            return new CopyOptions(editable, isIgnoreNullValue, ignoreProperties);
        }

        public CopyOptions() {
        }

        public CopyOptions(Class<?> editable, boolean isIgnoreNullValue, String ... ignoreProperties) {
            this.editable = editable;
            this.isIgnoreNullValue = isIgnoreNullValue;
            this.ignoreProperties = ignoreProperties;
        }

        public CopyOptions setEditable(Class<?> editable) {
            this.editable = editable;
            return this;
        }

        public CopyOptions setIgnoreNullValue(boolean isIgnoreNullVall) {
            this.isIgnoreNullValue = isIgnoreNullVall;
            return this;
        }

        public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
            this.ignoreProperties = ignoreProperties;
            return this;
        }

        public void setIgnoreError(boolean isIgnoreError) {
            this.isIgnoreError = isIgnoreError;
        }
    }

    public static interface ValueProvider {
        public Object value(String var1);

        public boolean isIgnoreError();
    }
}

