/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto.digest;

import com.xiaoleilu.hutool.crypto.CryptoException;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.crypto.digest.HmacAlgorithm;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.HexUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HMac {
    private Mac mac;
    private SecretKey secretKey;

    public HMac(HmacAlgorithm algorithm) {
        this(algorithm, null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key) {
        this.init(algorithm.getValue(), key);
    }

    public HMac init(String algorithm, byte[] key) {
        try {
            this.mac = Mac.getInstance(algorithm);
            this.secretKey = null != key ? new SecretKeySpec(key, algorithm) : SecureUtil.generateKey(algorithm);
            this.mac.init(this.secretKey);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StrUtil.bytes(data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexUtil.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    public byte[] digest(File file) {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public String digestHex(File file) {
        return HexUtil.encodeHexStr(this.digest(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(byte[] data) {
        byte[] result;
        try {
            result = this.mac.doFinal(data);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.mac.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            this.mac.doFinal();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeHexStr(this.digest(data, bufferLength));
    }

    public Mac getMac() {
        return this.mac;
    }
}

