/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.net.jndi.TrustManagerSSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private static final boolean DEBUG = false;
    private static SSLSocketFactory ossl = null;

    protected static boolean isFactorySet() {
        return null != ossl;
    }

    protected static void setFactory(SSLSocketFactory sSLSocketFactory) {
        if (null == ossl) {
            ossl = sSLSocketFactory;
        }
    }

    protected void setDefaultFactory() {
        CustomSSLSocketFactory.setFactory((SSLSocketFactory)SSLSocketFactory.getDefault());
    }

    protected CustomSSLSocketFactory() {
    }

    public static SocketFactory getDefault() {
        CustomSSLSocketFactory customSSLSocketFactory = null;
        try {
            customSSLSocketFactory = new TrustManagerSSLSocketFactory();
        }
        catch (Exception exception) {
            customSSLSocketFactory = new CustomSSLSocketFactory();
        }
        ((CustomSSLSocketFactory)customSSLSocketFactory).setDefaultFactory();
        return customSSLSocketFactory;
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(string, n2);
        return this.init(sSLSocket);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(inetAddress, n2);
        return this.init(sSLSocket);
    }

    @Override
    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(string, n2, inetAddress, n3);
        return this.init(sSLSocket);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(inetAddress, n2, inetAddress2, n3);
        return this.init(sSLSocket);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n2, boolean bl) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(socket, string, n2, bl);
        return this.init(sSLSocket);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return ossl.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return ossl.getSupportedCipherSuites();
    }

    private SSLSocket init(SSLSocket sSLSocket) throws IOException {
        sSLSocket.setUseClientMode(true);
        String[] stringArray = new String[]{"SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
        sSLSocket.setEnabledCipherSuites(stringArray);
        sSLSocket.startHandshake();
        return sSLSocket;
    }
}

