/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.OffsetDST;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

abstract class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    static final byte IS_UNINITIALIZED = -1;
    static final byte IS_SELECT = 0;
    static final byte IS_PLSQL_BLOCK = 1;
    static final byte IS_DML = 2;
    static final byte IS_OTHER = 3;
    static final byte IS_CALL_BLOCK = 4;
    int cursorId;
    int numberOfDefinePositions;
    int definesBatchSize;
    Accessor[] accessors;
    int defineByteSubRange;
    int defineCharSubRange;
    int defineIndicatorSubRange;
    int defineLengthSubRange;
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    boolean described = false;
    boolean describedWithNames = false;
    byte[] defineMetaData;
    int defineMetaDataSubRange;
    static final int METADATALENGTH = 1;
    int rowsProcessed;
    int cachedDefineByteSize = 0;
    int cachedDefineCharSize = 0;
    int cachedDefineIndicatorSize = 0;
    int cachedDefineMetaDataSize = 0;
    OracleStatement children = null;
    OracleStatement parent = null;
    OracleStatement nextChild = null;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int numberOfBindPositions;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    int firstRowInBatch;
    boolean hasIbtBind = false;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    ByteBuffer[] nioBuffers = null;
    Object[] lobPrefetchMetaData = null;
    boolean hasStream;
    byte[] tmpByteArray;
    int sizeTmpByteArray = 0;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch = false;
    int[] definedColumnType = null;
    int[] definedColumnSize = null;
    int[] definedColumnFormOfUse = null;
    T4CTTIoac[] oacdefSent = null;
    int[] nbPostPonedColumns = null;
    int[][] indexOfPostPonedColumn = null;
    boolean aFetchWasDoneDuringDescribe = false;
    boolean implicitDefineForLobPrefetchDone = false;
    int accessorByteOffset = 0;
    int accessorCharOffset = 0;
    int accessorShortOffset = 0;
    static final int VALID_ROWS_UNINIT = -999;
    PhysicalConnection connection;
    OracleInputStream streamList;
    OracleInputStream nextStream;
    OracleResultSetImpl currentResultSet;
    boolean processEscapes;
    boolean convertNcharLiterals;
    int queryTimeout;
    int batch;
    int numberOfExecutedElementsInBatch = -1;
    int currentRank;
    int currentRow;
    int validRows;
    int maxFieldSize;
    int maxRows;
    int totalRowsVisited;
    int rowPrefetch;
    int rowPrefetchInLastFetch = -1;
    int defaultRowPrefetch;
    boolean rowPrefetchChanged;
    int defaultLobPrefetchSize;
    boolean gotLastBatch;
    boolean clearParameters;
    boolean closed;
    boolean sqlStringChanged;
    OracleSql sqlObject;
    boolean needToParse;
    boolean needToPrepareDefineBuffer;
    boolean columnsDefinedByUser;
    byte sqlKind;
    int autoRollback;
    int defaultFetchDirection;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    boolean isExecuting = false;
    OracleStatementWrapper wrapper;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    byte executionType = (byte)-1;
    OracleResultSet scrollRset;
    oracle.jdbc.OracleResultSetCache rsetCache;
    int userRsetType;
    int realRsetType;
    boolean needToAddIdentifier;
    SQLWarning sqlWarning;
    int cacheState = 3;
    int creationState = 0;
    boolean isOpen = false;
    int statementType = 0;
    boolean columnSetNull = false;
    int[] returnParamMeta;
    static final int DMLR_METADATA_PREFIX_SIZE = 3;
    static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
    static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
    static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
    static final int DMLR_METADATA_TYPE_OFFSET = 0;
    static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
    static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
    static final int DMLR_METADATA_PER_POSITION_SIZE = 3;
    Accessor[] returnParamAccessors;
    boolean returnParamsFetched;
    int rowsDmlReturned;
    int numReturnParams;
    byte[] returnParamBytes;
    char[] returnParamChars;
    short[] returnParamIndicators;
    int returnParamRowBytes;
    int returnParamRowChars;
    OracleReturnResultSet returnResultSet;
    boolean isAutoGeneratedKey;
    AutoKeyInfo autoKeyInfo;
    TimeZone defaultTimeZone = null;
    String defaultTimeZoneName = null;
    int defaultTimeZoneID = -2;
    OffsetDST[] defaultTimeZoneOffsetDST = null;
    Calendar defaultCalendar = null;
    Calendar gmtCalendar = null;
    int lastIndex;
    Vector m_batchItems = new Vector();
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    ArrayList oldTempClobsToFree = null;
    ArrayList oldTempBlobsToFree = null;
    NTFDCNRegistration registration = null;
    String[] dcnTableName = null;
    long dcnQueryId = -1L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:30:28_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    abstract void doDescribe(boolean var1) throws SQLException;

    abstract void executeForDescribe() throws SQLException;

    abstract void executeForRows(boolean var1) throws SQLException;

    abstract void fetch() throws SQLException;

    void continueReadRow(int n2) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "continueReadRow is only implemented by the T4C statements.");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    abstract void doClose() throws SQLException;

    abstract void closeQuery() throws SQLException;

    public int cursorIfRefCursor() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "cursorIfRefCursor not implemented");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    OracleStatement(PhysicalConnection physicalConnection, int n2, int n3) throws SQLException {
        this(physicalConnection, n2, n3, -1, -1);
    }

    OracleStatement(PhysicalConnection physicalConnection, int n2, int n3, int n4, int n5) throws SQLException {
        this.connection = physicalConnection;
        this.connection.needLine();
        this.connection.registerHeartbeat();
        this.connection.addStatement(this);
        this.sqlObject = new OracleSql(this.connection.conversion);
        this.processEscapes = this.connection.processEscapes;
        this.convertNcharLiterals = this.connection.convertNcharLiterals;
        this.autoRollback = 2;
        this.gotLastBatch = false;
        this.closed = false;
        this.clearParameters = true;
        this.serverCursor = false;
        this.needToAddIdentifier = false;
        this.defaultFetchDirection = 1000;
        this.fixedString = this.connection.getDefaultFixedString();
        this.rowPrefetchChanged = false;
        this.rowPrefetch = n3;
        this.defaultRowPrefetch = n3;
        this.defaultLobPrefetchSize = this.connection.defaultLobPrefetchSize;
        this.batch = n2;
        this.sqlStringChanged = true;
        this.needToParse = true;
        this.needToPrepareDefineBuffer = true;
        this.columnsDefinedByUser = false;
        if (n4 != -1 || n5 != -1) {
            this.realRsetType = 0;
            this.userRsetType = ResultSetUtil.getRsetTypeCode(n4, n5);
            this.needToAddIdentifier = ResultSetUtil.needIdentifier(this.userRsetType);
        } else {
            this.userRsetType = 1;
            this.realRsetType = 1;
        }
    }

    void initializeDefineSubRanges() {
        this.defineByteSubRange = 0;
        this.defineCharSubRange = 0;
        this.defineIndicatorSubRange = 0;
        this.defineMetaDataSubRange = 0;
    }

    void prepareDefinePreambles() {
    }

    void prepareAccessors() throws SQLException {
        Accessor accessor;
        int n2;
        byte[] byArray = null;
        char[] cArray = null;
        short[] sArray = null;
        boolean bl = false;
        byte[] byArray2 = null;
        if (this.accessors == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.numberOfDefinePositions; ++n2) {
            accessor = this.accessors[n2];
            if (accessor == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            switch (accessor.internalType) {
                case 8: 
                case 24: {
                    this.hasStream = true;
                }
            }
            n3 += accessor.byteLength;
            n4 += accessor.charLength;
            ++n5;
        }
        if (this.streamList != null && !this.connection.useFetchSizeWithLongColumn) {
            this.rowPrefetch = 1;
        }
        this.definesBatchSize = n2 = this.rowPrefetch;
        this.initializeDefineSubRanges();
        int n6 = n5 * n2;
        if (this.defineMetaData == null || this.defineMetaData.length < n6) {
            if (this.defineMetaData != null) {
                byArray2 = this.defineMetaData;
            }
            this.defineMetaData = new byte[n6];
        }
        this.cachedDefineByteSize = this.defineByteSubRange + n3 * n2;
        if (this.defineBytes == null || this.defineBytes.length < this.cachedDefineByteSize) {
            if (this.defineBytes != null) {
                byArray = this.defineBytes;
            }
            this.defineBytes = this.connection.getByteBuffer(this.cachedDefineByteSize);
        }
        this.defineByteSubRange += this.accessorByteOffset;
        this.cachedDefineCharSize = this.defineCharSubRange + n4 * n2;
        if ((this.defineChars == null || this.defineChars.length < this.cachedDefineCharSize) && this.cachedDefineCharSize > 0) {
            if (this.defineChars != null) {
                cArray = this.defineChars;
            }
            this.defineChars = this.connection.getCharBuffer(this.cachedDefineCharSize);
        }
        this.defineCharSubRange += this.accessorCharOffset;
        int n7 = this.numberOfDefinePositions * n2;
        int n8 = this.defineIndicatorSubRange + n7 + n7;
        if (this.defineIndicators == null || this.defineIndicators.length < n8) {
            if (this.defineIndicators != null) {
                sArray = this.defineIndicators;
            }
            this.defineIndicators = new short[n8];
        } else if (this.defineIndicators.length >= n8) {
            bl = true;
            sArray = this.defineIndicators;
        }
        this.defineIndicatorSubRange += this.accessorShortOffset;
        int n9 = this.defineIndicatorSubRange + n7;
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            accessor = this.accessors[i2];
            accessor.lengthIndexLastRow = accessor.lengthIndex;
            accessor.indicatorIndexLastRow = accessor.indicatorIndex;
            accessor.columnIndexLastRow = accessor.columnIndex;
            accessor.setOffsets(n2);
            accessor.lengthIndex = n9;
            accessor.indicatorIndex = this.defineIndicatorSubRange;
            accessor.metaDataIndex = this.defineMetaDataSubRange;
            accessor.rowSpaceByte = this.defineBytes;
            accessor.rowSpaceChar = this.defineChars;
            accessor.rowSpaceIndicator = this.defineIndicators;
            accessor.rowSpaceMetaData = this.defineMetaData;
            this.defineIndicatorSubRange += n2;
            n9 += n2;
            this.defineMetaDataSubRange += n2 * 1;
        }
        this.prepareDefinePreambles();
        if (this.rowPrefetchInLastFetch != -1 && this.rowPrefetch != this.rowPrefetchInLastFetch) {
            if (cArray == null) {
                cArray = this.defineChars;
            }
            if (byArray == null) {
                byArray = this.defineBytes;
            }
            if (sArray == null) {
                sArray = this.defineIndicators;
            }
            this.saveDefineBuffersIfRequired(cArray, byArray, sArray, bl);
        }
    }

    boolean checkAccessorsUsable() throws SQLException {
        int n2 = this.accessors.length;
        if (n2 < this.numberOfDefinePositions) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            Accessor accessor = this.accessors[i2];
            if (accessor == null || accessor.externalType == 0) {
                bl = false;
                continue;
            }
            bl2 = true;
        }
        if (bl) {
            bl3 = true;
        } else {
            if (bl2) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.columnsDefinedByUser = false;
        }
        return bl3;
    }

    void executeMaybeDescribe() throws SQLException {
        boolean bl = true;
        if (this.rowPrefetchChanged) {
            if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
        if (!this.needToPrepareDefineBuffer) {
            if (this.accessors == null) {
                this.needToPrepareDefineBuffer = true;
            } else if (this.columnsDefinedByUser) {
                this.needToPrepareDefineBuffer = !this.checkAccessorsUsable();
            }
        }
        boolean bl2 = false;
        try {
            this.isExecuting = true;
            if (this.needToPrepareDefineBuffer) {
                if (!this.columnsDefinedByUser) {
                    this.executeForDescribe();
                    bl2 = true;
                    if (this.aFetchWasDoneDuringDescribe) {
                        bl = false;
                    }
                }
                if (this.needToPrepareDefineBuffer) {
                    this.prepareAccessors();
                }
            }
            int n2 = this.accessors.length;
            for (int i2 = this.numberOfDefinePositions; i2 < n2; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null) continue;
                accessor.rowSpaceIndicator = null;
            }
            if (bl) {
                this.executeForRows(bl2);
            }
        }
        catch (SQLException sQLException) {
            this.needToParse = true;
            throw sQLException;
        }
        finally {
            this.isExecuting = false;
        }
    }

    void adjustGotLastBatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExecuteWithTimeout() throws SQLException {
        block25: {
            try {
                this.cleanOldTempLobs();
                this.connection.registerHeartbeat();
                this.rowsProcessed = 0;
                if (this.sqlKind == 0) {
                    if (this.connection.j2ee13Compliant && this.executionType == 2) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 129);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    this.connection.needLine();
                    if (!this.isOpen) {
                        this.connection.open(this);
                        this.isOpen = true;
                    }
                    if (this.queryTimeout != 0) {
                        try {
                            this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                            this.executeMaybeDescribe();
                        }
                        finally {
                            this.connection.getTimeout().cancelTimeout();
                        }
                    } else {
                        this.executeMaybeDescribe();
                    }
                    this.checkValidRowsStatus();
                    if (this.serverCursor) {
                        this.adjustGotLastBatch();
                    }
                    break block25;
                }
                if (this.connection.j2ee13Compliant && this.sqlKind != 1 && this.sqlKind != 4 && this.executionType == 1) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                ++this.currentRank;
                if (this.currentRank < this.batch) break block25;
                try {
                    this.connection.needLine();
                    if (!this.isOpen) {
                        this.connection.open(this);
                        this.isOpen = true;
                    }
                    if (this.queryTimeout != 0) {
                        this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                    }
                    this.isExecuting = true;
                    this.executeForRows(false);
                }
                catch (SQLException sQLException) {
                    this.needToParse = true;
                    if (this.batch > 1) {
                        int n2;
                        int[] nArray;
                        this.clearBatch();
                        if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch < this.batch) {
                            nArray = new int[this.numberOfExecutedElementsInBatch];
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                nArray[n2] = -2;
                            }
                        } else {
                            nArray = new int[this.batch];
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                nArray[n2] = -3;
                            }
                        }
                        BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(sQLException, nArray.length, nArray);
                        batchUpdateException.fillInStackTrace();
                        throw batchUpdateException;
                    }
                    this.resetCurrentRowBinders();
                    throw sQLException;
                }
                finally {
                    if (this.queryTimeout != 0) {
                        this.connection.getTimeout().cancelTimeout();
                    }
                    this.currentRank = 0;
                    this.isExecuting = false;
                    this.checkValidRowsStatus();
                }
            }
            catch (SQLException sQLException) {
                this.resetOnExceptionDuringExecute();
                throw sQLException;
            }
        }
        this.connection.registerHeartbeat();
    }

    void resetOnExceptionDuringExecute() {
        this.needToParse = true;
    }

    void resetCurrentRowBinders() {
    }

    void open() throws SQLException {
        if (!this.isOpen) {
            this.connection.needLine();
            this.connection.open(this);
            this.isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet oracleResultSet = null;
            try {
                this.executionType = 1;
                this.noMoreUpdateCounts = false;
                this.ensureOpen();
                this.checkIfJdbcBatchExists();
                this.sendBatch();
                this.hasStream = false;
                this.sqlObject.initialize(string);
                this.sqlKind = this.sqlObject.getSqlKind();
                this.needToParse = true;
                this.prepareForNewResults(true, true);
                if (this.userRsetType == 1) {
                    this.doExecuteWithTimeout();
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    oracleResultSet = this.currentResultSet;
                } else {
                    oracleResultSet = this.doScrollStmtExecuteQuery();
                    if (oracleResultSet == null) {
                        this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                        oracleResultSet = this.currentResultSet;
                    }
                }
            }
            finally {
                this.executionType = (byte)-1;
            }
            return oracleResultSet;
        }
    }

    @Override
    public void closeWithKey(String string) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.closeOrCache(null);
        }
    }

    protected void closeOrCache(String string) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
            if (string == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement((OraclePreparedStatement)this, string);
            } else {
                this.cacheState = 0;
                this.hardClose();
            }
        } else {
            this.hardClose();
        }
    }

    protected void hardClose() throws SQLException {
        this.hardClose(true);
    }

    private void hardClose(boolean bl) throws SQLException {
        this.alwaysOnClose();
        this.describedWithNames = false;
        this.described = false;
        this.connection.removeStatement(this);
        this.cleanupDefines();
        if (this.isOpen && bl && (this.connection.lifecycle == 1 || this.connection.lifecycle == 16 || this.connection.lifecycle == 2)) {
            this.connection.registerHeartbeat();
            if (this.connection.lifecycle == 2) {
                this.connection.needLineUnchecked();
            } else {
                this.connection.needLine();
            }
            this.doClose();
            this.isOpen = false;
        }
        this.sqlObject = null;
    }

    protected void alwaysOnClose() throws SQLException {
        OracleStatement oracleStatement = this.children;
        while (oracleStatement != null) {
            OracleStatement oracleStatement2 = oracleStatement.nextChild;
            oracleStatement.close();
            oracleStatement = oracleStatement2;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.closed = true;
        if (this.connection.lifecycle == 1 || this.connection.lifecycle == 2) {
            if (this.currentResultSet != null) {
                this.currentResultSet.internal_close(false);
                this.currentResultSet = null;
            }
            if (this.scrollRset != null) {
                this.scrollRset.close();
                this.scrollRset = null;
            }
            if (this.returnResultSet != null) {
                this.returnResultSet.close();
                this.returnResultSet = null;
            }
        }
        this.clearWarnings();
        this.m_batchItems = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                return;
            }
            this.hardClose(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setNonAutoKey();
            return this.executeUpdateInternal(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeUpdateInternal(String string) throws SQLException {
        try {
            if (this.executionType == -1) {
                this.executionType = (byte)2;
            }
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfJdbcBatchExists();
            this.sendBatch();
            this.hasStream = false;
            this.sqlObject.initialize(string);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true);
            if (this.userRsetType == 1) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            int n2 = this.validRows;
            return n2;
        }
        finally {
            this.executionType = (byte)-1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setNonAutoKey();
            return this.executeInternal(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeInternal(String string) throws SQLException {
        try {
            this.executionType = (byte)3;
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfJdbcBatchExists();
            this.sendBatch();
            this.hasStream = false;
            this.sqlObject.initialize(string);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true);
            if (this.userRsetType == 1) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            boolean bl = this.sqlKind == 0;
            return bl;
        }
        finally {
            this.executionType = (byte)-1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfColumns() throws SQLException {
        this.ensureOpen();
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.doDescribe(false);
                this.described = true;
            }
        }
        return this.numberOfDefinePositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor[] getDescription() throws SQLException {
        this.ensureOpen();
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.doDescribe(false);
                this.described = true;
            }
        }
        return this.accessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor[] getDescriptionWithNames() throws SQLException {
        this.ensureOpen();
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
            }
        }
        return this.accessors;
    }

    byte getSqlKind() {
        return this.sqlKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.freeLine();
            this.streamList = null;
            this.columnsDefinedByUser = false;
            this.needToPrepareDefineBuffer = true;
            this.numberOfDefinePositions = 0;
            this.definesBatchSize = 0;
            this.described = false;
            this.describedWithNames = false;
            this.cleanupDefines();
        }
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
    }

    void defineColumnTypeInternal(int n2, int n3, int n4, boolean bl, String string) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, (short)1, bl, string);
    }

    void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        int n5;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (n2 < 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n3 == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n6 = n2 - 1;
        int n7 = n5 = this.maxFieldSize > 0 ? this.maxFieldSize : -1;
        if (bl) {
            if (n3 == 1 || n3 == 12) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
            }
        } else {
            if (n4 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n5 == -1 && n4 > 0 || n5 > 0 && n4 < n5) {
                n5 = n4;
            }
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.columnsDefinedByUser) {
            this.clearDefines();
            this.columnsDefinedByUser = true;
        }
        if (this.numberOfDefinePositions < n2) {
            if (this.accessors == null || this.accessors.length < n2) {
                Accessor[] accessorArray = new Accessor[n2 << 1];
                if (this.accessors != null) {
                    System.arraycopy(this.accessors, 0, accessorArray, 0, this.numberOfDefinePositions);
                }
                this.accessors = accessorArray;
            }
            this.numberOfDefinePositions = n2;
        }
        switch (n3) {
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                s2 = (short)2;
                break;
            }
        }
        int n8 = this.getInternalType(n3);
        if (!(n8 != 109 && n8 != 111 || string != null && !string.equals(""))) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = this.accessors[n6];
        boolean bl2 = true;
        if (accessor != null) {
            int n9 = accessor.useForDataAccessIfPossible(n8, n3, n5, string);
            if (n9 == 0) {
                s2 = accessor.formOfUse;
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n9 == 1) {
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n9 == 2) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.needToPrepareDefineBuffer = true;
        }
        if (accessor == null) {
            this.accessors[n6] = this.allocateAccessor(n8, n3, n2, n5, s2, string, false);
            this.described = false;
            this.describedWithNames = false;
        }
    }

    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        switch (n2) {
            case 96: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new CharAccessor(this, n5, s2, n3, bl);
            }
            case 8: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!bl) {
                    return new LongAccessor(this, n4, n5, s2, n3);
                }
            }
            case 1: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new VarcharAccessor(this, n5, s2, n3, bl);
            }
            case 2: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new NumberAccessor(this, n5, s2, n3, bl);
            }
            case 6: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new VarnumAccessor(this, n5, s2, n3, bl);
            }
            case 24: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!bl) {
                    return new LongRawAccessor(this, n4, n5, s2, n3);
                }
            }
            case 23: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (bl) {
                    return new OutRawAccessor(this, n5, s2, n3);
                }
                return new RawAccessor(this, n5, s2, n3, false);
            }
            case 100: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new BinaryFloatAccessor(this, n5, s2, n3, bl);
            }
            case 101: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new BinaryDoubleAccessor(this, n5, s2, n3, bl);
            }
            case 104: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new RowidAccessor(this, n5, s2, n3, bl);
            }
            case 102: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new ResultSetAccessor(this, n5, s2, n3, bl);
            }
            case 12: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new DateAccessor(this, n5, s2, n3, bl);
            }
            case 113: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                BlobAccessor blobAccessor = new BlobAccessor(this, -1, s2, n3, bl);
                if (!bl) {
                    blobAccessor.lobPrefetchSizeForThisColumn = n5;
                }
                return blobAccessor;
            }
            case 112: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                ClobAccessor clobAccessor = new ClobAccessor(this, -1, s2, n3, bl);
                if (!bl) {
                    clobAccessor.lobPrefetchSizeForThisColumn = n5;
                }
                return clobAccessor;
            }
            case 114: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                BfileAccessor bfileAccessor = new BfileAccessor(this, -1, s2, n3, bl);
                return bfileAccessor;
            }
            case 109: {
                if (string == null) {
                    if (bl) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                NamedTypeAccessor namedTypeAccessor = new NamedTypeAccessor(this, string, s2, n3, bl);
                ((Accessor)namedTypeAccessor).initMetadata();
                return namedTypeAccessor;
            }
            case 111: {
                if (string == null) {
                    if (bl) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                RefTypeAccessor refTypeAccessor = new RefTypeAccessor(this, string, s2, n3, bl);
                ((Accessor)refTypeAccessor).initMetadata();
                return refTypeAccessor;
            }
            case 180: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new TimestampAccessor(this, n5, s2, n3, bl);
            }
            case 181: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new TimestamptzAccessor(this, n5, s2, n3, bl);
            }
            case 231: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new TimestampltzAccessor(this, n5, s2, n3, bl);
            }
            case 182: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new IntervalymAccessor(this, n5, s2, n3, bl);
            }
            case 183: {
                if (bl && string != null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                return new IntervaldsAccessor(this, n5, s2, n3, bl);
            }
            case 995: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.defineColumnTypeInternal(n2, n3, -1, true, null);
        }
    }

    @Override
    public void defineColumnType(int n2, int n3, int n4) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, false, null);
    }

    @Override
    public void defineColumnType(int n2, int n3, int n4, short s2) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, s2, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnTypeBytes(int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.defineColumnTypeInternal(n2, n3, n4, false, null);
        }
    }

    @Override
    public void defineColumnTypeChars(int n2, int n3, int n4) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int n2, int n3, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.defineColumnTypeInternal(n2, n3, -1, true, string);
        }
    }

    void setCursorId(int n2) throws SQLException {
        this.cursorId = n2;
    }

    void setPrefetchInternal(int n2, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            if (n2 <= 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 20);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else {
            if (n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == 0) {
                n2 = this.connection.getDefaultRowPrefetch();
            }
        }
        if (bl2) {
            if (n2 != this.defaultRowPrefetch) {
                this.defaultRowPrefetch = n2;
                if (this.currentResultSet == null || this.currentResultSet.closed) {
                    this.rowPrefetchChanged = true;
                }
            }
        } else if (n2 != this.rowPrefetch && this.streamList == null) {
            this.rowPrefetch = n2;
            this.rowPrefetchChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowPrefetch(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setPrefetchInternal(n2, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLobPrefetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 < -1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 360);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.defaultLobPrefetchSize = n2;
        }
    }

    @Override
    public int getLobPrefetchSize() {
        return this.defaultLobPrefetchSize;
    }

    int getPrefetchInternal(boolean bl) {
        int n2 = bl ? this.defaultRowPrefetch : this.rowPrefetch;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowPrefetch() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getPrefetchInternal(true);
        }
    }

    @Override
    public void setFixedString(boolean bl) {
        this.fixedString = bl;
    }

    @Override
    public boolean getFixedString() {
        return this.fixedString;
    }

    void check_row_prefetch_changed() throws SQLException {
        if (this.rowPrefetchChanged) {
            if (this.streamList == null) {
                this.prepareAccessors();
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
    }

    void setDefinesInitialized(boolean bl) {
    }

    void printState(String string) throws SQLException {
    }

    void checkValidRowsStatus() throws SQLException {
        if (this.validRows == -2) {
            this.validRows = 1;
            this.connection.holdLine(this);
            OracleInputStream oracleInputStream = this.streamList;
            while (oracleInputStream != null) {
                if (oracleInputStream.hasBeenOpen) {
                    oracleInputStream = oracleInputStream.accessor.initForNewRow();
                }
                oracleInputStream.closed = false;
                oracleInputStream.hasBeenOpen = true;
                oracleInputStream = oracleInputStream.nextStream;
            }
            this.nextStream = this.streamList;
        } else if (this.sqlKind == 0) {
            if (this.validRows < this.rowPrefetch) {
                this.gotLastBatch = true;
            }
        } else if (this.sqlKind != 1 && this.sqlKind != 4) {
            this.rowsProcessed = this.validRows;
        }
    }

    void cleanupDefines() {
        if (this.accessors != null) {
            for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                this.accessors[i2] = null;
            }
        }
        this.accessors = null;
        this.connection.cacheBuffer(this.defineBytes);
        this.defineBytes = null;
        this.connection.cacheBuffer(this.defineChars);
        this.defineChars = null;
        this.defineIndicators = null;
        this.defineMetaData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxFieldSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.maxFieldSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.maxFieldSize = n2;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.maxRows = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.processEscapes = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.queryTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.queryTimeout = n2;
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.doCancel();
    }

    boolean doCancel() throws SQLException {
        boolean bl = false;
        if (this.closed) {
            return bl;
        }
        if (this.connection.statementHoldingLine != null) {
            this.freeLine();
        } else if (this.isExecuting) {
            bl = true;
            this.connection.cancelOperationOnServer();
        }
        OracleStatement oracleStatement = this.children;
        while (oracleStatement != null) {
            bl = bl || oracleStatement.doCancel();
            oracleStatement = oracleStatement.nextChild;
        }
        this.connection.releaseLineForCancel();
        return bl;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    void foundPlsqlCompilerWarning() throws SQLException {
        SQLWarning sQLWarning = DatabaseError.addSqlWarning(this.sqlWarning, "Found Plsql compiler warnings.", 24439);
        if (this.sqlWarning != null) {
            this.sqlWarning.setNextWarning(sQLWarning);
        } else {
            this.sqlWarning = sQLWarning;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.userRsetType == 1) {
                if (this.sqlKind == 0) {
                    if (this.currentResultSet == null) {
                        this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    }
                    return this.currentResultSet;
                }
            } else {
                return this.scrollRset;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2 = -1;
            switch (this.sqlKind) {
                case -1: 
                case 0: {
                    break;
                }
                case 3: {
                    if (!this.noMoreUpdateCounts) {
                        n2 = this.rowsProcessed;
                    }
                    this.noMoreUpdateCounts = true;
                    break;
                }
                case 1: 
                case 4: {
                    this.noMoreUpdateCounts = true;
                    break;
                }
                case 2: {
                    if (!this.noMoreUpdateCounts) {
                        n2 = this.rowsProcessed;
                    }
                    this.noMoreUpdateCounts = true;
                }
            }
            return n2;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public int sendBatch() throws SQLException {
        return 0;
    }

    void prepareForNewResults(boolean bl, boolean bl2) throws SQLException {
        this.clearWarnings();
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (bl2) {
                OracleInputStream oracleInputStream = this.streamList;
                OracleInputStream oracleInputStream2 = null;
                this.streamList = null;
                while (oracleInputStream != null) {
                    if (!oracleInputStream.hasBeenOpen) {
                        if (oracleInputStream2 == null) {
                            this.streamList = oracleInputStream;
                        } else {
                            oracleInputStream2.nextStream = oracleInputStream;
                        }
                        oracleInputStream2 = oracleInputStream;
                    }
                    oracleInputStream = oracleInputStream.nextStream;
                }
            }
        }
        if (this.currentResultSet != null) {
            this.currentResultSet.internal_close(true);
            this.currentResultSet = null;
        }
        this.currentRow = -1;
        this.validRows = 0;
        if (bl) {
            this.totalRowsVisited = 0;
        }
        this.gotLastBatch = false;
        if (this.needToParse && !this.columnsDefinedByUser) {
            if (bl2 && this.numberOfDefinePositions != 0) {
                this.numberOfDefinePositions = 0;
            }
            this.needToPrepareDefineBuffer = true;
        }
        if (bl && this.rowPrefetch != this.defaultRowPrefetch && this.streamList == null) {
            this.rowPrefetch = this.defaultRowPrefetch;
            this.rowPrefetchChanged = true;
        }
    }

    void reopenStreams() throws SQLException {
        OracleInputStream oracleInputStream = this.streamList;
        while (oracleInputStream != null) {
            if (oracleInputStream.hasBeenOpen) {
                oracleInputStream = oracleInputStream.accessor.initForNewRow();
            }
            oracleInputStream.closed = false;
            oracleInputStream.hasBeenOpen = true;
            oracleInputStream = oracleInputStream.nextStream;
        }
        this.nextStream = this.streamList;
    }

    void endOfResultSet(boolean bl) throws SQLException {
        if (!bl) {
            this.prepareForNewResults(false, false);
        }
        this.clearDefines();
        this.rowPrefetchInLastFetch = -1;
    }

    boolean wasNullValue() throws SQLException {
        if (this.lastIndex == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.sqlKind == 0) {
            return this.accessors[this.lastIndex - 1].isNull(this.currentRow);
        }
        return this.outBindAccessors[this.lastIndex - 1].isNull(this.currentRank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getColumnIndex(String string) throws SQLException {
        Object object;
        this.ensureOpen();
        if (!this.describedWithNames) {
            object = this.connection;
            synchronized (object) {
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
            }
        }
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            if (!this.accessors[i2].columnName.equalsIgnoreCase(string)) continue;
            return i2 + 1;
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    int getJDBCType(int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case 6: {
                n3 = 2;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case 999: {
                n3 = 999;
                break;
            }
            case 96: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 12;
                break;
            }
            case 8: {
                n3 = -1;
                break;
            }
            case 12: {
                n3 = 91;
                break;
            }
            case 180: {
                n3 = 93;
                break;
            }
            case 181: {
                n3 = -101;
                break;
            }
            case 231: {
                n3 = -102;
                break;
            }
            case 182: {
                n3 = -103;
                break;
            }
            case 183: {
                n3 = -104;
                break;
            }
            case 23: {
                n3 = -2;
                break;
            }
            case 24: {
                n3 = -4;
                break;
            }
            case 104: {
                n3 = -8;
                break;
            }
            case 113: {
                n3 = 2004;
                break;
            }
            case 112: {
                n3 = 2005;
                break;
            }
            case 114: {
                n3 = -13;
                break;
            }
            case 102: {
                n3 = -10;
                break;
            }
            case 109: {
                n3 = 2002;
                break;
            }
            case 111: {
                n3 = 2006;
                break;
            }
            case 998: {
                n3 = -14;
                break;
            }
            case 995: {
                n3 = 0;
                break;
            }
            default: {
                n3 = n2;
            }
        }
        return n3;
    }

    int getInternalType(int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 6;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case 999: {
                n3 = 999;
                break;
            }
            case 1: {
                n3 = 96;
                break;
            }
            case -15: 
            case -9: 
            case 12: {
                n3 = 1;
                break;
            }
            case -16: 
            case -1: {
                n3 = 8;
                break;
            }
            case 91: 
            case 92: {
                n3 = 12;
                break;
            }
            case -100: 
            case 93: {
                n3 = 180;
                break;
            }
            case -101: {
                n3 = 181;
                break;
            }
            case -102: {
                n3 = 231;
                break;
            }
            case -103: {
                n3 = 182;
                break;
            }
            case -104: {
                n3 = 183;
                break;
            }
            case -3: 
            case -2: {
                n3 = 23;
                break;
            }
            case -4: {
                n3 = 24;
                break;
            }
            case -8: {
                n3 = 104;
                break;
            }
            case 2004: {
                n3 = 113;
                break;
            }
            case 2005: 
            case 2011: {
                n3 = 112;
                break;
            }
            case -13: {
                n3 = 114;
                break;
            }
            case -10: {
                n3 = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                n3 = 109;
                break;
            }
            case 2006: {
                n3 = 111;
                break;
            }
            case -14: {
                n3 = 998;
                break;
            }
            case 70: {
                n3 = 1;
                break;
            }
            case 0: {
                n3 = 995;
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, Integer.toString(n2));
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (!this.described) {
                this.doDescribe(false);
            }
        }
    }

    void freeLine() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    void closeUsedStreams(int n2) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < n2) {
            try {
                this.nextStream.close();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.nextStream = this.nextStream.nextStream;
        }
    }

    final void ensureOpen() throws SQLException {
        if (this.connection.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void allocateTmpByteArray() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 == 1000) {
                this.defaultFetchDirection = n2;
            } else if (n2 == 1001 || n2 == 1002) {
                this.defaultFetchDirection = 1000;
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.defaultFetchDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setPrefetchInternal(n2, false, true);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getPrefetchInternal(true);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return ResultSetUtil.getUpdateConcurrency(this.userRsetType);
    }

    @Override
    public int getResultSetType() throws SQLException {
        return ResultSetUtil.getScrollType(this.userRsetType);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection.getWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResultSetCache(oracle.jdbc.OracleResultSetCache oracleResultSetCache) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (oracleResultSetCache == null) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.rsetCache != null) {
                    this.rsetCache.close();
                }
                this.rsetCache = oracleResultSetCache;
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSetCache(OracleResultSetCache oracleResultSetCache) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setResultSetCache((oracle.jdbc.OracleResultSetCache)oracleResultSetCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSetCache getResultSetCache() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return (OracleResultSetCache)this.rsetCache;
        }
    }

    boolean isOracleBatchStyle() {
        return false;
    }

    void initBatch() {
    }

    int getBatchSize() {
        return this.m_batchItems.size();
    }

    void addBatchItem(String string) {
        this.m_batchItems.addElement(string);
    }

    String getBatchItem(int n2) {
        return (String)this.m_batchItems.elementAt(n2);
    }

    void clearBatchItems() {
        this.m_batchItems.removeAllElements();
    }

    void checkIfJdbcBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.addBatchItem(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.clearBatchItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.cleanOldTempLobs();
            int n2 = 0;
            int n3 = this.getBatchSize();
            if (n3 <= 0) {
                return new int[0];
            }
            int[] nArray = new int[n3];
            this.ensureOpen();
            this.prepareForNewResults(true, true);
            int n4 = this.numberOfDefinePositions;
            String string = this.sqlObject.getOriginalSql();
            byte by = this.sqlKind;
            this.noMoreUpdateCounts = false;
            int n5 = 0;
            try {
                this.connection.registerHeartbeat();
                this.connection.needLine();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.sqlObject.initialize(this.getBatchItem(n2));
                    this.sqlKind = this.sqlObject.getSqlKind();
                    this.needToParse = true;
                    this.numberOfDefinePositions = 0;
                    this.rowsProcessed = 0;
                    this.currentRank = 1;
                    if (this.sqlKind == 0) {
                        BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(80, "invalid SELECT batch command " + n2, n2, nArray);
                        batchUpdateException.fillInStackTrace();
                        throw batchUpdateException;
                    }
                    if (!this.isOpen) {
                        this.connection.open(this);
                        this.isOpen = true;
                    }
                    int n6 = -1;
                    try {
                        if (this.queryTimeout != 0) {
                            this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                        }
                        this.isExecuting = true;
                        this.executeForRows(false);
                        if (this.validRows > 0) {
                            n5 += this.validRows;
                        }
                        n6 = this.validRows;
                    }
                    catch (SQLException sQLException) {
                        this.needToParse = true;
                        this.resetCurrentRowBinders();
                        throw sQLException;
                    }
                    finally {
                        if (this.queryTimeout != 0) {
                            this.connection.getTimeout().cancelTimeout();
                        }
                        this.validRows = n5;
                        this.checkValidRowsStatus();
                        this.isExecuting = false;
                    }
                    nArray[n2] = n6;
                    if (nArray[n2] >= 0) continue;
                    BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(81, "command return value " + nArray[n2], n2, nArray);
                    batchUpdateException.fillInStackTrace();
                    throw batchUpdateException;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException instanceof BatchUpdateException) {
                    throw sQLException;
                }
                BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(81, sQLException.getMessage(), n2, nArray);
                batchUpdateException.fillInStackTrace();
                throw batchUpdateException;
            }
            finally {
                this.clearBatchItems();
                this.numberOfDefinePositions = n4;
                if (string != null) {
                    this.sqlObject.initialize(string);
                    this.sqlKind = by;
                }
                this.currentRank = 0;
            }
            this.connection.registerHeartbeat();
            return nArray;
        }
    }

    @Override
    public int copyBinds(Statement statement, int n2) throws SQLException {
        return 0;
    }

    @Override
    public void notifyCloseRset() throws SQLException {
        this.scrollRset = null;
        this.endOfResultSet(false);
    }

    @Override
    public String getOriginalSql() throws SQLException {
        return this.sqlObject.getOriginalSql();
    }

    void doScrollExecuteCommon() throws SQLException {
        if (this.scrollRset != null) {
            this.scrollRset.close();
            this.scrollRset = null;
        }
        if (this.sqlKind != 0) {
            this.doExecuteWithTimeout();
            return;
        }
        if (!this.needToAddIdentifier) {
            this.doExecuteWithTimeout();
            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
            this.realRsetType = this.userRsetType;
        } else {
            try {
                this.sqlObject.setIncludeRowid(true);
                this.needToParse = true;
                this.prepareForNewResults(true, false);
                if (this.columnsDefinedByUser) {
                    Accessor[] accessorArray = this.accessors;
                    if (this.accessors == null || this.accessors.length <= this.numberOfDefinePositions) {
                        this.accessors = new Accessor[this.numberOfDefinePositions + 1];
                    }
                    if (accessorArray != null) {
                        for (int i2 = this.numberOfDefinePositions; i2 > 0; --i2) {
                            Accessor accessor;
                            this.accessors[i2] = accessor = accessorArray[i2 - 1];
                            if (!accessor.isColumnNumberAware) continue;
                            accessor.updateColumnNumber(i2);
                        }
                    }
                    this.allocateRowidAccessor();
                    ++this.numberOfDefinePositions;
                }
                this.doExecuteWithTimeout();
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.realRsetType = this.userRsetType;
            }
            catch (SQLException sQLException) {
                this.realRsetType = this.userRsetType > 3 ? 3 : 1;
                this.sqlObject.setIncludeRowid(false);
                this.needToParse = true;
                this.prepareForNewResults(true, false);
                if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = true;
                    --this.numberOfDefinePositions;
                    System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
                    this.accessors[this.numberOfDefinePositions] = null;
                    for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                        Accessor accessor = this.accessors[i3];
                        if (!accessor.isColumnNumberAware) continue;
                        accessor.updateColumnNumber(i3);
                    }
                }
                this.doExecuteWithTimeout();
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, sQLException.getMessage());
            }
        }
        this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
    }

    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        this.doScrollExecuteCommon();
        return this.scrollRset;
    }

    void processDmlReturningBind() throws SQLException {
        if (this.returnResultSet != null) {
            this.returnResultSet.close();
        }
        this.returnParamsFetched = false;
        this.returnParamRowBytes = 0;
        this.returnParamRowChars = 0;
        int n2 = 0;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            Accessor accessor = this.returnParamAccessors[i2];
            if (accessor == null) continue;
            ++n2;
            if (accessor.charLength > 0) {
                this.returnParamRowChars += accessor.charLength;
                continue;
            }
            this.returnParamRowBytes += accessor.byteLength;
        }
        if (this.isAutoGeneratedKey) {
            this.numReturnParams = n2;
        } else {
            if (this.numReturnParams <= 0) {
                this.numReturnParams = this.sqlObject.getReturnParameterCount();
            }
            if (this.numReturnParams != n2) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        this.returnParamMeta[0] = this.numReturnParams;
        this.returnParamMeta[1] = this.returnParamRowBytes;
        this.returnParamMeta[2] = this.returnParamRowChars;
    }

    void allocateDmlReturnStorage() {
        if (this.rowsDmlReturned == 0) {
            return;
        }
        int n2 = this.returnParamRowBytes * this.rowsDmlReturned;
        int n3 = this.returnParamRowChars * this.rowsDmlReturned;
        int n4 = 2 * this.numReturnParams * this.rowsDmlReturned;
        this.returnParamBytes = new byte[n2];
        this.returnParamChars = new char[n3];
        this.returnParamIndicators = new short[n4];
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            Accessor accessor = this.returnParamAccessors[i2];
            if (accessor == null || accessor.internalType != 111 && accessor.internalType != 109) continue;
            TypeAccessor typeAccessor = (TypeAccessor)accessor;
            if (typeAccessor.pickledBytes != null && typeAccessor.pickledBytes.length >= this.rowsDmlReturned) continue;
            typeAccessor.pickledBytes = new byte[this.rowsDmlReturned][];
        }
    }

    void fetchDmlReturnParams() throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void setupReturnParamAccessors() {
        if (this.rowsDmlReturned == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.numReturnParams * this.rowsDmlReturned;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            Accessor accessor = this.returnParamAccessors[i2];
            if (accessor == null) continue;
            if (accessor.charLength > 0) {
                accessor.rowSpaceChar = this.returnParamChars;
                accessor.columnIndex = n3;
                n3 += this.rowsDmlReturned * accessor.charLength;
            } else {
                accessor.rowSpaceByte = this.returnParamBytes;
                accessor.columnIndex = n2;
                n2 += this.rowsDmlReturned * accessor.byteLength;
            }
            accessor.rowSpaceIndicator = this.returnParamIndicators;
            accessor.indicatorIndex = n4;
            n4 += this.rowsDmlReturned;
            accessor.lengthIndex = n5;
            n5 += this.rowsDmlReturned;
        }
    }

    void registerReturnParameterInternal(int n2, int n3, int n4, int n5, short s2, String string) throws SQLException {
        if (this.returnParamAccessors == null) {
            this.returnParamAccessors = new Accessor[this.numberOfBindPositions];
        }
        if (this.returnParamMeta == null) {
            this.returnParamMeta = new int[3 + this.numberOfBindPositions * 3];
        }
        switch (n4) {
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                s2 = (short)2;
                break;
            }
        }
        Accessor accessor = this.allocateAccessor(n3, n4, n2 + 1, n5, s2, string, true);
        accessor.isDMLReturnedParam = true;
        this.returnParamAccessors[n2] = accessor;
        boolean bl = accessor.charLength > 0;
        this.returnParamMeta[3 + n2 * 3 + 0] = accessor.defineType;
        this.returnParamMeta[3 + n2 * 3 + 1] = bl ? 1 : 0;
        this.returnParamMeta[3 + n2 * 3 + 2] = bl ? accessor.charLength : accessor.byteLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int creationState() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.creationState;
        }
    }

    public boolean isColumnSetNull(int n2) {
        return this.columnSetNull;
    }

    @Override
    public boolean isNCHAR(int n2) throws SQLException {
        int n3;
        if (!this.described) {
            this.describe();
        }
        if ((n3 = n2 - 1) < 0 || n3 >= this.numberOfDefinePositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = this.accessors[n3].formOfUse == 2;
        return bl;
    }

    void addChild(OracleStatement oracleStatement) {
        oracleStatement.nextChild = this.children;
        this.children = oracleStatement;
        oracleStatement.parent = this;
    }

    void removeChild(OracleStatement oracleStatement) {
        if (oracleStatement == this.children) {
            this.children = oracleStatement.nextChild;
        } else {
            OracleStatement oracleStatement2 = this.children;
            while (oracleStatement2.nextChild != oracleStatement) {
                oracleStatement2 = oracleStatement2.nextChild;
            }
            oracleStatement2.nextChild = oracleStatement.nextChild;
        }
        oracleStatement.parent = null;
        oracleStatement.nextChild = null;
    }

    @Override
    public boolean getMoreResults(int n2) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.isAutoGeneratedKey) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.returnParamAccessors == null || this.numReturnParams == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.returnResultSet == null) {
            this.returnResultSet = new OracleReturnResultSet(this);
        }
        return this.returnResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        if (n2 == 2 || !AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.executeUpdate(string);
        }
        if (n2 != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.autoKeyInfo = new AutoKeyInfo(string);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = 1;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeUpdateInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.executeUpdate(string);
        }
        if (nArray == null || nArray.length == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.autoKeyInfo = new AutoKeyInfo(string, nArray);
            this.connection.doDescribeTable(this.autoKeyInfo);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = nArray.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeUpdateInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.executeUpdate(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.autoKeyInfo = new AutoKeyInfo(string, stringArray);
            this.connection.doDescribeTable(this.autoKeyInfo);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = stringArray.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeUpdateInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n2) throws SQLException {
        if (n2 == 2 || !AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.execute(string);
        }
        if (n2 != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.autoKeyInfo = new AutoKeyInfo(string);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = 1;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.execute(string);
        }
        if (nArray == null || nArray.length == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.autoKeyInfo = new AutoKeyInfo(string, nArray);
            this.connection.doDescribeTable(this.autoKeyInfo);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = nArray.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeInternal(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.execute(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.autoKeyInfo = new AutoKeyInfo(string, stringArray);
            this.connection.doDescribeTable(this.autoKeyInfo);
            String string2 = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = stringArray.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            return this.executeInternal(string2);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getcacheState() {
        return this.cacheState;
    }

    @Override
    public int getstatementType() {
        return this.statementType;
    }

    @Override
    public boolean getserverCursor() {
        return this.serverCursor;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = 0;
    }

    private void autoKeyRegisterReturnParams() throws SQLException {
        this.initializeIndicatorSubRange();
        int n2 = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
        int n3 = n2 + 2 * this.numberOfBindPositions;
        this.bindIndicators = new short[n3];
        int n4 = this.bindIndicatorSubRange;
        this.bindIndicators[n4 + 0] = (short)this.numberOfBindPositions;
        this.bindIndicators[n4 + 1] = 0;
        this.bindIndicators[n4 + 2] = 1;
        this.bindIndicators[n4 + 3] = 0;
        this.bindIndicators[n4 + 4] = 1;
        n4 += 5;
        short[] sArray = this.autoKeyInfo.tableFormOfUses;
        int[] nArray = this.autoKeyInfo.columnIndexes;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            short s2;
            this.bindIndicators[n4 + 0] = 994;
            short s3 = s2 = this.connection.defaultnchar ? (short)2 : 1;
            if (sArray != null && nArray != null && sArray[nArray[i2] - 1] == 2) {
                this.bindIndicators[n4 + 9] = s2 = 2;
            }
            n4 += 10;
            this.checkTypeForAutoKey(this.autoKeyInfo.returnTypes[i2]);
            String string = null;
            if (this.autoKeyInfo.returnTypes[i2] == 111) {
                string = this.autoKeyInfo.tableTypeNames[nArray[i2] - 1];
            }
            this.registerReturnParameterInternal(i2, this.autoKeyInfo.returnTypes[i2], this.autoKeyInfo.returnTypes[i2], -1, s2, string);
        }
    }

    private final void setNonAutoKey() {
        this.isAutoGeneratedKey = false;
        this.numberOfBindPositions = 0;
        this.bindIndicators = null;
        this.returnParamMeta = null;
    }

    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
        if (cArray != this.defineChars) {
            this.connection.cacheBuffer(cArray);
        }
        if (byArray != this.defineBytes) {
            this.connection.cacheBuffer(byArray);
        }
    }

    final void checkTypeForAutoKey(int n2) throws SQLException {
        if (n2 == 109) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 5);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void addToTempLobsToFree(CLOB cLOB) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(cLOB);
    }

    void addToTempLobsToFree(BLOB bLOB) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(bLOB);
    }

    void addToOldTempLobsToFree(CLOB cLOB) {
        if (this.oldTempClobsToFree == null) {
            this.oldTempClobsToFree = new ArrayList();
        }
        this.oldTempClobsToFree.add(cLOB);
    }

    void addToOldTempLobsToFree(BLOB bLOB) {
        if (this.oldTempBlobsToFree == null) {
            this.oldTempBlobsToFree = new ArrayList();
        }
        this.oldTempBlobsToFree.add(bLOB);
    }

    void cleanAllTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.tempClobsToFree = null;
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempBlobsToFree = null;
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.oldTempClobsToFree = null;
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempBlobsToFree = null;
    }

    void cleanOldTempLobs() {
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempClobsToFree = this.tempClobsToFree;
        this.tempClobsToFree = null;
        this.oldTempBlobsToFree = this.tempBlobsToFree;
        this.tempBlobsToFree = null;
    }

    void cleanTempClobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((CLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    void cleanTempBlobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((BLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    TimeZone getDefaultTimeZone() {
        return this.getDefaultTimeZone(false);
    }

    TimeZone getDefaultTimeZone(boolean bl) {
        if (this.defaultTimeZone == null) {
            try {
                this.defaultTimeZone = this.connection.getDefaultTimeZone();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (this.defaultTimeZone == null) {
                this.defaultTimeZone = TimeZone.getDefault();
            }
        }
        if (bl && this.defaultTimeZoneName == null) {
            this.defaultTimeZoneName = this.defaultTimeZone.getID();
            this.defaultTimeZoneID = ZONEIDMAP.getID(this.defaultTimeZoneName);
            this.defaultTimeZoneOffsetDST = null;
            try {
                TIMEZONETAB tIMEZONETAB = this.connection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(this.defaultTimeZoneID)) {
                    tIMEZONETAB.updateTable(this.connection, this.defaultTimeZoneID);
                }
                this.defaultTimeZoneOffsetDST = tIMEZONETAB.getOffsetDST(this.defaultTimeZoneID);
            }
            catch (SQLException sQLException) {
                this.defaultTimeZoneOffsetDST = null;
            }
        }
        return this.defaultTimeZone;
    }

    @Override
    public void setDatabaseChangeRegistration(DatabaseChangeRegistration databaseChangeRegistration) throws SQLException {
        this.registration = (NTFDCNRegistration)databaseChangeRegistration;
    }

    @Override
    public String[] getRegisteredTableNames() throws SQLException {
        return this.dcnTableName;
    }

    @Override
    public long getRegisteredQueryId() throws SQLException {
        return this.dcnQueryId;
    }

    Calendar getDefaultCalendar() {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance(this.getDefaultTimeZone());
        }
        return this.defaultCalendar;
    }

    void releaseBuffers() {
        this.cachedDefineIndicatorSize = this.defineIndicators != null ? this.defineIndicators.length : 0;
        this.cachedDefineMetaDataSize = this.defineMetaData != null ? this.defineMetaData.length : 0;
        this.connection.cacheBuffer(this.defineChars);
        this.defineChars = null;
        this.connection.cacheBuffer(this.defineBytes);
        this.defineBytes = null;
        this.defineIndicators = null;
        this.defineMetaData = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.cacheState != 3;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.cacheState = bl ? 1 : 3;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    Calendar getGMTCalendar() {
        if (this.gmtCalendar == null) {
            this.gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        }
        return this.gmtCalendar;
    }

    void extractNioDefineBuffers(int n2) throws SQLException {
    }

    void processLobPrefetchMetaData(Object[] objectArray) {
    }
}

