/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class JWKMatcher {
    private final Set<KeyType> types;
    private final Set<KeyUse> uses;
    private final Set<KeyOperation> ops;
    private final Set<Algorithm> algs;
    private final Set<String> ids;
    private final boolean privateOnly;
    private final boolean publicOnly;
    private final int minSizeBits;
    private final int maxSizeBits;

    @Deprecated
    public JWKMatcher(Set<KeyType> types, Set<KeyUse> uses, Set<KeyOperation> ops, Set<Algorithm> algs, Set<String> ids, boolean privateOnly, boolean publicOnly) {
        this(types, uses, ops, algs, ids, privateOnly, publicOnly, 0, 0);
    }

    public JWKMatcher(Set<KeyType> types, Set<KeyUse> uses, Set<KeyOperation> ops, Set<Algorithm> algs, Set<String> ids, boolean privateOnly, boolean publicOnly, int minSizeBits, int maxSizeBits) {
        this.types = types;
        this.uses = uses;
        this.ops = ops;
        this.algs = algs;
        this.ids = ids;
        this.privateOnly = privateOnly;
        this.publicOnly = publicOnly;
        this.minSizeBits = minSizeBits;
        this.maxSizeBits = maxSizeBits;
    }

    public Set<KeyType> getKeyTypes() {
        return this.types;
    }

    public Set<KeyUse> getKeyUses() {
        return this.uses;
    }

    public Set<KeyOperation> getKeyOperations() {
        return this.ops;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algs;
    }

    public Set<String> getKeyIDs() {
        return this.ids;
    }

    public boolean isPrivateOnly() {
        return this.privateOnly;
    }

    public boolean isPublicOnly() {
        return this.publicOnly;
    }

    public int getMinSize() {
        return this.minSizeBits;
    }

    public int getMaxSize() {
        return this.maxSizeBits;
    }

    public boolean matches(JWK key) {
        if (this.privateOnly && !key.isPrivate()) {
            return false;
        }
        if (this.publicOnly && key.isPrivate()) {
            return false;
        }
        if (this.types != null && !this.types.contains(key.getKeyType())) {
            return false;
        }
        if (this.uses != null && !this.uses.contains((Object)key.getKeyUse())) {
            return false;
        }
        if (!(this.ops == null || this.ops.contains(null) && key.getKeyOperations() == null || key.getKeyOperations() != null && this.ops.containsAll(key.getKeyOperations()))) {
            return false;
        }
        if (this.algs != null && !this.algs.contains(key.getAlgorithm())) {
            return false;
        }
        if (this.ids != null && !this.ids.contains(key.getKeyID())) {
            return false;
        }
        if (this.minSizeBits > 0 && key.size() < this.minSizeBits) {
            return false;
        }
        return this.maxSizeBits <= 0 || key.size() <= this.maxSizeBits;
    }

    public static class Builder {
        private Set<KeyType> types;
        private Set<KeyUse> uses;
        private Set<KeyOperation> ops;
        private Set<Algorithm> algs;
        private Set<String> ids;
        private boolean privateOnly = false;
        private boolean publicOnly = false;
        private int minSizeBits = 0;
        private int maxSizeBits = 0;

        public Builder keyType(KeyType kty) {
            this.types = kty == null ? null : new HashSet<KeyType>(Collections.singletonList(kty));
            return this;
        }

        public Builder keyTypes(KeyType ... types) {
            this.keyTypes(new HashSet<KeyType>(Arrays.asList(types)));
            return this;
        }

        public Builder keyTypes(Set<KeyType> types) {
            this.types = types;
            return this;
        }

        public Builder keyUse(KeyUse use) {
            this.uses = use == null ? null : new HashSet<KeyUse>(Collections.singletonList(use));
            return this;
        }

        public Builder keyUses(KeyUse ... uses) {
            this.keyUses(new HashSet<KeyUse>(Arrays.asList(uses)));
            return this;
        }

        public Builder keyUses(Set<KeyUse> uses) {
            this.uses = uses;
            return this;
        }

        public Builder keyOperation(KeyOperation op) {
            this.ops = op == null ? null : new HashSet<KeyOperation>(Collections.singletonList(op));
            return this;
        }

        public Builder keyOperations(KeyOperation ... ops) {
            this.keyOperations(new HashSet<KeyOperation>(Arrays.asList(ops)));
            return this;
        }

        public Builder keyOperations(Set<KeyOperation> ops) {
            this.ops = ops;
            return this;
        }

        public Builder algorithm(Algorithm alg) {
            this.algs = alg == null ? null : new HashSet<Algorithm>(Collections.singletonList(alg));
            return this;
        }

        public Builder algorithms(Algorithm ... algs) {
            this.algorithms(new HashSet<Algorithm>(Arrays.asList(algs)));
            return this;
        }

        public Builder algorithms(Set<Algorithm> algs) {
            this.algs = algs;
            return this;
        }

        public Builder keyID(String id) {
            this.ids = id == null ? null : new HashSet<String>(Collections.singletonList(id));
            return this;
        }

        public Builder keyIDs(String ... ids) {
            this.keyIDs(new HashSet<String>(Arrays.asList(ids)));
            return this;
        }

        public Builder keyIDs(Set<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder privateOnly(boolean privateOnly) {
            this.privateOnly = privateOnly;
            return this;
        }

        public Builder publicOnly(boolean publicOnly) {
            this.publicOnly = publicOnly;
            return this;
        }

        public Builder minKeySize(int minSizeBits) {
            this.minSizeBits = minSizeBits;
            return this;
        }

        public Builder maxKeySize(int maxSizeBits) {
            this.maxSizeBits = maxSizeBits;
            return this;
        }

        public JWKMatcher build() {
            return new JWKMatcher(this.types, this.uses, this.ops, this.algs, this.ids, this.privateOnly, this.publicOnly, this.minSizeBits, this.maxSizeBits);
        }
    }
}

