/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.dump.parser;

import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.EventListener;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.RdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePairs;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.datatype.Stream;
import com.moilioncircle.redis.replicator.rdb.dump.datatype.DumpKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.dump.parser.DumpValueParser;
import com.moilioncircle.redis.replicator.rdb.iterable.ValueIterableEventListener;
import com.moilioncircle.redis.replicator.rdb.iterable.ValueIterableRdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueByteArrayIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueMapEntryIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueZSetEntryIterator;
import com.moilioncircle.redis.replicator.util.ByteArray;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Objects;

public class IterableDumpValueParser
implements DumpValueParser {
    protected final int batchSize;
    protected final boolean order;
    protected final Replicator replicator;
    protected final RdbValueVisitor valueVisitor;

    public IterableDumpValueParser(Replicator replicator) {
        this(64, replicator);
    }

    public IterableDumpValueParser(int batchSize, Replicator replicator) {
        this(true, batchSize, replicator);
    }

    public IterableDumpValueParser(boolean order, int batchSize, Replicator replicator) {
        Objects.requireNonNull(replicator);
        this.order = order;
        this.batchSize = batchSize;
        this.replicator = replicator;
        this.valueVisitor = new ValueIterableRdbValueVisitor(replicator);
    }

    @Override
    public void parse(DumpKeyValuePair kv, EventListener listener) {
        Objects.requireNonNull(listener);
        new ValueIterableEventListener(this.order, this.batchSize, listener).onEvent(this.replicator, this.parse(kv));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyValuePair<?, ?> parse(DumpKeyValuePair kv) {
        Objects.requireNonNull(kv);
        try (RedisInputStream in = new RedisInputStream(new ByteArray((byte[])kv.getValue()));){
            int valueType = in.read();
            switch (valueType) {
                case 0: {
                    KeyValuePair<byte[], byte[]> keyValuePair = KeyValuePairs.string(kv, (byte[])this.valueVisitor.applyString(in, 0));
                    return keyValuePair;
                }
                case 1: {
                    KeyStringValueByteArrayIterator keyStringValueByteArrayIterator = KeyValuePairs.iterList(kv, (Iterator)this.valueVisitor.applyList(in, 0));
                    return keyStringValueByteArrayIterator;
                }
                case 2: {
                    KeyStringValueByteArrayIterator keyStringValueByteArrayIterator = KeyValuePairs.iterSet(kv, (Iterator)this.valueVisitor.applySet(in, 0));
                    return keyStringValueByteArrayIterator;
                }
                case 3: {
                    KeyStringValueZSetEntryIterator keyStringValueZSetEntryIterator = KeyValuePairs.iterZset(kv, (Iterator)this.valueVisitor.applyZSet(in, 0));
                    return keyStringValueZSetEntryIterator;
                }
                case 5: {
                    KeyStringValueZSetEntryIterator keyStringValueZSetEntryIterator = KeyValuePairs.iterZset(kv, (Iterator)this.valueVisitor.applyZSet2(in, 0));
                    return keyStringValueZSetEntryIterator;
                }
                case 4: {
                    KeyStringValueMapEntryIterator keyStringValueMapEntryIterator = KeyValuePairs.iterHash(kv, (Iterator)this.valueVisitor.applyHash(in, 0));
                    return keyStringValueMapEntryIterator;
                }
                case 9: {
                    KeyStringValueMapEntryIterator keyStringValueMapEntryIterator = KeyValuePairs.iterHash(kv, (Iterator)this.valueVisitor.applyHashZipMap(in, 0));
                    return keyStringValueMapEntryIterator;
                }
                case 10: {
                    KeyStringValueByteArrayIterator keyStringValueByteArrayIterator = KeyValuePairs.iterList(kv, (Iterator)this.valueVisitor.applyListZipList(in, 0));
                    return keyStringValueByteArrayIterator;
                }
                case 11: {
                    KeyStringValueByteArrayIterator keyStringValueByteArrayIterator = KeyValuePairs.iterSet(kv, (Iterator)this.valueVisitor.applySetIntSet(in, 0));
                    return keyStringValueByteArrayIterator;
                }
                case 12: {
                    KeyStringValueZSetEntryIterator keyStringValueZSetEntryIterator = KeyValuePairs.iterZset(kv, (Iterator)this.valueVisitor.applyZSetZipList(in, 0));
                    return keyStringValueZSetEntryIterator;
                }
                case 13: {
                    KeyStringValueMapEntryIterator keyStringValueMapEntryIterator = KeyValuePairs.iterHash(kv, (Iterator)this.valueVisitor.applyHashZipList(in, 0));
                    return keyStringValueMapEntryIterator;
                }
                case 14: {
                    KeyStringValueByteArrayIterator keyStringValueByteArrayIterator = KeyValuePairs.iterList(kv, (Iterator)this.valueVisitor.applyListQuickList(in, 0));
                    return keyStringValueByteArrayIterator;
                }
                case 6: {
                    KeyValuePair<byte[], Module> keyValuePair = KeyValuePairs.module(kv, (Module)this.valueVisitor.applyModule(in, 0));
                    return keyValuePair;
                }
                case 7: {
                    KeyValuePair<byte[], Module> keyValuePair = KeyValuePairs.module(kv, (Module)this.valueVisitor.applyModule2(in, 0));
                    return keyValuePair;
                }
                case 15: {
                    KeyValuePair<byte[], Stream> keyValuePair = KeyValuePairs.stream(kv, (Stream)this.valueVisitor.applyStreamListPacks(in, 0));
                    return keyValuePair;
                }
            }
            throw new AssertionError((Object)("unexpected value type:" + valueType));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

