/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.web.webServices.support;

import com.google.gson.reflect.TypeToken;
import com.sdjxd.hussar.core.base72.bo.JsTransObject;
import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.hussar.mobile.base.bo.MobileRequestBo;
import com.sdjxd.hussar.mobile.base.bo.MobileRequestController;
import com.sdjxd.hussar.mobile.key.services.KeyServices;
import com.sdjxd.hussar.mobile.utils.GzipTool;
import com.sdjxd.hussar.mobile.waitdo.bo.WaitDoRequestBo;
import com.sdjxd.hussar.mobile.waitdo.services.WaitRequestController;
import com.sdjxd.hussar.mobile.web.webServices.Mobile;
import java.util.Map;
import org.apache.log4j.Logger;

public class MobileImpl
implements Mobile {
    private static Logger log = Logger.getLogger(MobileImpl.class);

    @Override
    public String getConfig() {
        JsTransObject jto = new JsTransObject();
        try {
            jto.setValue(AppConfig.getConfigMap());
            jto.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            jto.setSuccess(false);
            jto.addMsg("\u52a0\u5bc6\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            log.error((Object)("\u52a0\u5bc6\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01" + e.getMessage()));
        }
        return HussarJson.gson_toJson(jto);
    }

    @Override
    public String exChangeKey(String keyInfo) {
        if (AppConfig.getIsUseGzip()) {
            keyInfo = GzipTool.ungzip(keyInfo);
        }
        Map datamap = (Map)HussarJson.gson_fromJson(keyInfo, new TypeToken<Map<String, String>>(){}.getType());
        JsTransObject jto = new JsTransObject();
        String imei = (String)datamap.get("imei");
        String symmetricKey = (String)datamap.get("symmetricKey");
        try {
            String imei_jm = KeyServices.rsaDecrypt(imei);
            String symmetricKey_jm = KeyServices.rsaDecrypt(symmetricKey);
            KeyServices.saveSymmetricKey(imei_jm, symmetricKey_jm);
            jto.setValue(KeyServices.rsaSign(imei_jm));
            jto.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            jto.setSuccess(false);
            jto.addMsg("\u79d8\u94a5\u4ea4\u6362\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        return HussarJson.gson_toJson(jto);
    }

    @Override
    public String requestManager(String requestInfo) {
        String imei = "";
        String returnStr = "";
        JsTransObject jto = new JsTransObject();
        try {
            if (AppConfig.getIsUseKey()) {
                imei = KeyServices.getIMEIFromParam(requestInfo);
                requestInfo = KeyServices.decryptContent(requestInfo);
            }
            if (AppConfig.getIsUseGzip()) {
                requestInfo = GzipTool.ungzip(requestInfo);
            }
            log.info((Object)("**********request:" + requestInfo));
            MobileRequestBo request = HussarJson.gson_fromJson(requestInfo, MobileRequestBo.class);
            jto.setContextId(request.getContextId());
            MobileRequestController manage = new MobileRequestController(request);
            Object o = manage.dealWithRequest();
            String reponseStr = HussarJson.gson_toJson(o);
            log.info((Object)("**********reponse:" + reponseStr));
            if (AppConfig.getIsUseGzip()) {
                o = GzipTool.gzip(reponseStr);
            }
            if (AppConfig.getIsUseKey()) {
                o = o instanceof String ? KeyServices.EncryptionContent((String)o, imei) : KeyServices.EncryptionContent(reponseStr, imei);
            }
            jto.setValue(o);
            jto.setSuccess(true);
            returnStr = HussarJson.gson_toJson(jto);
        }
        catch (Exception e) {
            e.printStackTrace();
            jto.setSuccess(false);
            if (AppConfig.getModel().equalsIgnoreCase("debug")) {
                jto.addMsg(e.getMessage());
            } else {
                jto.addMsg("\u670d\u52a1\u5f02\u5e38\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            }
            log.error((Object)e.getMessage());
            returnStr = HussarJson.gson_toJson(jto);
        }
        log.info((Object)("**********returnStr:" + returnStr));
        return returnStr;
    }

    @Override
    public String getWaitDoInfo(String waitDoRequest) {
        String imei = "";
        String returnStr = "";
        JsTransObject jto = new JsTransObject();
        try {
            if (AppConfig.getIsUseKey()) {
                imei = KeyServices.getIMEIFromParam(waitDoRequest);
                waitDoRequest = KeyServices.decryptContent(waitDoRequest);
            }
            if (AppConfig.getIsUseGzip()) {
                waitDoRequest = GzipTool.ungzip(waitDoRequest);
            }
            log.info((Object)("**********WaitDoRequest:" + waitDoRequest));
            WaitDoRequestBo request = HussarJson.gson_fromJson(waitDoRequest, WaitDoRequestBo.class);
            jto.setContextId(request.getContextId());
            WaitRequestController manage = new WaitRequestController();
            Object o = manage.deal(request);
            String reponseStr = HussarJson.gson_toJson(o);
            log.info((Object)("**********WaitDoResponse:" + reponseStr));
            if (AppConfig.getIsUseGzip()) {
                o = GzipTool.gzip(reponseStr);
            }
            if (AppConfig.getIsUseKey()) {
                o = o instanceof String ? KeyServices.EncryptionContent((String)o, imei) : KeyServices.EncryptionContent(reponseStr, imei);
            }
            jto.setValue(o);
            jto.setSuccess(true);
            returnStr = HussarJson.gson_toJson(jto);
        }
        catch (Exception e) {
            e.printStackTrace();
            jto.setSuccess(false);
            if (AppConfig.getModel().equalsIgnoreCase("debug")) {
                jto.addMsg(e.getMessage());
            } else {
                jto.addMsg("\u670d\u52a1\u5f02\u5e38\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            }
            log.error((Object)e.getMessage());
            returnStr = HussarJson.gson_toJson(jto);
        }
        log.info((Object)("**********returnStr:" + returnStr));
        return returnStr;
    }
}

