/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.waitdo.services;

import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.hussar.mobile.waitdo.bo.WaitDoItemBo;
import com.sdjxd.hussar.mobile.waitdo.bo.WaitDoRequestBo;
import com.sdjxd.hussar.mobile.waitdo.bo.WaitDoResponseBo;
import com.sdjxd.hussar.mobile.waitdo.dao.WaitDoDao;
import com.sdjxd.pms.platform.organize.User;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WaitRequestController {
    private final String WAITDO_KEY = "_WAITDO";
    private final String WAITDO_THREAD = "_THREADID";
    private static WaitDoDao dao;
    private static Logger log;
    private static int threadSleepTime;
    private static int loopNum;

    static {
        log = Logger.getLogger(WaitRequestController.class);
        threadSleepTime = Integer.parseInt(AppConfig.getConfig("THREADSLEEPTIME"));
        loopNum = Integer.parseInt(AppConfig.getConfig("LOOPNUM"));
        try {
            dao = Factory.getDao(WaitDoDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object deal(WaitDoRequestBo request) {
        WaitDoResponseBo response = new WaitDoResponseBo();
        response.setMainSessionId(request.getMainSessionId());
        response.setWaitDoSessionId(AppConfig.getSessionId());
        User.loginNoPass((String)request.getUserCode());
        Thread current = Thread.currentThread();
        Long currentThreadID = current.getId();
        Global.getContext().setSession("_THREADID", current.getId());
        int i = 0;
        while (i < loopNum) {
            block9: {
                Long sessionThreadID = (Long)Global.getContext().getSession("_THREADID");
                log.info((Object)("*********\u6709\u6548\u7ebf\u7a0b\uff1a" + sessionThreadID + " \u5f53\u524d\u7ebf\u7a0b\uff1a" + currentThreadID));
                log.info((Object)("@@@@@@@@@@@@@@@@@@@@@" + i));
                if (sessionThreadID != currentThreadID) {
                    return null;
                }
                try {
                    ArrayList<WaitDoItemBo> curWaitDo = dao.getWaitDoInfo(request.getResolution());
                    if (Global.getContext() == null) break block9;
                    ArrayList oldWaitDo = request.getWaitDos();
                    if (oldWaitDo == null) {
                        oldWaitDo = (ArrayList)Global.getContext().getSession("_WAITDO");
                    }
                    if (oldWaitDo == null) {
                        Global.getContext().setSession("_WAITDO", curWaitDo);
                        response.setWaitDos(curWaitDo);
                        response.setHasChange(true);
                        break;
                    }
                    if (this.check(curWaitDo, oldWaitDo)) {
                        response.setWaitDos(null);
                        response.setHasChange(false);
                        break block9;
                    }
                    Global.getContext().setSession("_WAITDO", curWaitDo);
                    response.setWaitDos(curWaitDo);
                    response.setHasChange(true);
                    break;
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                    log.error((Object)("\u8bfb\u53d6\u79fb\u52a8\u5f85\u529e\u6570\u636e\u51fa\u9519\u5bf9\u5e94\u9519\u8bef\uff1a" + e1.getMessage()));
                }
            }
            try {
                Thread.sleep(threadSleepTime * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return response;
    }

    private boolean check(ArrayList<WaitDoItemBo> curWaitDo, ArrayList<WaitDoItemBo> oldWaitDo) {
        if (curWaitDo.size() != oldWaitDo.size()) {
            return false;
        }
        int i = 0;
        while (i < curWaitDo.size()) {
            WaitDoItemBo cur = curWaitDo.get(i);
            WaitDoItemBo old = oldWaitDo.get(i);
            if (cur == null) {
                if (old != null) {
                    return false;
                }
            } else if (!cur.equals(old)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

