/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtils {
    public static void compress(String zipFilename, String ... paths) throws Exception {
        ZipUtils.compress(new FileOutputStream(zipFilename), paths);
    }

    public static void compress(OutputStream os, String ... paths) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(os);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String path = stringArray[n2];
            if (!path.equals("") && (file = new File(path)).exists()) {
                if (file.isDirectory()) {
                    ZipUtils.zipDirectory(zos, file.getPath(), String.valueOf(file.getName()) + File.separator);
                } else {
                    ZipUtils.zipFile(zos, file.getPath(), "");
                }
            }
            ++n2;
        }
        zos.close();
    }

    private static void zipDirectory(ZipOutputStream zos, String dirName, String basePath) throws Exception {
        File dir = new File(dirName);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files.length > 0) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        ZipUtils.zipDirectory(zos, file.getPath(), String.valueOf(basePath) + file.getName().substring(file.getName().lastIndexOf(File.separator) + 1) + File.separator);
                    } else {
                        ZipUtils.zipFile(zos, file.getPath(), basePath);
                    }
                    ++n2;
                }
            } else {
                ZipEntry ze = new ZipEntry(String.valueOf(basePath.substring(0, basePath.length() - 1)) + "/");
                zos.putNextEntry(ze);
            }
        }
    }

    private static void zipFile(ZipOutputStream zos, String filename, String basePath) throws Exception {
        File file = new File(filename);
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(filename);
            ZipEntry ze = new ZipEntry(String.valueOf(basePath) + file.getName());
            zos.putNextEntry(ze);
            byte[] buffer = new byte[8192];
            int count = 0;
            while ((count = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, count);
            }
            fis.close();
        }
    }
}

