/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.utils;

import com.sdjxd.hussar.core.base72.Global;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class SQLiteTools {
    private static final Logger log = Logger.getLogger(SQLiteTools.class);

    private static Connection getConnection(String dbPath) {
        dbPath = String.valueOf(Global.getRealPath().replace("\\", "/")) + dbPath;
        dbPath = String.valueOf(dbPath.substring(0, 1).toLowerCase()) + dbPath.substring(1);
        long start = System.currentTimeMillis();
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite://" + dbPath);
            long end = System.currentTimeMillis();
            log.info((Object)("\u521b\u5efa\u6570\u636e\u5e93\u6587\u4ef6\u5e76\u8fde\u63a5\u8017\u8d39\u65f6\u95f4\uff1a" + (end - start)));
            return conn;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            log.error((Object)"\u7f3a\u5c11org.sqlite.JDBC \u9a71\u52a8\u7a0b\u5e8f\uff01");
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)"\u65e0\u6cd5\u6b63\u786e\u8fde\u63a5\u5230DB\u6587\u4ef6\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e\uff01");
            return null;
        }
    }

    public static int executeNonQuery(String dbPath, String sql) throws SQLException {
        int num = 0;
        if (sql == null || sql.length() == 0) {
            return num;
        }
        Connection conn = SQLiteTools.getConnection(dbPath);
        Statement stat = null;
        if (conn != null) {
            long start = System.currentTimeMillis();
            try {
                try {
                    stat = conn.createStatement();
                    num += stat.executeUpdate(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    log.error((Object)(String.valueOf(e.getMessage()) + sql));
                    num = -1;
                    throw e;
                }
            }
            finally {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            long end = System.currentTimeMillis();
            System.out.println("\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - start));
        } else {
            num = -1;
        }
        return num;
    }

    public static int executeNonQuery(String dbPath, String[] sqlList) throws SQLException {
        int num = 0;
        int length = sqlList.length;
        if (sqlList == null || length == 0) {
            return num;
        }
        Connection conn = SQLiteTools.getConnection(dbPath);
        if (conn != null) {
            long start = System.currentTimeMillis();
            conn.setAutoCommit(false);
            Statement stat = null;
            String sql = null;
            stat = conn.createStatement();
            try {
                try {
                    int i = 0;
                    while (i < length) {
                        sql = sqlList[i];
                        num += stat.executeUpdate(sql);
                        ++i;
                    }
                    conn.commit();
                    conn.setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    conn.rollback();
                    log.error((Object)(String.valueOf(e.getMessage()) + sql));
                    num = -1;
                    throw e;
                }
            }
            finally {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            long end = System.currentTimeMillis();
            System.out.println("\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - start));
        } else {
            num = -1;
        }
        return num;
    }

    public static int executeNonQuery(String dbPath, List sqlList) throws SQLException {
        int num = 0;
        if (sqlList != null) {
            String[] sqlArray = new String[sqlList.size()];
            sqlList.toArray(sqlArray);
            num = SQLiteTools.executeNonQuery(dbPath, sqlArray);
        }
        return num;
    }

    public static ResultSet executeQuery(String dbPath, String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            return null;
        }
        Connection conn = SQLiteTools.getConnection(dbPath);
        Statement stat = null;
        ResultSet rs = null;
        if (conn != null) {
            long start = System.currentTimeMillis();
            try {
                try {
                    stat = conn.createStatement();
                    rs = stat.executeQuery(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    log.error((Object)(String.valueOf(e.getMessage()) + sql));
                    rs = null;
                    throw e;
                }
            }
            finally {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            long end = System.currentTimeMillis();
            System.out.println("\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - start));
        } else {
            rs = null;
        }
        return rs;
    }
}

