/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.util.DerValue;

public class RSAUtil {
    private KeyPairGenerator keyPairGen;
    private KeyPair keyPair;
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private static final String RSA = "RSA/ECB/PKCS1Padding";

    public void createKey() {
        try {
            this.keyPairGen = KeyPairGenerator.getInstance("RSA");
            this.keyPairGen.initialize(512);
            this.keyPair = this.keyPairGen.generateKeyPair();
            this.privateKey = (RSAPrivateKey)this.keyPair.getPrivate();
            this.publicKey = (RSAPublicKey)this.keyPair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static String createFile(byte[] desEncode, String keyPath, boolean overWrite) throws IOException {
        boolean fileExisted = false;
        if (keyPath.indexOf(":\\") <= 0 && keyPath.indexOf(":/") <= 0) {
            System.out.println("\u5bc6\u94a5\u6587\u4ef6\u5b58\u653e\u4f4d\u7f6e\u4e0d\u5408\u6cd5\uff0c" + keyPath);
            return "";
        }
        File keyFile = new File(keyPath);
        fileExisted = keyFile.exists();
        if (!(!fileExisted || overWrite && keyFile.canWrite())) {
            System.out.println("\u6307\u5b9a\u5bc6\u94a5\u6587\u4ef6" + keyFile + "\u5df2\u5b58\u5728\u4e14\u4e0d\u53ef\u5199\uff0c\u8bf7\u91cd\u65b0\u6307\u5b9a\u5176\u4ed6\u6587\u4ef6\u6216\u4fee\u6539\u8986\u76d6\u9009\u9879\u4e3a\u771f\u3002");
            return "";
        }
        if (!fileExisted && !keyFile.createNewFile()) {
            System.out.println("\u521b\u5efa\u65b0\u6587\u4ef6" + keyFile + "\u5931\u8d25\u3002");
            return "";
        }
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(keyPath));
        try {
            try {
                out.writeObject(desEncode);
            }
            catch (IOException ex) {
                out.close();
                return "";
            }
        }
        finally {
            out.close();
        }
        return "";
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public RSAPrivateKey getPrivateKey(String keyPath) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(keyPath));
            try {
                byte[] desEncodeRead = (byte[])in.readObject();
                in.close();
                DerValue d = new DerValue(desEncodeRead);
                PrivateKey p = RSAPrivateKeyImpl.parseKey((DerValue)d);
                return (RSAPrivateKey)p;
            }
            catch (ClassNotFoundException ex1) {
                ex1.printStackTrace();
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public RSAPublicKey getPublicKey(String keyPath) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(keyPath));
            try {
                byte[] desEncodeRead = (byte[])in.readObject();
                in.close();
                DerValue d = new DerValue(desEncodeRead);
                PublicKey p = RSAPublicKeyImpl.parse(d);
                return (RSAPublicKey)p;
            }
            catch (ClassNotFoundException ex1) {
                ex1.printStackTrace();
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void encryptFile(RSAPublicKey publicKey, File file, File newFile) {
        try {
            FileInputStream is = new FileInputStream(file);
            FileOutputStream os = new FileOutputStream(newFile);
            byte[] bytes = new byte[53];
            while (((InputStream)is).read(bytes) > 0) {
                byte[] e = this.encrypt(publicKey, bytes);
                bytes = new byte[53];
                ((OutputStream)os).write(e, 0, e.length);
            }
            ((OutputStream)os).close();
            ((InputStream)is).close();
            System.out.println("write success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void decryptFile(RSAPrivateKey privateKey, File file, File newFile) {
        try {
            FileInputStream is = new FileInputStream(file);
            FileOutputStream os = new FileOutputStream(newFile);
            byte[] bytes1 = new byte[64];
            while (((InputStream)is).read(bytes1) > 0) {
                byte[] de = this.decrypt(privateKey, bytes1);
                bytes1 = new byte[64];
                ((OutputStream)os).write(de, 0, de.length);
            }
            ((OutputStream)os).close();
            ((InputStream)is).close();
            System.out.println("write success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] rsaEncrypt(byte[] data) {
        return this.encrypt(this.publicKey, data);
    }

    public byte[] rsaDecrypt(byte[] data) {
        return this.decrypt(this.privateKey, data);
    }

    protected byte[] encrypt(Key publicKey, byte[] obj) {
        if (publicKey != null) {
            try {
                Cipher cipher = Cipher.getInstance(RSA);
                cipher.init(1, publicKey);
                return cipher.doFinal(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected byte[] decrypt(Key privateKey, byte[] obj) {
        if (privateKey != null) {
            try {
                Cipher cipher = Cipher.getInstance(RSA);
                cipher.init(2, privateKey);
                return cipher.doFinal(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public byte[] rsaSign(byte[] data) {
        return this.encrypt(this.privateKey, data);
    }
}

