/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class NaturalDeserializer
implements JsonDeserializer<Object> {
    @Override
    public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        if (json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            return this.handlePrimitive(json.getAsJsonPrimitive());
        }
        if (json.isJsonArray()) {
            return this.handleArray(json.getAsJsonArray(), context);
        }
        return this.handleObject(json.getAsJsonObject(), context);
    }

    private Object handlePrimitive(JsonPrimitive json) {
        if (json.isBoolean()) {
            return json.getAsBoolean();
        }
        if (json.isString()) {
            return json.getAsString();
        }
        BigDecimal bigDec = json.getAsBigDecimal();
        try {
            bigDec.toBigIntegerExact();
            try {
                return bigDec.intValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                return bigDec.longValue();
            }
        }
        catch (ArithmeticException arithmeticException) {
            return bigDec.doubleValue();
        }
    }

    private Object handleArray(JsonArray json, JsonDeserializationContext context) {
        Object[] array = new Object[json.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = context.deserialize(json.get(i), (Type)((Object)Object.class));
            ++i;
        }
        return array;
    }

    private Object handleObject(JsonObject json, JsonDeserializationContext context) {
        HashMap map = new HashMap();
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            map.put(entry.getKey(), context.deserialize(entry.getValue(), (Type)((Object)Object.class)));
        }
        return map;
    }
}

