/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.utils;

import com.sansec.crypto.Crypto;
import com.sansec.crypto.SWCrypto;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class EncryptionUtil {
    private static Crypto crypto;
    private static byte[] derPrivateKey;
    private static byte[] derPublicKey;

    static {
        derPrivateKey = null;
        derPublicKey = null;
    }

    public EncryptionUtil() {
        try {
            if (crypto == null) {
                crypto = SWCrypto.getInstance((String)"device");
            }
        }
        catch (Exception e) {
            System.out.println("\u52a8\u6001\u94fe\u63a5\u5e93\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u73af\u5883\u53d8\u91cfpath\u76ee\u5f55\u4e0b\uff0cdevice.dll\u548cswsds.dll\u662f\u5426\u5b58\u5728!");
            e.printStackTrace();
        }
    }

    public boolean rsaVerify(byte[] pubkey, byte[] data, byte[] signData) {
        try {
            return crypto.rsaVerify("SHA1", pubkey, data, signData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte[] rsaSign(byte[] data) {
        try {
            return crypto.rsaSign("SHA1", derPrivateKey, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void exportDerPubKey(String path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            fos.write(this.getDerPublicKey());
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exportDerPriKey(String path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            fos.write(this.getDerPrivateKey());
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void rsaGenKeyPair(int size) {
        try {
            byte[][] key = crypto.rsaGenKeyPair(size);
            derPublicKey = key[0];
            derPrivateKey = key[1];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] getDerPrivateKey() {
        if (derPrivateKey == null) {
            this.rsaGenKeyPair(1024);
        }
        return derPrivateKey;
    }

    public byte[] getDerPublicKey() {
        if (derPrivateKey == null) {
            this.rsaGenKeyPair(1024);
        }
        return derPublicKey;
    }

    public byte[] rsaEncrypt(byte[] data) {
        try {
            return crypto.rsaEncrypt(derPublicKey, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] rsaDecrypt(byte[] signdata) {
        try {
            return crypto.rsaDecrypt(derPrivateKey, signdata);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] symmetryEncrypt(byte[] key, byte[] data) {
        try {
            return crypto.symmetryEncrypt("3DES", key, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] symmetryDecrypt(byte[] key, byte[] signdata) {
        try {
            return crypto.symmetryDecrypt("3DES", key, signdata);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] readKeyFromFile(String path) {
        byte[] key = null;
        try {
            FileInputStream fis = new FileInputStream(path);
            byte[] buffer = new byte[4096];
            int len = fis.read(buffer);
            fis.close();
            key = new byte[len];
            System.arraycopy(buffer, 0, key, 0, len);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return key;
    }

    public boolean saveKeyToFile(String path, byte[] key) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            fos.write(key);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

