/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.utils;

import android.content.res.AXmlResourceParser;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AnalysisApkUtil {
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    private static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};

    public static String getApkVersionName(String apkUrl) {
        String varsionName = "";
        byte[] b = new byte[1024];
        try {
            File file = new File(apkUrl);
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry zipEntry = null;
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !"AndroidManifest.xml".equals(zipEntry.getName())) continue;
                try {
                    int type;
                    AXmlResourceParser parser = new AXmlResourceParser();
                    parser.open(zipFile.getInputStream(zipEntry));
                    block8: while ((type = parser.next()) != 1) {
                        switch (type) {
                            case 2: {
                                int i = 0;
                                while (i != parser.getAttributeCount()) {
                                    if ("versionName".equals(parser.getAttributeName(i))) {
                                        varsionName = AnalysisApkUtil.getAttributeValue(parser, i);
                                    }
                                    ++i;
                                }
                                continue block8;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return varsionName;
    }

    private static String getAttributeValue(AXmlResourceParser parser, int index) {
        int type = parser.getAttributeValueType(index);
        int data = parser.getAttributeValueData(index);
        if (type == 3) {
            return parser.getAttributeValue(index);
        }
        if (type == 2) {
            return String.format("?%s%08X", AnalysisApkUtil.getPackage(data), data);
        }
        if (type == 1) {
            return String.format("@%s%08X", AnalysisApkUtil.getPackage(data), data);
        }
        if (type == 4) {
            return String.valueOf(Float.intBitsToFloat(data));
        }
        if (type == 17) {
            return String.format("0x%08X", data);
        }
        if (type == 18) {
            return data != 0 ? "true" : "false";
        }
        if (type == 5) {
            return String.valueOf(Float.toString(AnalysisApkUtil.complexToFloat(data))) + DIMENSION_UNITS[data & 0xF];
        }
        if (type == 6) {
            return String.valueOf(Float.toString(AnalysisApkUtil.complexToFloat(data))) + FRACTION_UNITS[data & 0xF];
        }
        if (type >= 28 && type <= 31) {
            return String.format("#%08X", data);
        }
        if (type >= 16 && type <= 31) {
            return String.valueOf(data);
        }
        return String.format("<0x%X, type 0x%02X>", data, type);
    }

    private static String getPackage(int id) {
        if (id >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }
}

