/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.resouces.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.utils.FileTools;
import com.sdjxd.hussar.core.utils.Guid;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.core.utils.IJsonAdapterFactory;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.hussar.mobile.base.bo.MobileMethod;
import com.sdjxd.hussar.mobile.base.bo.MobileRequestBo;
import com.sdjxd.hussar.mobile.base.bo.MobileResponseBo;
import com.sdjxd.hussar.mobile.css.service.support.ThemeServices_M;
import com.sdjxd.hussar.mobile.form.services.PatternFileServices_M;
import com.sdjxd.hussar.mobile.offline.data.bo.DataSet;
import com.sdjxd.hussar.mobile.offline.data.services.DataSyncServices;
import com.sdjxd.hussar.mobile.offline.database.sqlite.OffLineDBService;
import com.sdjxd.hussar.mobile.resouces.bo.MobileAppBo;
import com.sdjxd.hussar.mobile.resouces.bo.ResFilesBo;
import com.sdjxd.hussar.mobile.resouces.dao.ResFileDao;
import com.sdjxd.hussar.mobile.resouces.po.ResFilePo;
import com.sdjxd.hussar.mobile.utils.AnalysisApkUtil;
import com.sdjxd.hussar.mobile.utils.FileMD5Util;
import com.sdjxd.hussar.mobile.utils.ZipUtils;
import com.sdjxd.pms.platform.base.MaxID;
import com.sdjxd.pms.platform.form.model.FileBean;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResServices {
    private static Logger logger = Logger.getLogger(ResServices.class);
    public static final String resDefaultPath = String.valueOf(File.separator) + "resource" + File.separator + "mobile_res" + File.separator;
    private static ResFileDao dao;

    static {
        try {
            dao = Factory.getDao(ResFileDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
    }

    public static void checkVersion(Map<String, String> info) throws Exception {
        String pkValue;
        String imei;
        MobileRequestBo request;
        String clientAppVersion = info.get("appversion");
        String clientResVersion = info.get("resversion");
        String device = info.get("device");
        MobileResponseBo response = AppConfig.getMobileResponse();
        String serverResVersionCode = AppConfig.getServerResVersionCode();
        if (!HussarString.isEmpty(clientAppVersion)) {
            String programType;
            MobileAppBo app;
            String serverAppVersionCode;
            if (device.contains("Android")) {
                String appPath = String.valueOf(Global.getRealPath()) + AppConfig.getConfig("APPURL");
                serverAppVersionCode = AnalysisApkUtil.getApkVersionName(appPath);
                if (!clientAppVersion.equalsIgnoreCase(serverAppVersionCode)) {
                    app = new MobileAppBo();
                    app.setVersionCode(serverAppVersionCode);
                    app.setDownloadUrl(AppConfig.getConfig("APPURL"));
                    app.setVersionExplain(AppConfig.getConfig("APPVERSIONEXPLAIN"));
                    response.setApp(app);
                }
            } else if ((device.contains("iPhone") || device.contains("iPad")) && "1".equals(programType = info.get("programtype")) && !clientAppVersion.equalsIgnoreCase(serverAppVersionCode = AppConfig.getConfig("IOSAPPVERSION"))) {
                app = new MobileAppBo();
                app.setVersionCode(serverAppVersionCode);
                app.setDownloadUrl(AppConfig.getConfig("IOSAPPURL"));
                app.setVersionExplain(AppConfig.getConfig("IOSAPPVERSIONEXPLAIN"));
                response.setApp(app);
            }
        }
        if (response.getApp() == null && clientResVersion != null && !clientResVersion.equalsIgnoreCase(serverResVersionCode)) {
            if (HussarString.isEmpty(serverResVersionCode)) {
                response.setMsg("\u8bf7\u53d1\u5e03\u79fb\u52a8\u8d44\u6e90!");
                return;
            }
            ResFilesBo res = new ResFilesBo();
            res.setVerSionCode(serverResVersionCode);
            if ("0".equals(clientResVersion)) {
                ArrayList<ResFilePo> downLoadFiles = new ArrayList<ResFilePo>();
                ResFilePo po = new ResFilePo();
                po.setMd5("mobile_res");
                po.setFileName("mobile_res");
                po.setFileType(".zip");
                po.setFilePath("");
                downLoadFiles.add(po);
                res.setDownLoadFiles(downLoadFiles);
            } else {
                res.setDownLoadFiles(dao.getNeedDownLoadResFiles(clientResVersion, serverResVersionCode));
                res.setDeletesFiles(dao.getNeedDelResFiles(clientResVersion, serverResVersionCode));
            }
            response.setResFiles(res);
        }
        if (AppConfig.getLoginModel() != 0 && (request = AppConfig.getMobileRequest()).getClient() != null && !HussarString.isEmpty(imei = request.getClient().getImei()) && dao.needDownLoadDb(clientResVersion) && !HussarString.isEmpty(pkValue = dao.getOffLineUserIds(imei))) {
            ArrayList<DataSet> downloadDatas = new ArrayList<DataSet>();
            DataSet data = DataSyncServices.downLoadDataJson("", "JXD7_XT_USER", "USERID", pkValue);
            if (data != null) {
                downloadDatas.add(data);
            }
            if (downloadDatas.size() > 0) {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(downloadDatas);
                MobileMethod nextMethod = new MobileMethod();
                nextMethod.setType(Const.Action.ActionType.MOBILE);
                nextMethod.setMethodName("SAVEDOWNLOADUSERDATA");
                nextMethod.setParams(params);
                response.setNextMethod(nextMethod);
            }
        }
    }

    public static void checkVersion(String clientAppVersion, String clientResVersion) throws Exception {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("appversion", clientAppVersion);
        info.put("resversion", clientResVersion);
        info.put("device", "ios".equals(clientAppVersion) ? "iPhone" : "Android");
        info.put("programtype", "0");
        ResServices.checkVersion(info);
    }

    public static void downLoadFile(String fileMd5) throws Exception {
        FileBean fileBean = new FileBean();
        if ("mobile_res".equals(fileMd5)) {
            String filePath = AppConfig.getFileAbsolutePath("/resource/mobile_res.zip");
            File file = new File(filePath);
            fileBean.setContentType("application/zip");
            fileBean.setFileName("mobile_res");
            fileBean.setFileStream((InputStream)((FileInputStream)BeanFactory.getClass((String)"FileInputStream", (Object[])new File[]{file})));
        } else {
            ResFilePo fileInfo = dao.getResFileByMd5(fileMd5);
            String filePath = fileInfo.getFilePath().startsWith(String.valueOf(File.separator) + "mobilejs" + File.separator + "user" + File.separator) ? fileInfo.getFilePath().replace(String.valueOf(File.separator) + "mobilejs" + File.separator + "user", "") : "/resource/mobile_res/" + fileInfo.filePath;
            filePath = String.valueOf(AppConfig.getFileAbsolutePath(filePath)) + fileInfo.getFileName() + fileInfo.getFileType();
            File file = new File(filePath);
            fileBean.setContentType(fileInfo.getFileType());
            fileBean.setFileName(fileInfo.getFileName());
            fileBean.setFileStream((InputStream)((FileInputStream)BeanFactory.getClass((String)"FileInputStream", (Object[])new File[]{file})));
        }
        Global.getContext().writeFileToResponse(fileBean);
    }

    public static boolean recordFile() {
        try {
            logger.info((Object)"####################\u79fb\u52a8\u8d44\u6e90\u53d1\u5e03\u5f00\u59cb\uff01");
            ResServices.recordResFile();
            logger.info((Object)"####################\u79fb\u52a8\u8d44\u6e90\u53d1\u5e03\u7ed3\u675f\uff01");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"\u6ce8\u518c\u6587\u4ef6\u7248\u672c\u4fe1\u606f\u51fa\u9519\uff01");
            return false;
        }
    }

    public static String publishResources() {
        try {
            logger.info((Object)"####################\u79fb\u52a8\u8d44\u6e90\u53d1\u5e03\u5f00\u59cb\uff01");
            ResServices.recordResFile();
            logger.info((Object)"####################\u79fb\u52a8\u8d44\u6e90\u53d1\u5e03\u7ed3\u675f\uff01");
            return "true";
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"\u6ce8\u518c\u6587\u4ef6\u7248\u672c\u4fe1\u606f\u51fa\u9519\uff01");
            return "false";
        }
    }

    private static void recordResFile() throws Exception {
        int maxVerSionCode = MaxID.getMaxID((String)"JXD7_M_RES_MD5", (String)"VERSIONCODE");
        ThemeServices_M.createCssFile();
        if (AppConfig.getLoginModel() != 0) {
            OffLineDBService.createOutLineDB();
        }
        if (AppConfig.getModel().equalsIgnoreCase("run")) {
            logger.info((Object)"*****************\u79fb\u52a8\u8868\u5355\u751f\u6210\u7f13\u5b58\u6587\u4ef6\u5e76\u5f00\u59cb\u52a0\u8f7d\u7f13\u5b58\uff01");
            PatternFileServices_M.createMobilePatternFiles();
            logger.info((Object)"*****************\u79fb\u52a8\u8868\u5355\u7f13\u5b58\u7ed3\u675f\uff01");
        }
        ResServices.recordDefaultResDirFiles(maxVerSionCode);
        ResServices.recordUserJsFiles(maxVerSionCode);
        int tempVerSionCode = maxVerSionCode;
        if (dao.checkResChange(String.valueOf(tempVerSionCode), AppConfig.getServerResVersionCode())) {
            AppConfig.setServerResVersionCode(String.valueOf(tempVerSionCode));
        }
        logger.info((Object)"*****************\u79fb\u52a8\u521d\u59cb\u5316\u8d44\u6e90\u6253\u5305\u5f00\u59cb\uff01");
        String resVersionFileName = FileTools.getFileAbsolutePath("/resource/version.txt");
        HashMap<String, String> versionInfo = new HashMap<String, String>();
        versionInfo.put("resVersionNum", AppConfig.getServerResVersionCode());
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(new IJsonAdapterFactory()).excludeFieldsWithoutExposeAnnotation().create();
        String versionStr = gson.toJson(versionInfo);
        FileTools.writeResult(versionStr, resVersionFileName, "utf-8");
        String sourceFilePath0 = AppConfig.getFileAbsolutePath("/resource/mobile_res/mobilecss/");
        String sourceFilePath1 = AppConfig.getFileAbsolutePath("/resource/mobile_res/mobileDataBase");
        String sourceFilePath2 = AppConfig.getFileAbsolutePath("/resource/mobile_res/mobileimage/");
        String sourceFilePath3 = AppConfig.getFileAbsolutePath("/resource/mobile_res/mobilejs/");
        String sourceFilePath4 = AppConfig.getFileAbsolutePath("/resource/mobile_res/mobilepattern/");
        String sourceFilePath5 = AppConfig.getFileAbsolutePath("/resource/mobile_res/mobilePrintTemplates/");
        String sourceFilePath6 = AppConfig.getFileAbsolutePath("/resource/version.txt");
        String zipFilePath = AppConfig.getFileAbsolutePath("/resource/mobile_res.zip");
        File file = new File(zipFilePath);
        if (file.exists()) {
            file.delete();
        }
        ZipUtils.compress(zipFilePath, sourceFilePath0, sourceFilePath1, sourceFilePath2, sourceFilePath3, sourceFilePath4, sourceFilePath5, sourceFilePath6);
        logger.info((Object)"*****************\u79fb\u52a8\u521d\u59cb\u5316\u8d44\u6e90\u6253\u5305\u7ed3\u675f\uff01");
    }

    private static void recordUserJsFiles(int verSionCode) throws Exception {
        ArrayList<String> jsInfo = dao.getUserJsFiles();
        int i = 0;
        while (i < jsInfo.size()) {
            String dir;
            File jsFile;
            if (!HussarString.isEmpty(jsInfo.get(i)) && (jsFile = new File(dir = AppConfig.getFileAbsolutePath(jsInfo.get(i)))).exists() && jsFile.isFile()) {
                ResFilePo rf = new ResFilePo();
                rf.setId(Guid.create());
                rf.setVersionCode(verSionCode);
                if (jsFile.getName().indexOf(".") > 0) {
                    String tempDirPath;
                    File tempDir;
                    String fileName = jsFile.getName().substring(0, jsFile.getName().lastIndexOf("."));
                    String fileType = jsFile.getName().substring(jsFile.getName().lastIndexOf("."));
                    rf.setFileName(fileName);
                    rf.setFileType(fileType);
                    String realPath = "";
                    if (jsInfo.get(i).lastIndexOf("/") >= 0) {
                        realPath = jsInfo.get(i).substring(0, jsInfo.get(i).lastIndexOf("/") + 1);
                        realPath = realPath.replace("/", File.separator);
                    }
                    rf.setFilePath(String.valueOf(File.separator) + "mobilejs" + File.separator + "user" + realPath);
                    rf.setMd5(FileMD5Util.getFileMD5String(jsFile));
                    dao.save(rf);
                    String tempFilePath = AppConfig.getFileAbsolutePath("/resource/mobile_res/mobilejs/user" + jsInfo.get(i));
                    int dirLength = tempFilePath.lastIndexOf("/");
                    if (dirLength > 0 && !(tempDir = new File(tempDirPath = tempFilePath.substring(0, dirLength))).exists()) {
                        tempDir.mkdirs();
                    }
                    File jsTempFile = new File(tempFilePath);
                    FileTools.copyFile(jsFile, jsTempFile);
                }
            }
            ++i;
        }
    }

    private static void recordDefaultResDirFiles(int verSionCode) throws Exception {
        String dir = AppConfig.getFileAbsolutePath(resDefaultPath);
        File root = new File(dir);
        File[] fs = root.listFiles();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].isFile()) {
                ResFilePo rf = new ResFilePo();
                rf.setId(Guid.create());
                rf.setVersionCode(verSionCode);
                if (fs[i].getName().indexOf(".") > 0) {
                    String fileName = fs[i].getName().substring(0, fs[i].getName().lastIndexOf("."));
                    String fileType = fs[i].getName().substring(fs[i].getName().lastIndexOf("."));
                    rf.setFileName(fileName);
                    rf.setFileType(fileType);
                    rf.setFilePath("");
                    rf.setMd5(FileMD5Util.getFileMD5String(fs[i]));
                    dao.save(rf);
                }
            } else if (fs[i].isDirectory()) {
                ResServices.getFileListByPath(fs[i], String.valueOf(fs[i].getName()) + File.separator, verSionCode);
            }
            ++i;
        }
    }

    private static void getFileListByPath(File dir, String path, int verSionCode) throws Exception {
        File[] fs = dir.listFiles();
        ResFileDao dao = Factory.getDao(ResFileDao.class);
        int i = 0;
        while (i < fs.length) {
            if (fs[i].isFile()) {
                ResFilePo rf = new ResFilePo();
                rf.setId(Guid.create());
                rf.setVersionCode(verSionCode);
                if (fs[i].getName().indexOf(".") > 0) {
                    String fileName = fs[i].getName().substring(0, fs[i].getName().lastIndexOf("."));
                    String fileType = fs[i].getName().substring(fs[i].getName().lastIndexOf("."));
                    rf.setFileName(fileName);
                    rf.setFileType(fileType);
                    rf.setFilePath(path);
                    rf.setMd5(FileMD5Util.getFileMD5String(fs[i]));
                    dao.save(rf);
                }
            } else if (fs[i].isDirectory()) {
                if ("user".equals(fs[i].getName()) && fs[i].getPath().endsWith(String.valueOf(File.separator) + "resource" + File.separator + "mobile_res" + File.separator + "mobilejs" + File.separator + "user")) {
                    return;
                }
                ResServices.getFileListByPath(fs[i], String.valueOf(path) + fs[i].getName() + File.separator, verSionCode);
            }
            ++i;
        }
    }

    private static String getFileContentType(String fileType) {
        String contentType = "";
        if (".png".equals(fileType)) {
            contentType = "image/png";
        } else if (".jpg".equals(fileType)) {
            contentType = "image/jpeg";
        } else if (".js".equals(fileType)) {
            contentType = "application/x-javascript";
        } else if (".txt".equals(fileType)) {
            contentType = "text/plain";
        }
        return contentType;
    }

    public static void updateOffLineUser() throws Exception {
        if (AppConfig.getLoginModel() != 0) {
            ResFileDao dao = Factory.getDao(ResFileDao.class);
            MobileRequestBo request = AppConfig.getMobileRequest();
            String imei = request.getClient().getImei();
            MobileResponseBo response = AppConfig.getMobileResponse();
            String pkValue = dao.getOffLineUserIds(imei);
            if (!HussarString.isEmpty(pkValue)) {
                ArrayList<DataSet> downloadDatas = new ArrayList<DataSet>();
                DataSet data = DataSyncServices.downLoadDataJson("", "JXD7_XT_USER", "USERID", pkValue);
                if (data != null) {
                    downloadDatas.add(data);
                }
                if (downloadDatas.size() > 0) {
                    ArrayList<Object> params = new ArrayList<Object>();
                    params.add(downloadDatas);
                    MobileMethod nextMethod = new MobileMethod();
                    nextMethod.setType(Const.Action.ActionType.MOBILE);
                    nextMethod.setMethodName("SAVEDOWNLOADUSERDATA");
                    nextMethod.setParams(params);
                    response.setNextMethod(nextMethod);
                }
            }
        }
    }
}

