/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.permit.services.support;

import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.utils.Guid;
import com.sdjxd.hussar.core.utils.HussarDate;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.hussar.mobile.base.bo.MobileRequestBo;
import com.sdjxd.hussar.mobile.base.bo.MobileResponseBo;
import com.sdjxd.hussar.mobile.permit.dao.PermitDao;
import com.sdjxd.hussar.mobile.permit.po.PermitClientPo;
import com.sdjxd.hussar.mobile.permit.po.PermitUserPo;
import com.sdjxd.hussar.mobile.permit.services.IPermitServices_M;

public class PermitServices_M
implements IPermitServices_M {
    private static PermitDao permitDao;

    static {
        try {
            permitDao = Factory.getDao(PermitDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkMobilePermit(MobileRequestBo request, MobileResponseBo response) throws Exception {
        String sfsjzc = AppConfig.getConfig("SFSJZC");
        Boolean result = true;
        if (sfsjzc != null && "TRUE".equals(sfsjzc.toUpperCase())) {
            String imei = request.getClient().getImei();
            PermitClientPo clientPo = permitDao.getPermitClientPo(imei);
            PermitUserPo userPo = null;
            if (clientPo != null) {
                userPo = permitDao.getPermitUserInfo(request.getMobileUser().getId(), clientPo.getClientId());
                if (userPo != null) {
                    if (!clientPo.isValId()) {
                        response.setStatuCode(MobileResponseBo.StatusCode.CLIENTUNVERIFY);
                        result = false;
                    } else if (clientPo.isLocked()) {
                        response.setStatuCode(MobileResponseBo.StatusCode.CLIENTLOCK);
                        result = false;
                    } else if (!userPo.getValId()) {
                        response.setStatuCode(MobileResponseBo.StatusCode.USERUNVERIFY);
                        result = false;
                    } else if (userPo.getLocked()) {
                        response.setStatuCode(MobileResponseBo.StatusCode.USERLOCK);
                        result = false;
                    }
                } else {
                    userPo = new PermitUserPo();
                    userPo.setClientId(clientPo.getClientId());
                    userPo.setUserId(request.getMobileUser().getId());
                    String now = HussarDate.getNow();
                    userPo.setRegisterTime(now);
                    permitDao.savePermitUser(userPo);
                    response.setStatuCode(MobileResponseBo.StatusCode.USERNOTMATCHMOBILE);
                    result = false;
                }
            } else {
                clientPo = new PermitClientPo();
                clientPo.setClientId(Guid.create());
                clientPo.setDeptId(request.getMobileUser().getDeptId());
                clientPo.setImei(imei);
                clientPo.setLocked(false);
                clientPo.setValId(false);
                clientPo.setName(String.valueOf(request.getMobileUser().getName()) + "\u7684\u624b\u673a");
                permitDao.savePermitClient(clientPo);
                userPo = new PermitUserPo();
                userPo.setClientId(clientPo.getClientId());
                userPo.setUserId(request.getMobileUser().getId());
                String now = HussarDate.getNow();
                userPo.setRegisterTime(now);
                permitDao.savePermitUser(userPo);
                response.setStatuCode(MobileResponseBo.StatusCode.UNLINKMOBILE);
                result = false;
            }
        }
        return result;
    }
}

