/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.offline.database.sqlite;

import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.utils.FileTools;
import com.sdjxd.hussar.mobile.offline.dao.OutLineDao;
import com.sdjxd.hussar.mobile.utils.SQLiteTools;
import com.sdjxd.pms.platform.base.Global;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;

public class OffLineDBService {
    private static String filePath = "/resource/mobile_res/mobileDataBase/base.db";
    protected static OutLineDao dao;

    static {
        try {
            dao = Factory.getDao(OutLineDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean createOutLineDB() {
        String filepath = String.valueOf(Global.getPath().replace("\\", "/")) + filePath;
        File file = new File(filepath);
        if (file.exists() && file.isFile()) {
            file.delete();
        } else {
            String dir;
            File root;
            int dirLength = filepath.lastIndexOf("/");
            if (dirLength > 0 && !(root = new File(dir = filepath.substring(0, dirLength))).exists()) {
                root.mkdirs();
            }
        }
        if (OffLineDBService.initBaseTable()) {
            try {
                return OffLineDBService.initView();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private static boolean initBaseTable() {
        return dao.initBaseTable(filePath);
    }

    private static boolean initView() throws Exception {
        ArrayList<String> viewCreateSqlList = new ArrayList<String>();
        String filePath = FileTools.getFileAbsolutePath("/WEB-INF/offlinedbview.xml");
        Document doc = FileTools.readFile(filePath);
        List viewList = doc.selectNodes("/DB_VIEWS/VIEW/SQL");
        int i = 0;
        while (i < viewList.size()) {
            Node view = (Node)viewList.get(i);
            String viewSql = view.getText();
            if (viewSql != null && !viewSql.equals("")) {
                viewCreateSqlList.add(viewSql);
            }
            ++i;
        }
        if (viewCreateSqlList.size() > 0) {
            try {
                if (SQLiteTools.executeNonQuery(OffLineDBService.filePath, viewCreateSqlList) == -1) {
                    return false;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

