/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.offline.data.dao.support.sql;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.mobile.offline.data.bo.DataItem;
import com.sdjxd.hussar.mobile.offline.data.bo.DataSet;
import com.sdjxd.hussar.mobile.offline.data.dao.DataSyncDao;
import com.sdjxd.pms.platform.data.DbOper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;

public class DataSyncDaoImpl
implements DataSyncDao {
    @Override
    public DataSet getTableData(String dataSourceName, String tableName, String keyCol, String keyValue) throws SQLException {
        DataSet downLoadData = new DataSet();
        downLoadData.setTableName(tableName);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(keyCol);
        downLoadData.setKeys(keys);
        StringBuffer tableSql = new StringBuffer();
        tableSql.append("SELECT TABLETYPE FROM [S].JXD7_M_OFFLINE_BASETABLE WHERE TABLECODE='").append(tableName).append("'");
        RowSet rs = DbOper.executeQuery((String)tableSql.toString());
        if (rs.next() && !HussarString.isEmpty(rs.getString("TABLETYPE"))) {
            downLoadData.setTableType(Const.OffLineData.TABLETYPE.values()[Integer.parseInt(rs.getString("TABLETYPE"))]);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM [S].").append(tableName).append(" WHERE ").append(keyCol).append(" IN (").append(keyValue).append(")");
        ArrayList datas = DbOper.executeList((String)dataSourceName, (String)sql.toString());
        if (datas.size() > 0) {
            ArrayList<DataItem> items = new ArrayList<DataItem>();
            for (Map data : datas) {
                DataItem item = new DataItem();
                item.setAttrs(data);
                items.add(item);
            }
            downLoadData.setDatas(items);
            return downLoadData;
        }
        return null;
    }

    @Override
    public DataSet getTableData(String listStyleId, String keyValue) throws SQLException {
        if (HussarString.isEmpty(keyValue)) {
            return null;
        }
        StringBuffer tableSql = new StringBuffer();
        tableSql.append("SELECT TABLENAME,PKCOL,DATASOURCENAME FROM JXD7_XT_SYSTABLEINFO T , JXD7_PM_LISTSTYLE S WHERE T.TABLEID=S.TABLEID AND ").append(" STYLEID='").append(listStyleId).append("'");
        RowSet rs = DbOper.executeQuery((String)tableSql.toString());
        if (rs.next()) {
            return this.getTableData(rs.getString("DATASOURCENAME"), rs.getString("TABLENAME"), rs.getString("PKCOL"), keyValue);
        }
        return null;
    }

    @Override
    public boolean saveUploadData(List<DataSet> datas) {
        if (datas != null) {
            ArrayList<String> sqls = new ArrayList<String>();
            for (DataSet data : datas) {
                String tableName = data.getTableName();
                List<String> keys = data.getKeys();
                List<DataItem> dataItems = data.getDatas();
                if (dataItems == null) continue;
                for (DataItem item : dataItems) {
                    if (item.getFlag() == Const.OffLineData.DATAFLAG.NEW) {
                        if (item.getAttrs() == null || item.getAttrs().size() <= 0) continue;
                        StringBuffer insertSql = new StringBuffer();
                        insertSql.append("INSERT INTO ").append(tableName);
                        StringBuffer attr = new StringBuffer();
                        StringBuffer value = new StringBuffer();
                        for (Map.Entry<String, String> entry : item.getAttrs().entrySet()) {
                            attr.append("").append(entry.getKey()).append(",");
                            value.append("'").append(entry.getValue()).append("',");
                        }
                        insertSql.append("(").append(attr.substring(0, attr.length() - 1)).append(")VALUES(").append(value.substring(0, value.length() - 1)).append(")");
                        sqls.add(insertSql.toString());
                        continue;
                    }
                    if (item.getFlag() == Const.OffLineData.DATAFLAG.MODIFY) {
                        if (item.getAttrs() == null || item.getAttrs().size() <= 0 || keys.size() <= 0) continue;
                        StringBuffer updateSql = new StringBuffer();
                        updateSql.append("UPDATE ").append(tableName).append(" SET ");
                        StringBuffer temp = new StringBuffer();
                        for (Map.Entry<String, String> entry2 : item.getAttrs().entrySet()) {
                            temp.append(entry2.getKey()).append("='").append(entry2.getValue()).append("',");
                        }
                        StringBuffer whereSql = new StringBuffer(" WHERE ");
                        for (String string : keys) {
                            whereSql.append(string).append("='").append(item.getAttrs().get(string)).append("' AND ");
                        }
                        updateSql.append(temp.substring(0, temp.length() - 1)).append(whereSql.substring(0, whereSql.length() - 5));
                        sqls.add(updateSql.toString());
                        continue;
                    }
                    if (item.getFlag() != Const.OffLineData.DATAFLAG.DELETE || item.getAttrs() == null || item.getAttrs().size() <= 0 || keys.size() <= 0) continue;
                    StringBuffer deleteSql = new StringBuffer();
                    deleteSql.append("DELETE FROM ").append(tableName).append(" ");
                    StringBuffer whereSql = new StringBuffer(" WHERE ");
                    for (String key : keys) {
                        whereSql.append(key).append("='").append(item.getAttrs().get(key)).append("' AND ");
                    }
                    deleteSql.append(whereSql.substring(0, whereSql.length() - 5));
                    sqls.add(deleteSql.toString());
                }
            }
            try {
                DbOper.executeNonQuery(sqls);
                return true;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

