/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.offline.dao.support.sql;

import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.mobile.offline.dao.OutLineDao;
import com.sdjxd.hussar.mobile.utils.SQLiteTools;
import com.sdjxd.pms.platform.data.DbOper;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.RowSet;

public class OutLineDaoImpl
implements OutLineDao {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean initBaseTable(String filePath) {
        String tableAttrs = null;
        String tableName = null;
        String filter = null;
        String tableType = null;
        String strSql = "SELECT ATTRS,TABLECODE,FILTER,TABLETYPE FROM JXD7_M_OFFLINE_BASETABLE ";
        try {
            RowSet rs = DbOper.executeQuery((String)strSql);
            while (rs.next()) {
                tableAttrs = rs.getString("ATTRS");
                List<String> sqlList = this.createDatatable(tableAttrs, tableName = rs.getString("TABLECODE"), filter = rs.getString("FILTER"), tableType = rs.getString("TABLETYPE"));
                if (sqlList.size() > 2000) {
                    int i = 0;
                    while (i < sqlList.size() / 2000 + 1) {
                        int begin = i * 2000;
                        int end = (i + 1) * 2000 - 1;
                        List<String> sqlListItem = end < sqlList.size() ? sqlList.subList(begin, end) : sqlList.subList(begin, sqlList.size());
                        if (sqlListItem.size() > 0 && SQLiteTools.executeNonQuery(filePath, sqlListItem) == -1) {
                            return false;
                        }
                        ++i;
                    }
                    continue;
                }
                if (SQLiteTools.executeNonQuery(filePath, sqlList) != -1) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private List<String> createDatatable(String tableAttrs, String tableName, String filter, String tableType) throws Exception {
        String pkStr;
        RowSet rs;
        ResultSetMetaData dbMetaData;
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer selectSql = new StringBuffer();
        StringBuffer updateSql = new StringBuffer();
        if (HussarString.isEmpty(tableAttrs)) {
            tableAttrs = "*";
        }
        selectSql.append("SELECT ").append(tableAttrs).append(" FROM ").append(tableName);
        if (!HussarString.isEmpty(filter)) {
            selectSql.append(" WHERE ").append(filter);
        }
        if ((dbMetaData = (rs = DbOper.executeQuery((String)selectSql.toString())).getMetaData()).getColumnCount() <= 0) {
            return null;
        }
        updateSql.append("DROP TABLE IF EXISTS ").append(tableName);
        list.add(updateSql.toString());
        updateSql.setLength(0);
        updateSql.append("CREATE TABLE IF NOT EXISTS [").append(tableName).append("] ( ");
        int i = 1;
        while (i <= dbMetaData.getColumnCount()) {
            String strColumnName = dbMetaData.getColumnName(i);
            int iColumnLength = dbMetaData.getColumnDisplaySize(i);
            String strColumnType = dbMetaData.getColumnTypeName(i);
            if ("VARCHAR2".equalsIgnoreCase(strColumnType) || "CHAR".equalsIgnoreCase(strColumnType) || "VARCHAR".equalsIgnoreCase(strColumnType)) {
                updateSql.append("[").append(strColumnName).append("]").append(" VARCHAR(").append(iColumnLength).append("),");
            } else if ("NVARCHAR".equalsIgnoreCase(strColumnType)) {
                updateSql.append("[").append(strColumnName).append("]").append(" NVARCHAR(").append(iColumnLength).append("),");
            } else if ("NUMBER".equalsIgnoreCase(strColumnType)) {
                updateSql.append("[").append(strColumnName).append("]").append(" NUMERIC,");
            } else if ("INT".equalsIgnoreCase(strColumnType)) {
                updateSql.append("[").append(strColumnName).append("]").append(" INTEGER,");
            } else if ("DATE".equalsIgnoreCase(strColumnType)) {
                updateSql.append("[").append(strColumnName).append("]").append(" VARCHAR(50),");
            } else if ("BLOB".equalsIgnoreCase(strColumnType)) {
                updateSql.append("[").append(strColumnName).append("]").append(" BLOB,");
            } else {
                updateSql.append("[").append(strColumnName).append("]").append(" VARCHAR(1000),");
            }
            ++i;
        }
        if ("1".equals(tableType) || "JXD7_PM_FILE".equalsIgnoreCase(tableName)) {
            updateSql.append(" MOBILEDATAFLAG  VARCHAR(50),");
        }
        if ((pkStr = this.findPK(tableName)) != null) {
            updateSql.append(pkStr).append(")");
            list.add(updateSql.toString());
        } else {
            list.add(String.valueOf(updateSql.substring(0, updateSql.length() - 1)) + ")");
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer value = new StringBuffer();
        StringBuffer dataSql = new StringBuffer();
        while (rs.next()) {
            sql.setLength(0);
            value.setLength(0);
            dataSql.setLength(0);
            sql.append(" INSERT INTO ").append(tableName).append("(");
            int i2 = 1;
            while (i2 <= dbMetaData.getColumnCount()) {
                String strColumnName = dbMetaData.getColumnName(i2);
                sql.append("[").append(strColumnName).append("]").append(",");
                if (strColumnName.equals("SQL") || strColumnName.equals("FILTER") || strColumnName.equals("ATTCOLUMN") || strColumnName.equals("COLUMNID")) {
                    value.append("'");
                    if (rs.getString(strColumnName) != null) {
                        value.append(rs.getString(strColumnName).replace("'", "''"));
                    }
                    value.append("',");
                } else if (!HussarString.isEmpty(rs.getString(strColumnName)) && rs.getString(strColumnName).indexOf("'") > 0) {
                    value.append("'").append(rs.getString(strColumnName).replace("'", "''")).append("',");
                } else {
                    value.append("'").append(rs.getString(strColumnName)).append("',");
                }
                ++i2;
            }
            if ("1".equals(tableType) || "JXD7_PM_FILE".equalsIgnoreCase(tableName)) {
                sql.append("[MOBILEDATAFLAG]").append(",");
                value.append("'0',");
            }
            dataSql.append(sql.substring(0, sql.length() - 1)).append(")VALUES(").append(value.substring(0, value.length() - 1)).append(")");
            list.add(dataSql.toString());
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (String sqlString : list) {
            list2.add(sqlString.replace("'null'", "NULL").replace("'NULL'", "NULL"));
        }
        return list2;
    }

    protected String findPK(String tableName) throws SQLException {
        StringBuffer keySql = new StringBuffer("SELECT    COL_NAME(OBJECT_ID('");
        keySql.append(tableName).append("'),COLID)  'PKCOL' FROM  SYSOBJECTS  AS O INNER JOIN SYSINDEXES    AS I ON I.NAME=O.NAME INNER JOIN SYSINDEXKEYS  AS K ON K.INDID=I.INDID ");
        keySql.append(" WHERE O.XTYPE = 'PK' AND PARENT_OBJ=OBJECT_ID('").append(tableName).append("') AND K.ID=OBJECT_ID('").append(tableName).append("')");
        RowSet pkrs = DbOper.executeQuery((String)keySql.toString());
        StringBuffer pks = new StringBuffer(256);
        pks.append(" PRIMARY KEY (");
        while (pkrs.next()) {
            pks.append(String.valueOf(pkrs.getString("PKCOL")) + ",");
        }
        pks.setLength(pks.length() - 1);
        if (pks.length() > 14) {
            pks.append(")");
            return pks.toString();
        }
        return null;
    }
}

