/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.key.services;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.hussar.mobile.key.dao.KeyDao;
import com.sdjxd.hussar.mobile.key.po.KeyPo;
import com.sdjxd.hussar.mobile.utils.AESUtil;
import com.sdjxd.hussar.mobile.utils.RSAUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.Base64;

public class KeyServices {
    private static String publicKey = "";
    private static String isneedkeyserver = "false";
    private static String keyserverurl = "";
    private static RSAUtil rsaEncrypt;

    static {
        KeyServices.getKeys();
    }

    public static void getKeys() {
        isneedkeyserver = AppConfig.getConfig("ISNEEDKEYSERVER");
        keyserverurl = AppConfig.getConfig("KEYSERVERURL");
        if ("true".equalsIgnoreCase(AppConfig.getConfig("ISUSEKEY"))) {
            KeyServices.readkeys();
        }
    }

    private static void readkeys() {
        if (!isneedkeyserver.equalsIgnoreCase("true")) {
            rsaEncrypt = new RSAUtil();
            rsaEncrypt.createKey();
            publicKey = Base64.encode((byte[])rsaEncrypt.getPublicKey().getEncoded());
        }
    }

    public static String getPublicKey() throws ServiceException, MalformedURLException, RemoteException {
        if (isneedkeyserver.equalsIgnoreCase("true")) {
            String endpoint = keyserverurl;
            Service service = new Service();
            Call call = null;
            call = (Call)service.createCall();
            call.setOperationName(new QName(endpoint, "getPublicKey"));
            call.setTargetEndpointAddress(new URL(endpoint));
            publicKey = (String)call.invoke(new Object[0]);
        }
        return publicKey;
    }

    public static String decryptContent(String data) throws Exception {
        Gson gson = new Gson();
        Map datamap = (Map)gson.fromJson(data, new TypeToken<Map<String, String>>(){}.getType());
        String context = (String)datamap.get("content");
        String imei = (String)datamap.get("imei");
        if (isneedkeyserver.equalsIgnoreCase("true")) {
            String keyStr = "";
            keyStr = KeyServices.getdeskeystrbyimei(imei);
            String endpoint = keyserverurl;
            Service service = new Service();
            Call call = null;
            try {
                call = (Call)service.createCall();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            call.setOperationName(new QName(endpoint, "decryptContent"));
            call.setTargetEndpointAddress(new URL(endpoint));
            context = (String)call.invoke(new Object[]{context, keyStr});
        } else {
            byte[] signdata = Base64.decode((String)context);
            byte[] key = KeyServices.getdeskeybyimei(imei);
            context = new String(AESUtil.decrypt(signdata, key), "GBK");
        }
        return context;
    }

    public static String getIMEIFromParam(String param) {
        Gson gson = new Gson();
        Map datamap = (Map)gson.fromJson(param, new TypeToken<Map<String, String>>(){}.getType());
        String imei = (String)datamap.get("imei");
        return imei;
    }

    public static String EncryptionContent(String data, String imei) throws Exception {
        String EncryptionContentStr = "";
        if (isneedkeyserver.equalsIgnoreCase("true")) {
            String keyStr = KeyServices.getdeskeystrbyimei(imei);
            String endpoint = keyserverurl;
            Service service = new Service();
            Call call = null;
            call = (Call)service.createCall();
            call.setOperationName(new QName(endpoint, "EncryptionContent"));
            call.setTargetEndpointAddress(new URL(endpoint));
            EncryptionContentStr = (String)call.invoke(new Object[]{data, keyStr});
        } else {
            byte[] key = KeyServices.getdeskeybyimei(imei);
            byte[] signdata = AESUtil.encrypt(data.getBytes("GBK"), key);
            EncryptionContentStr = Base64.encode((byte[])signdata);
        }
        return EncryptionContentStr;
    }

    public static byte[] getdeskeybyimei(String imei) throws Exception {
        return KeyServices.getdeskeystrbyimei(imei).getBytes("GBK");
    }

    public static String getdeskeystrbyimei(String imei) throws Exception {
        KeyDao dao = Factory.getDao(KeyDao.class);
        KeyPo key = dao.getKey(imei);
        return key.getSymmetricKey();
    }

    public static String rsaDecrypt(String data) throws ServiceException, MalformedURLException, RemoteException, UnsupportedEncodingException {
        String reValue = "";
        if (isneedkeyserver.equalsIgnoreCase("true")) {
            String endpoint = keyserverurl;
            Service service = new Service();
            Call call = null;
            call = (Call)service.createCall();
            call.setOperationName(new QName(endpoint, "rsaDecrypt"));
            call.setTargetEndpointAddress(new URL(endpoint));
            reValue = (String)call.invoke(new Object[]{data});
        } else {
            reValue = new String(rsaEncrypt.rsaDecrypt(Base64.decode((String)data)), "GBK");
        }
        return reValue;
    }

    public static String rsaSign(String imei_jm) throws ServiceException, MalformedURLException, RemoteException {
        String resultStr = "";
        if (isneedkeyserver.equalsIgnoreCase("true")) {
            String endpoint = keyserverurl;
            Service service = new Service();
            Call call = null;
            call = (Call)service.createCall();
            call.setOperationName(new QName(endpoint, "rsaDecrypt"));
            call.setTargetEndpointAddress(new URL(endpoint));
            resultStr = (String)call.invoke(new Object[]{imei_jm});
        } else {
            try {
                resultStr = Base64.encode((byte[])rsaEncrypt.rsaSign(imei_jm.getBytes("GBK")));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return resultStr;
    }

    public static void saveSymmetricKey(String imei, String symmetricKey) throws Exception {
        KeyPo key = new KeyPo();
        key.setImei(imei);
        key.setSymmetricKey(symmetricKey);
        KeyDao dao = Factory.getDao(KeyDao.class);
        dao.saveKey(key);
    }

    public static void main(String[] args) {
    }
}

