/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.form.services;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.bo.HussarJsonObject;
import com.sdjxd.hussar.core.entity72.bo.IEntityPatternBo;
import com.sdjxd.hussar.core.entity72.service.IEntityService;
import com.sdjxd.hussar.core.form72.bo.FormCellInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormInstanceBo;
import com.sdjxd.hussar.core.form72.bo.IFormCellBo;
import com.sdjxd.hussar.core.form72.bo.IFormPatternBo;
import com.sdjxd.hussar.core.form72.bo.cell.FormCellList;
import com.sdjxd.hussar.core.form72.bo.cell.FormCellSign;
import com.sdjxd.hussar.core.form72.bo.cell.comboBox.FormCellComplexComboBox;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectComboBox;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectList;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectTree;
import com.sdjxd.hussar.core.form72.bo.cellData.ListData;
import com.sdjxd.hussar.core.form72.bo.cellData.OptionBo;
import com.sdjxd.hussar.core.form72.bo.cellData.Options;
import com.sdjxd.hussar.core.form72.bo.cellData.TreeNodeBo;
import com.sdjxd.hussar.core.form72.bo.cellData.TreeNodes;
import com.sdjxd.hussar.core.form72.platEntity72.bo.IPlatEntityPatternBo;
import com.sdjxd.hussar.core.form72.platEntity72.service.IPlatEntityservice;
import com.sdjxd.hussar.core.form72.po.FormCellPo;
import com.sdjxd.hussar.core.form72.service.support.CellAttributeServices;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.permit72.exception.LoginException;
import com.sdjxd.hussar.core.permit72.service.IUserService;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.hussar.mobile.base.bo.MobileClientBo;
import com.sdjxd.hussar.mobile.base.bo.MobileMethod;
import com.sdjxd.hussar.mobile.base.bo.MobileRequestBo;
import com.sdjxd.hussar.mobile.base.bo.MobileResponseBo;
import com.sdjxd.hussar.mobile.form.bo.IFormSessionBo_M;
import com.sdjxd.hussar.mobile.form.services.WelComePageServices;
import com.sdjxd.hussar.mobile.offline.data.bo.DataItem;
import com.sdjxd.hussar.mobile.offline.data.bo.DataSet;
import com.sdjxd.hussar.mobile.offline.data.services.DataSyncServices;
import com.sdjxd.hussar.mobile.permit.services.IPermitServices_M;
import com.sdjxd.hussar.mobile.resouces.services.ResServices;
import com.sdjxd.hussar.mobile.workFlow.services.IWorkFlowServices_M;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.ListMap;
import com.sdjxd.pms.platform.form.dao.PatternDao;
import com.sdjxd.pms.platform.form.model.TreeNodeBean;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import com.sdjxd.pms.platform.workflow.service.FlowOperatorManager;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

public class ServerMethod {
    private static Logger log = Logger.getLogger(ServerMethod.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void login(String userCode, String pwd, Map<String, String> info) throws Exception {
        String imei = info.get("imei");
        String sim = info.get("sim");
        String resolution = info.get("resolution");
        String device = info.get("device");
        MobileRequestBo request = AppConfig.getMobileRequest();
        MobileClientBo client = new MobileClientBo(imei, sim, resolution, device);
        request.setClient(client);
        ResServices.checkVersion(info);
        MobileResponseBo response = AppConfig.getMobileResponse();
        if (response.getApp() != null) return;
        IUserService userServices = Factory.getService(Const.LAYER.CORE, IUserService.class);
        IUserBo mobileUser = userServices.load(Const.Permit.User.ID_TYPE.USERCODE, userCode);
        if (AppConfig.getIsUseSession()) {
            response.setSessionId(Global.getContext().getSessionId());
        }
        try {
            if (userServices.login(mobileUser, pwd)) {
                IPermitServices_M mobilePermit;
                request.setMobileUser(mobileUser);
                response.setMobileUser(mobileUser);
                response.setMobileClient(client);
                if (AppConfig.getIsUseSession()) {
                    request.registClient();
                    request.registUser();
                    response.setSessionId(AppConfig.getSessionId());
                }
                if (!(mobilePermit = Factory.getService(Const.LAYER.MOBILE, IPermitServices_M.class)).checkMobilePermit(request, response)) return;
                String welcomePageId = WelComePageServices.getWeclomePageId();
                if (welcomePageId == null) {
                    response.setStatuCode(MobileResponseBo.StatusCode.NOPERMIT);
                    return;
                } else {
                    ServerMethod.getMobilePage("0", "self", welcomePageId, false, 0, null, null);
                }
                return;
            } else {
                response.setStatuCode(MobileResponseBo.StatusCode.LOGINERROR);
            }
            return;
        }
        catch (LoginException e) {
            response.setStatuCode(MobileResponseBo.StatusCode.LOGINERROR);
        }
    }

    public static void login(String userCode, String pwd, String imei, String sim, String resolution, String clientAppVersion, String clientResVersion) throws Exception {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("appversion", clientAppVersion);
        info.put("resversion", clientResVersion);
        info.put("device", "ios".equals(clientAppVersion) ? "iPhone" : "Android");
        info.put("programtype", "0");
        info.put("imei", imei);
        info.put("sim", sim);
        info.put("resolution", resolution);
        ServerMethod.login(userCode, pwd, info);
    }

    public static void getMobilePage(String openType, String target, String patternId, boolean isReadOnly, int closePageNum, Map<String, String> urlParamsMap, String formInstanceId) throws Exception {
        if (urlParamsMap != null && urlParamsMap.get("_pkid") != null) {
            formInstanceId = urlParamsMap.get("_pkid");
        } else if (urlParamsMap == null) {
            urlParamsMap = new HashMap<String, String>();
            urlParamsMap.put("_pkid", formInstanceId);
        } else {
            urlParamsMap.put("_pkid", formInstanceId);
        }
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        MobileRequestBo request = AppConfig.getMobileRequest();
        request.addUrlMap(urlParamsMap);
        MobileResponseBo response = AppConfig.getMobileResponse();
        IUserBo user = request.getMobileUser();
        IFormSessionBo_M formSession = formSessionServices.create(user, patternId, formInstanceId, isReadOnly, Const.Form.OpenType.values()[Integer.parseInt(openType)], target, urlParamsMap);
        ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
        mobileForms.add(formSession);
        if (request.getUrlMap() != null && request.getUrlMap().get("_pkid_c") != null) {
            formInstanceId = request.getUrlMap().get("_pkid_c");
            formSession.getFormInstance().setId(formInstanceId);
        }
        if (request.getUrlMap() != null && (request.getUrlMap().get("_pkid") == null || "".equals(request.getUrlMap().get("_pkid")))) {
            urlParamsMap.put("_pkid", formSession.getFormInstance().getId());
        }
        response.setMobileForms(mobileForms);
        response.setColsePageNum(closePageNum);
    }

    public static void getMobilePage(String openType, String target, String patternId, int closePageNum, Map<String, String> urlParamsMap, String formInstanceId) throws Exception {
        if (urlParamsMap != null && urlParamsMap.get("_pkid") != null) {
            formInstanceId = urlParamsMap.get("_pkid");
        } else if (urlParamsMap == null) {
            urlParamsMap = new HashMap<String, String>();
            urlParamsMap.put("_pkid", formInstanceId);
        } else {
            urlParamsMap.put("_pkid", formInstanceId);
        }
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        MobileRequestBo request = AppConfig.getMobileRequest();
        request.addUrlMap(urlParamsMap);
        MobileResponseBo response = AppConfig.getMobileResponse();
        IUserBo user = request.getMobileUser();
        if (HussarString.isEmpty(formInstanceId)) {
            response.setMsg("\u6253\u5f00\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\u627e\u4e0d\u5230\u8868\u5355\u5b9e\u4f8b\uff01");
            return;
        }
        IFormSessionBo_M formSession = formSessionServices.openFormSessonByFlow(user, patternId, null, formInstanceId, Const.Form.OpenType.values()[Integer.parseInt(openType)], target, urlParamsMap);
        ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
        if (formSession.getFormInstance().getFlowNodes() != null) {
            HashMap<String, String> urlParamsMap2 = new HashMap<String, String>();
            urlParamsMap.put("FORMSESSIONID", formSession.getId());
            request.addUrlMap(urlParamsMap2);
            IFormSessionBo_M selectNodes = formSessionServices.create(user, "1E32998F-13FA-4F35-A7D8-637414A73F21", null, false, Const.Form.OpenType.DAILOG, "self", urlParamsMap);
            Options options = new Options();
            options.setOpts(formSession.getFormInstance().getFlowNodes());
            selectNodes.setFormCellPatternData(0, options);
            mobileForms.add(selectNodes);
            response.setMobileForms(mobileForms);
        } else if (!(formSession.getFormInstance().isReadOnly() || formSession.getUserLimitGroups() != null && formSession.getUserLimitGroups().size() != 0)) {
            formSession.getFormInstance().setReadOnly(true);
            mobileForms.add(formSession);
            response.setMobileForms(mobileForms);
        } else {
            mobileForms.add(formSession);
            response.setMobileForms(mobileForms);
        }
        if (request.getUrlMap() != null && (request.getUrlMap().get("_pkid") == null || "".equals(request.getUrlMap().get("_pkid")))) {
            urlParamsMap.put("_pkid", formSession.getFormInstance().getId());
        }
        response.setColsePageNum(closePageNum);
    }

    public static void getMobilePage(String openType, String target, String patternId, String flowId, int closePageNum, Map<String, String> urlParamsMap, String formInstanceId) throws Exception {
        if (urlParamsMap == null) {
            urlParamsMap = new HashMap<String, String>();
        }
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        MobileRequestBo request = AppConfig.getMobileRequest();
        request.addUrlMap(urlParamsMap);
        MobileResponseBo response = AppConfig.getMobileResponse();
        IUserBo user = request.getMobileUser();
        try {
            IFormSessionBo_M formSession = formSessionServices.openFormSessonByFlow(user, patternId, flowId, null, Const.Form.OpenType.values()[Integer.parseInt(openType)], target, urlParamsMap);
            ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
            if (formSession.getFormInstance().getFlowNodes() != null) {
                HashMap<String, String> urlParamsMap2 = new HashMap<String, String>();
                urlParamsMap.put("FORMSESSIONID", formSession.getId());
                request.addUrlMap(urlParamsMap2);
                IFormSessionBo_M selectNodes = formSessionServices.create(user, "1E32998F-13FA-4F35-A7D8-637414A73F21", null, false, Const.Form.OpenType.DAILOG, "self", urlParamsMap);
                Options options = new Options();
                options.setOpts(formSession.getFormInstance().getFlowNodes());
                selectNodes.setFormCellPatternData(0, options);
                mobileForms.add(selectNodes);
                response.setMobileForms(mobileForms);
            } else if (!(formSession.getFormInstance().isReadOnly() || formSession.getUserLimitGroups() != null && formSession.getUserLimitGroups().size() != 0)) {
                formSession.getFormInstance().setReadOnly(true);
                mobileForms.add(formSession);
                response.setMobileForms(mobileForms);
            } else {
                mobileForms.add(formSession);
                response.setMobileForms(mobileForms);
            }
            urlParamsMap.put("_pkid", formSession.getFormInstance().getId());
            response.setColsePageNum(closePageNum);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMsg(e.getMessage());
        }
    }

    public static void getMobilePageByFlowNodeInstanceId(Map<String, String> urlParamsMap) throws Exception {
        MobileRequestBo request = AppConfig.getMobileRequest();
        MobileResponseBo response = AppConfig.getMobileResponse();
        String formSessionId = urlParamsMap.get("FORMSESSIONID");
        String flowNodeInstanceId = urlParamsMap.get("FLOWNODEINSTANCEID");
        IUserBo user = request.getMobileUser();
        if (!HussarString.isEmpty(formSessionId) && !HussarString.isEmpty(flowNodeInstanceId)) {
            IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
            IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
            formSession.modifySessionByFlowNodeInstanceId(user, Integer.parseInt(flowNodeInstanceId), formSession.getPatternId());
            ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
            mobileForms.add(formSession);
            response.setMobileForms(mobileForms);
            response.setColsePageNum(1);
        } else {
            response.setMsg("\u8bf7\u9009\u62e9\u4f60\u8981\u6253\u5f00\u7684\u6d41\u7a0b\u8282\u70b9");
        }
    }

    public static void closeInstances(String formSessionId) throws Exception {
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        MobileRequestBo request = AppConfig.getMobileRequest();
        MobileResponseBo response = AppConfig.getMobileResponse();
        IUserBo user = request.getMobileUser();
        IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
        if (formSession == null && request.getUrlMap() != null) {
            String patternId = request.getUrlMap().get("_P");
            String formInstanceId = request.getUrlMap().get("_S");
            if (!HussarString.isEmpty(request.getUrlMap().get("_F"))) {
                Const.Data.Modify modify = Const.Data.Modify.valueOf(request.getUrlMap().get("_F"));
                if (modify.equals((Object)Const.Data.Modify.NEW)) {
                    formSession = formSessionServices.create(user, patternId, null, false, Const.Form.OpenType.NEW, "self", false, request.getUrlMap());
                    formSession.getFormInstance().setId(formInstanceId);
                } else {
                    formSession = formSessionServices.create(user, patternId, formInstanceId, false, Const.Form.OpenType.NEW, "self", false, request.getUrlMap());
                }
            }
        }
        if (formSession != null && formSession.getFormInstance().getModify() != Const.Data.Modify.NEW) {
            try {
                formSession.close(user);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        response.setStatuCode(MobileResponseBo.StatusCode.NORMAL);
    }

    public static boolean saveInstancesOnly(String formSessionId, Map<Integer, FormCellInstanceBo> formInstanceData) throws Exception {
        String patternId;
        boolean saveSucess = false;
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        MobileRequestBo request = AppConfig.getMobileRequest();
        MobileResponseBo response = AppConfig.getMobileResponse();
        IUserBo user = request.getMobileUser();
        IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
        if (formSession == null) {
            patternId = request.getUrlMap().get("_P");
            String formInstanceId = request.getUrlMap().get("_S");
            Const.Data.Modify modify = Const.Data.Modify.valueOf(request.getUrlMap().get("_F"));
            if (modify.equals((Object)Const.Data.Modify.NEW)) {
                formSession = formSessionServices.create(user, patternId, null, false, Const.Form.OpenType.NEW, "self", request.getUrlMap());
                formSession.getFormInstance().setId(formInstanceId);
            } else {
                formSession = formSessionServices.create(user, patternId, formInstanceId, false, Const.Form.OpenType.NEW, "self", request.getUrlMap());
            }
        }
        try {
            patternId = formSession.getPatternId();
            Const.Data.Modify modify = formSession.getFormInstance().getModify();
            formSession.saveFormInstance(user, formInstanceData);
            if (modify.equals((Object)Const.Data.Modify.NEW)) {
                IFormSessionBo_M refreshFormSession = formSessionServices.createRefreshSession("self", patternId);
                FormInstanceBo formInstance = new FormInstanceBo();
                formInstance.setModify(Const.Data.Modify.SAVED);
                refreshFormSession.setFormInstance(formInstance);
                ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
                mobileForms.add(refreshFormSession);
                response.setMobileForms(mobileForms);
            }
            saveSucess = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            saveSucess = false;
        }
        return saveSucess;
    }

    public static void saveInstances(String formSessionId, Map<Integer, FormCellInstanceBo> formInstanceData) throws Exception {
        MobileResponseBo response = AppConfig.getMobileResponse();
        if (ServerMethod.saveInstancesOnly(formSessionId, formInstanceData)) {
            response.setMsg("\u4fdd\u5b58\u6210\u529f\uff01");
        } else {
            response.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    public static void saveInstances(int closePageNum, String formSessionId, Map<Integer, FormCellInstanceBo> formInstanceData) throws Exception {
        MobileResponseBo response = AppConfig.getMobileResponse();
        if (ServerMethod.saveInstancesOnly(formSessionId, formInstanceData)) {
            response.setMsg("\u4fdd\u5b58\u6210\u529f\uff01");
            response.setColsePageNum(closePageNum);
        } else {
            response.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    public static void submitFlowInstances(String formSessionId, Map<Integer, FormCellInstanceBo> formInstanceData) throws Exception {
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        MobileRequestBo request = AppConfig.getMobileRequest();
        MobileResponseBo response = AppConfig.getMobileResponse();
        IUserBo user = request.getMobileUser();
        IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
        if (formSession == null) {
            throw new Exception("\u65e0\u6cd5\u4ecesession\u4e2d\u83b7\u53d6\u79fb\u52a8\u8868\u5355\u4f1a\u8bdd\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u662f\u5426\u5f00\u542fsession");
        }
        try {
            formSession.saveFormInstance(user, formInstanceData);
            FlowInstance flowInstance = formSession.getFlowInstance();
            int nodeInstanceId = 0;
            String flowInstanceId = "";
            FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(formSession.getFormInstance().getFlowNodeInstanceId());
            flowInstanceId = flowInstance.getId();
            nodeInstanceId = nodeInstance.getNodeInstanceId();
            Object oj = FlowInstance.submit((String)flowInstanceId, (int)nodeInstanceId, null, (boolean)false);
            if (oj.getClass().getName().equalsIgnoreCase("java.lang.Boolean")) {
                if (oj.equals(true)) {
                    formSession.close(user);
                    response.setMsg("\u63d0\u4ea4\u6210\u529f\uff01");
                    response.setColsePageNum(1);
                } else {
                    response.setMsg("\u63d0\u4ea4\u5931\u8d25\uff01");
                }
            } else if (oj.getClass().getName().equalsIgnoreCase("java.util.ArrayList")) {
                Flow flow = Flow.getFlow((String)formSession.getFlowInstance().getFlowId());
                int flowNodeId = nodeInstance.getFlowNodeId();
                FlowNode flowNode = flow.getNodeById(flowNodeId);
                int embranch = flowNode.getEmbranch();
                HashMap<String, String> urlParamsMap = new HashMap<String, String>();
                urlParamsMap.put("EMBRANCH", String.valueOf(embranch));
                urlParamsMap.put("FORMSESSIONID", formSessionId);
                request.addUrlMap(urlParamsMap);
                TreeNodes selectUserNodes = new TreeNodes();
                ArrayList<TreeNodeBo> nodes = new ArrayList<TreeNodeBo>();
                for (TreeNodeBean nodeBean : (ArrayList)oj) {
                    nodes.add(TreeNodeBo.ToTreeNodeBo(nodeBean));
                }
                selectUserNodes.setTreeNodes(nodes);
                IFormSessionBo_M selectUser = formSessionServices.create(user, "E5DC4CC0-4157-4F71-BBC9-0DEC0A7FFA2D", null, false, Const.Form.OpenType.DAILOG, "self", urlParamsMap);
                selectUser.setFormCellPatternData(0, selectUserNodes);
                ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
                mobileForms.add(selectUser);
                response.setMobileForms(mobileForms);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMsg("\u6d41\u7a0b\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }

    public static void submitFlowInstancesWithNodes(Map<String, String> urlParamsMap, String nodesStr) throws Exception {
        String formSessionId = urlParamsMap.get("FORMSESSIONID");
        if (!HussarString.isEmpty(formSessionId)) {
            Object oj;
            IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
            MobileRequestBo request = AppConfig.getMobileRequest();
            MobileResponseBo response = AppConfig.getMobileResponse();
            IUserBo user = request.getMobileUser();
            IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
            if (formSession == null) {
                throw new Exception("\u65e0\u6cd5\u4ecesession\u4e2d\u83b7\u53d6\u79fb\u52a8\u8868\u5355\u4f1a\u8bdd\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u662f\u5426\u5f00\u542fsession");
            }
            FlowInstance flowInstance = formSession.getFlowInstance();
            int nodeInstanceId = 0;
            String flowInstanceId = "";
            FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(formSession.getFormInstance().getFlowNodeInstanceId());
            flowInstanceId = flowInstance.getId();
            nodeInstanceId = nodeInstance.getNodeInstanceId();
            if (HussarString.isEmpty(nodesStr)) {
                oj = FlowInstance.submit((String)flowInstanceId, (int)nodeInstanceId, null, (boolean)false);
            } else {
                HashMap<String, String[]> nodes = new HashMap<String, String[]>();
                String[] MapInfo = nodesStr.split("@");
                int i = 0;
                while (i < MapInfo.length) {
                    String[] nodeInfo = MapInfo[i].split(":");
                    String nodeId = nodeInfo[0];
                    if (nodeInfo.length == 1) {
                        nodes.put(nodeId, null);
                    } else {
                        String[] users = nodeInfo[1].split(",");
                        nodes.put(nodeId, users);
                    }
                    ++i;
                }
                oj = FlowInstance.submit((String)flowInstanceId, (int)nodeInstanceId, nodes, (boolean)false);
            }
            if (oj.getClass().getName().equalsIgnoreCase("java.lang.Boolean")) {
                if (oj.equals(true)) {
                    formSession.close(user);
                    response.setMsg("\u63d0\u4ea4\u6210\u529f\uff01");
                    response.setColsePageNum(2);
                } else {
                    response.setMsg("\u63d0\u4ea4\u5931\u8d25\uff01");
                }
            }
        }
    }

    public static void getUntreadReasonPage(String formSessionId) throws Exception {
        if (!HussarString.isEmpty(formSessionId)) {
            IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
            MobileRequestBo request = AppConfig.getMobileRequest();
            MobileResponseBo response = AppConfig.getMobileResponse();
            IUserBo user = request.getMobileUser();
            HashMap<String, String> urlParamsMap = new HashMap<String, String>();
            urlParamsMap.put("FORMSESSIONID", formSessionId);
            request.addUrlMap(urlParamsMap);
            IFormSessionBo_M reasonPage = formSessionServices.create(user, "BA755355-D2AC-44C2-B2B3-311DEF9CB399", null, false, Const.Form.OpenType.DAILOG, "self", urlParamsMap);
            ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
            mobileForms.add(reasonPage);
            response.setMobileForms(mobileForms);
        }
    }

    public static void untreadFlowInstances(Map<String, String> urlParamsMap) throws Exception {
        String formSessionId = urlParamsMap.get("FORMSESSIONID");
        String reason = urlParamsMap.get("REASON");
        if (!HussarString.isEmpty(formSessionId)) {
            IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
            MobileRequestBo request = AppConfig.getMobileRequest();
            MobileResponseBo response = AppConfig.getMobileResponse();
            IUserBo user = request.getMobileUser();
            IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
            if (formSession == null) {
                throw new Exception("\u65e0\u6cd5\u4ecesession\u4e2d\u83b7\u53d6\u79fb\u52a8\u8868\u5355\u4f1a\u8bdd\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u662f\u5426\u5f00\u542fsession");
            }
            FlowInstance flowInstance = formSession.getFlowInstance();
            int nodeInstanceId = 0;
            String flowInstanceId = "";
            FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(formSession.getFormInstance().getFlowNodeInstanceId());
            flowInstanceId = flowInstance.getId();
            nodeInstanceId = nodeInstance.getNodeInstanceId();
            flowInstance.exec(nodeInstanceId);
            flowInstance.save();
            Object oj = FlowInstance.untread((String)flowInstanceId, (int)nodeInstanceId, null, (String)reason);
            if (oj.getClass().getName().equalsIgnoreCase("java.lang.Boolean")) {
                if (oj.equals(true)) {
                    formSession.close(user);
                    response.setMsg("\u9000\u56de\u6210\u529f\uff01");
                    response.setColsePageNum(2);
                } else {
                    response.setMsg("\u9000\u56de\u5931\u8d25\uff01");
                }
            } else if (oj.getClass().getName().equalsIgnoreCase("java.util.ArrayList")) {
                Flow flow = Flow.getFlow((String)formSession.getFlowInstance().getFlowId());
                int flowNodeId = nodeInstance.getFlowNodeId();
                FlowNode flowNode = flow.getNodeById(flowNodeId);
                HashMap urlParamsMapNew = new HashMap();
                urlParamsMap.put("FORMSESSIONID", formSessionId);
                urlParamsMap.put("REASON", reason);
                request.addUrlMap(urlParamsMap);
                TreeNodes selectUserNodes = new TreeNodes();
                ArrayList<TreeNodeBo> nodes = new ArrayList<TreeNodeBo>();
                for (TreeNodeBean nodeBean : (ArrayList)oj) {
                    nodes.add(TreeNodeBo.ToTreeNodeBo(nodeBean));
                }
                selectUserNodes.setTreeNodes(nodes);
                IFormSessionBo_M selectUser = formSessionServices.create(user, "1BEE186D-C354-4A1E-9DF5-8A3C3AFE9D89", null, false, Const.Form.OpenType.DAILOG, "self", urlParamsMap);
                selectUser.setFormCellPatternData(0, selectUserNodes);
                ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
                mobileForms.add(selectUser);
                response.setMobileForms(mobileForms);
                response.setColsePageNum(1);
            }
        }
    }

    public static void untreadFlowInstancesWithNodes(Map<String, String> urlParamsMap, String nodesStr) throws Exception {
        String formSessionId = urlParamsMap.get("FORMSESSIONID");
        String reason = urlParamsMap.get("REASON");
        if (!HussarString.isEmpty(formSessionId)) {
            Object oj;
            IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
            MobileRequestBo request = AppConfig.getMobileRequest();
            MobileResponseBo response = AppConfig.getMobileResponse();
            IUserBo user = request.getMobileUser();
            IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
            if (formSession == null) {
                throw new Exception("\u65e0\u6cd5\u4ecesession\u4e2d\u83b7\u53d6\u79fb\u52a8\u8868\u5355\u4f1a\u8bdd\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u662f\u5426\u5f00\u542fsession");
            }
            FlowInstance flowInstance = formSession.getFlowInstance();
            int nodeInstanceId = 0;
            String flowInstanceId = "";
            FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(formSession.getFormInstance().getFlowNodeInstanceId());
            flowInstanceId = flowInstance.getId();
            nodeInstanceId = nodeInstance.getNodeInstanceId();
            if (HussarString.isEmpty(nodesStr)) {
                oj = FlowInstance.submit((String)flowInstanceId, (int)nodeInstanceId, null, (boolean)false);
            } else {
                HashMap<String, String[]> nodes = new HashMap<String, String[]>();
                String[] MapInfo = nodesStr.split("@");
                int i = 0;
                while (i < MapInfo.length) {
                    String[] nodeInfo = MapInfo[i].split(":");
                    String nodeId = nodeInfo[0];
                    if (nodeInfo.length == 1) {
                        nodes.put(nodeId, null);
                    } else {
                        String[] users = nodeInfo[1].split(",");
                        nodes.put(nodeId, users);
                    }
                    ++i;
                }
                oj = FlowInstance.untread((String)flowInstanceId, (int)nodeInstanceId, nodes, (String)reason);
            }
            if (oj.getClass().getName().equalsIgnoreCase("java.lang.Boolean")) {
                if (oj.equals(true)) {
                    formSession.close(user);
                    response.setMsg("\u9000\u56de\u6210\u529f\uff01");
                    response.setColsePageNum(2);
                } else {
                    response.setMsg("\u9000\u56de\u5931\u8d25\uff01");
                }
            }
        }
    }

    public static void showUntreadReason(String formSessionId) throws Exception {
        if (!HussarString.isEmpty(formSessionId)) {
            IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
            MobileResponseBo response = AppConfig.getMobileResponse();
            IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
            if (formSession == null) {
                throw new Exception("\u65e0\u6cd5\u4ecesession\u4e2d\u83b7\u53d6\u79fb\u52a8\u8868\u5355\u4f1a\u8bdd\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u662f\u5426\u5f00\u542fsession");
            }
            FlowInstance flowInstance = formSession.getFlowInstance();
            FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(formSession.getFormInstance().getFlowNodeInstanceId());
            Map reasons = FlowInstance.getUntreadReason((String)flowInstance.getId(), (String)String.valueOf(nodeInstance.getNodeInstanceId()));
            if (reasons.size() > 0) {
                StringBuffer reason = new StringBuffer();
                reason.append("\u9000\u56de\u539f\u56e0\uff1a").append((String)reasons.get("reason")).append("\n");
                reason.append("\u9000\u56de\u4eba\uff1a").append((String)reasons.get("createUser")).append("\n");
                reason.append("\u9000\u56de\u65f6\u95f4\uff1a").append((String)reasons.get("createDate")).append("\n");
                response.setMsg(reason.toString());
            } else {
                response.setMsg("\u6ca1\u6709\u9000\u56de\u539f\u56e0\uff01");
            }
        }
    }

    public static void callbackFlowInstances(String formSessionId) throws Exception {
        if (!HussarString.isEmpty(formSessionId)) {
            IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
            MobileRequestBo request = AppConfig.getMobileRequest();
            MobileResponseBo response = AppConfig.getMobileResponse();
            IUserBo user = request.getMobileUser();
            IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
            if (formSession == null) {
                throw new Exception("\u65e0\u6cd5\u4ecesession\u4e2d\u83b7\u53d6\u79fb\u52a8\u8868\u5355\u4f1a\u8bdd\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u662f\u5426\u5f00\u542fsession");
            }
            FlowInstance flowInstance = formSession.getFlowInstance();
            int nodeInstanceId = 0;
            String flowInstanceId = "";
            FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(formSession.getFormInstance().getFlowNodeInstanceId());
            flowInstanceId = flowInstance.getId();
            nodeInstanceId = nodeInstance.getNodeInstanceId();
            try {
                if (FlowInstance.callbackFromCurrent((String)flowInstanceId, (int)nodeInstanceId)) {
                    formSession.close(user);
                    response.setMsg("\u64a4\u56de\u6210\u529f\uff01");
                    response.setColsePageNum(2);
                } else {
                    response.setMsg("\u64a4\u56de\u5931\u8d25\uff01");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                response.setMsg(e.getMessage());
            }
        }
    }

    public static void deleteListData(String formPatternId, int listId, int pageIndex, String tempFilter, String listStyleId, String pkIds) throws Exception {
        MobileResponseBo response = AppConfig.getMobileResponse();
        MobileRequestBo request = AppConfig.getMobileRequest();
        if (!HussarString.isEmpty(listStyleId)) {
            IUserBo user = request.getMobileUser();
            CellProjectList listStyle = (CellProjectList)CellAttributeServices.getFormCellAttribute(listStyleId);
            if (!HussarString.isEmpty(listStyle.getTableId()) && !HussarString.isEmpty(listStyle.getTableName())) {
                IEntityPatternBo entityPattern = Factory.getService(Const.LAYER.CORE, IEntityService.class).load(listStyle.getTableId());
                IPlatEntityPatternBo platEntityPattern = Factory.getService(Const.LAYER.CORE, IPlatEntityservice.class).loadByCode(listStyle.getTableName());
                if (pkIds.indexOf(",") > 0) {
                    String[] ids;
                    String[] stringArray = ids = pkIds.split(",");
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        entityPattern.deleteInstance(user, id);
                        platEntityPattern.deleteInstance(user, id);
                        ++n2;
                    }
                } else {
                    entityPattern.deleteInstance(user, pkIds);
                    platEntityPattern.deleteInstance(user, pkIds);
                }
            }
            ServerMethod.getListData(formPatternId, listId, listStyleId, pageIndex, tempFilter);
            response.setMsg("\u5220\u9664\u6210\u529f\uff01");
        } else {
            response.setMsg("\u5220\u9664\u5931\u8d25,\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5217\u8868\u663e\u793a\u65b9\u6848\uff01");
        }
    }

    public static void showFlowDiary(String formSessionId) throws Exception {
        MobileResponseBo response = AppConfig.getMobileResponse();
        if (!HussarString.isEmpty(formSessionId)) {
            IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
            IFormSessionBo_M formSession = formSessionServices.load(formSessionId);
            if (formSession != null) {
                String instanceId = null;
                FlowInstance flowInstance = formSession.getFlowInstance();
                instanceId = flowInstance != null ? flowInstance.getId() : formSession.getFormInstance().getPlatEntityInstance().getIndex().get("FLOWOBJECTID");
                if (instanceId != null) {
                    ServerMethod.getMobilePage("0", "self", "29ADC526-39BE-4F9A-BB9E-DFAAB905072E", false, 0, null, instanceId);
                    ListData list = (ListData)response.getMobileForms().get(0).getFormPatternData().get(7);
                    if (list != null) {
                        List datas = list.getList();
                        IWorkFlowServices_M workFlowServices = Factory.getService(Const.LAYER.MOBILE, IWorkFlowServices_M.class);
                        String flowId = null;
                        String flowNodeId = null;
                        String runStatus = null;
                        String nodeType = null;
                        String pic = null;
                        for (ListMap data : datas) {
                            FlowOperatorManager manager;
                            FlowInstance flowInstance1;
                            FlowNodeInstance nodeInstance;
                            int nodeInstanceId;
                            String flowInstanceId = (String)data.get((Object)"FLOWINSTANCEID");
                            String operatorEndNames = FlowInstance.getOperatorEndNameString((String)flowInstanceId, (int)(nodeInstanceId = Integer.parseInt((String)data.get((Object)"NODEINSTANCEID"))));
                            if (StringTool.isEmpty((String)operatorEndNames) && (nodeInstance = (flowInstance1 = FlowInstance.load((String)flowInstanceId)).getFlowNodeInstance(nodeInstanceId)) != null && (manager = nodeInstance.getOperatorManager()) != null) {
                                operatorEndNames = manager.getReceiversNameString();
                            }
                            data.put((Object)"OPENERID", (Object)operatorEndNames);
                            flowId = (String)data.get((Object)"FLOWID");
                            flowNodeId = (String)data.get((Object)"FLOWNODEID");
                            runStatus = (String)data.get((Object)"RUNSTATUS");
                            nodeType = workFlowServices.getNodeType(flowId, flowNodeId);
                            pic = "4".equals(nodeType) ? ("0".equals(runStatus) ? "nowstart.9.png" : "flowstart.9.png") : ("3".equals(nodeType) ? "flowend.9.png" : ("0".equals(runStatus) ? "curnode.9.png" : "oldnode.9.png"));
                            data.put((Object)"STATUSNAME", (Object)pic);
                        }
                    }
                } else {
                    response.setMsg("\u6ca1\u6709\u5bf9\u5e94\u6d41\u7a0b\u65e5\u5fd7\uff01");
                }
            } else {
                response.setMsg("\u6ca1\u6709\u5bf9\u5e94\u6d41\u7a0b\u65e5\u5fd7\uff01");
            }
        } else {
            response.setMsg("\u6ca1\u6709\u5bf9\u5e94\u6d41\u7a0b\u65e5\u5fd7\uff01");
        }
    }

    public static void listOnclick(String openType, String target, Map<String, String> patternIdAndFilter, boolean isReadOnly, int closePageNum, Map<String, String> urlParamsMap, String formInstanceId, String listStyleId) throws Exception {
        if (urlParamsMap != null && urlParamsMap.get("_pkid") != null) {
            formInstanceId = urlParamsMap.get("_pkid");
        } else if (urlParamsMap == null) {
            urlParamsMap = new HashMap<String, String>();
            urlParamsMap.put("_pkid", formInstanceId);
        } else {
            urlParamsMap.put("_pkid", formInstanceId);
        }
        MobileResponseBo response = AppConfig.getMobileResponse();
        if (!HussarString.isEmpty(listStyleId)) {
            String patternId = null;
            CellProjectList listStyle = (CellProjectList)CellAttributeServices.getFormCellAttribute(listStyleId);
            patternId = listStyle.getPatternIdByFilterMap(patternIdAndFilter, formInstanceId);
            if (!HussarString.isEmpty(patternId)) {
                ServerMethod.getMobilePage(openType, target, patternId, isReadOnly, closePageNum, urlParamsMap, formInstanceId);
            } else {
                response.setMsg("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8868\u5355\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u8868\u5355\u8df3\u8f6c\u6761\u4ef6\uff01");
            }
        } else {
            response.setMsg("\u5217\u8868\u7684\u663e\u793a\u65b9\u6848\u7ef4\u62a4\u6709\u95ee\u9898\uff01");
        }
    }

    public static void listOnclick(String openType, String target, Map<String, String> patternIdAndFilter, int closePageNum, Map<String, String> urlParamsMap, String formInstanceId, String listStyleId) throws Exception {
        if (urlParamsMap != null && urlParamsMap.get("_pkid") != null) {
            formInstanceId = urlParamsMap.get("_pkid");
        } else if (urlParamsMap == null) {
            urlParamsMap = new HashMap<String, String>();
            urlParamsMap.put("_pkid", formInstanceId);
        } else {
            urlParamsMap.put("_pkid", formInstanceId);
        }
        MobileResponseBo response = AppConfig.getMobileResponse();
        if (!HussarString.isEmpty(listStyleId)) {
            String patternId = null;
            CellProjectList listStyle = (CellProjectList)CellAttributeServices.getFormCellAttribute(listStyleId);
            patternId = listStyle.getPatternIdByFilterMap(patternIdAndFilter, formInstanceId);
            if (!HussarString.isEmpty(patternId)) {
                ServerMethod.getMobilePage(openType, target, patternId, closePageNum, urlParamsMap, formInstanceId);
            } else {
                response.setMsg("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8868\u5355\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u8868\u5355\u8df3\u8f6c\u6761\u4ef6\uff01");
            }
        } else {
            response.setMsg("\u5217\u8868\u7684\u663e\u793a\u65b9\u6848\u7ef4\u62a4\u6709\u95ee\u9898\uff01");
        }
    }

    public static void waitDoListOnclick(String openType, String target, Map<String, String> patternIdAndFilter, int closePageNum, Map<String, String> urlParamsMap, String waitDoId, String listStyleId) throws Exception {
        MobileResponseBo response = AppConfig.getMobileResponse();
        if (!HussarString.isEmpty(listStyleId)) {
            String patternId = null;
            String formInstanceId = null;
            CellProjectList listStyle = (CellProjectList)CellAttributeServices.getFormCellAttribute(listStyleId);
            Map<String, String> waitDoInfo = listStyle.getWaitDoPatternIdByFilterMap(patternIdAndFilter, waitDoId);
            if (waitDoInfo != null) {
                patternId = waitDoInfo.get("patternId");
                formInstanceId = waitDoInfo.get("formInstanceId");
            }
            if (!HussarString.isEmpty(patternId)) {
                if (urlParamsMap != null && urlParamsMap.get("_pkid") != null) {
                    formInstanceId = urlParamsMap.get("_pkid");
                } else if (urlParamsMap == null) {
                    urlParamsMap = new HashMap<String, String>();
                    urlParamsMap.put("_pkid", formInstanceId);
                } else {
                    urlParamsMap.put("_pkid", formInstanceId);
                }
                ServerMethod.getMobilePage(openType, target, patternId, closePageNum, urlParamsMap, formInstanceId);
            } else {
                response.setMsg("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8868\u5355\uff0c\u8bf7\u68c0\u67e5\u5f85\u529e\u5217\u8868\u8868\u5355\u8df3\u8f6c\u6761\u4ef6\uff01");
            }
        } else {
            response.setMsg("\u5f85\u529e\u5217\u8868\u7684\u663e\u793a\u65b9\u6848\u7ef4\u62a4\u6709\u95ee\u9898\uff01");
        }
    }

    public static void getcellData() {
    }

    public static void getChildTreeNode(String formPatternId, int treeId, String appId, String tableId, String linkId, String sheetId, String isGroup, String gId, String parentNodeGuid) throws Exception {
        MobileResponseBo response = AppConfig.getMobileResponse();
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        HashMap<Integer, HussarJsonObject> formPatternData = null;
        if (!HussarString.isEmpty(appId)) {
            formPatternData = new HashMap<Integer, HussarJsonObject>();
            CellProjectTree treeApp = (CellProjectTree)CellAttributeServices.getFormCellAttribute(appId);
            TreeNodes treeNodes = new TreeNodes();
            ArrayList<TreeNodeBo> childNodes = treeApp.getChildNodeArray(tableId, linkId, sheetId, isGroup, gId, parentNodeGuid);
            treeNodes.setTreeNodes(childNodes);
            formPatternData.put(treeId, treeNodes);
        }
        IFormSessionBo_M formSession = formSessionServices.createRefreshSession("self", formPatternId, formPatternData, null, null);
        ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
        mobileForms.add(formSession);
        response.setMobileForms(mobileForms);
    }

    @Deprecated
    public static void getListData(String formPatternId, int listId, String listStyleId, int pageIndex, String tempFilter) throws Exception {
        ServerMethod.getListData(formPatternId, listId, listStyleId, pageIndex, tempFilter, null);
    }

    public static void getListData(String formPatternId, int listId, String listStyleId, int pageIndex, String tempFilter, String tempOrder) throws Exception {
        ServerMethod.getListData(formPatternId, listId, pageIndex, tempFilter, tempOrder, "self");
    }

    public static void getListData(String formPatternId, int listId, int pageIndex, String tempFilter, String target) throws Exception {
        ServerMethod.getListData(formPatternId, listId, pageIndex, tempFilter, null, target);
    }

    public static void getListData(String formPatternId, int listId, int pageIndex, String tempFilter, String tempOrder, String target) throws Exception {
        CellProjectList listStyle;
        IFormPatternBo formPatternServices;
        IFormPatternBo formPattern;
        IFormCellBo cell;
        MobileResponseBo response = AppConfig.getMobileResponse();
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        HashMap<Integer, HussarJsonObject> formPatternData = null;
        if (!HussarString.isEmpty(formPatternId) && (cell = (formPattern = (formPatternServices = Factory.getService(Const.LAYER.MOBILE, IFormPatternBo.class)).load(formPatternId)).getCellById(listId)) instanceof FormCellList && (listStyle = ((FormCellList)cell).getProjectList()) != null) {
            formPatternData = new HashMap<Integer, HussarJsonObject>();
            HussarJsonObject listData = listStyle.getPatternCellData(listStyle.isAllowPage(), pageIndex, listStyle.getPageDataSize(), tempFilter, tempOrder);
            formPatternData.put(listId, listData);
        }
        IFormSessionBo_M formSession = formSessionServices.createRefreshSession(target, formPatternId, formPatternData, null, null);
        ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
        mobileForms.add(formSession);
        response.setMobileForms(mobileForms);
    }

    @Deprecated
    public static void getComboBoxData(String formPatternId, int comboboxId, String tempFilter, String styleId) throws Exception {
        ServerMethod.getComboBoxData(formPatternId, comboboxId, tempFilter);
    }

    public static void getComboBoxData(String formPatternId, int comboboxId, String tempFilter) throws Exception {
        IFormPatternBo formPatternServices;
        IFormPatternBo formPattern;
        IFormCellBo cell;
        MobileResponseBo response = AppConfig.getMobileResponse();
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        HashMap<Integer, HussarJsonObject> formPatternData = null;
        if (!HussarString.isEmpty(formPatternId) && (cell = (formPattern = (formPatternServices = Factory.getService(Const.LAYER.MOBILE, IFormPatternBo.class)).load(formPatternId)).getCellById(comboboxId)) instanceof FormCellComplexComboBox) {
            formPatternData = new HashMap<Integer, HussarJsonObject>();
            CellProjectComboBox cellProjectComboBox = ((FormCellComplexComboBox)cell).getCellProjectComboBox();
            HussarJsonObject options = cellProjectComboBox.getPatternCellData(tempFilter);
            formPatternData.put(comboboxId, options);
        }
        IFormSessionBo_M formSession = formSessionServices.createRefreshSession("self", formPatternId, formPatternData, null, null);
        ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
        mobileForms.add(formSession);
        response.setMobileForms(mobileForms);
    }

    @Deprecated
    public static void queryListData(String formPatternId, int listId, String listStyleId, String tempFilter) throws Exception {
        ServerMethod.getListData(formPatternId, listId, listStyleId, 1, tempFilter);
    }

    public static void queryListDataWithTarget(String formPatternId, int listId, String tempFilter, String target) throws Exception {
        ServerMethod.getListData(formPatternId, listId, 1, tempFilter, target);
    }

    public static String saveFile() {
        String bSuccess;
        block14: {
            PatternDao dao = (PatternDao)BeanFactory.getClass((String)"PatternDao");
            Context context = Global.getContext();
            String fileId = "";
            bSuccess = "false";
            String path = "";
            String userId = "";
            StringBuffer successInfo = new StringBuffer();
            try {
                int Threshold;
                DiskFileUpload fu = new DiskFileUpload();
                int maxSize = 100;
                String config = Global.getConfig((String)"upload.sizeMax");
                if (!HussarString.isEmpty(config)) {
                    if (config.endsWith("M")) {
                        config = config.substring(0, config.length() - 1);
                    }
                    maxSize = Integer.parseInt(config);
                }
                fu.setSizeMax((long)(maxSize * 1024 * 1024));
                String Thresholdconfig = Global.getConfig((String)"upload.sizeThreadshold");
                if (Thresholdconfig.endsWith("M")) {
                    Thresholdconfig = Thresholdconfig.substring(0, Thresholdconfig.length() - 1);
                    Threshold = Integer.parseInt(Thresholdconfig);
                    Threshold = Threshold * 1024 * 1024;
                } else if (Thresholdconfig.endsWith("k") || Thresholdconfig.endsWith("K")) {
                    Thresholdconfig = Thresholdconfig.substring(0, Thresholdconfig.length() - 1);
                    Threshold = Integer.parseInt(Thresholdconfig);
                    Threshold *= 1024;
                } else {
                    Threshold = 4196;
                }
                fu.setSizeThreshold(Threshold);
                fu.setHeaderEncoding("utf-8");
                fu.setRepositoryPath(Global.getConfig((String)"upload.catchPath"));
                String repositoryPath = Global.getConfig((String)"upload.catchPath");
                File file = (File)BeanFactory.getClass((String)"File", (Object[])new String[]{repositoryPath});
                if (!(file.exists() || file.mkdir() || (file = (File)BeanFactory.getClass((String)"File", (Object[])new String[]{repositoryPath = System.getProperty("java.io.tmpdir")})).exists())) {
                    throw new Exception("\u4e34\u65f6\u76ee\u5f55\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
                }
                fu.setRepositoryPath(repositoryPath);
                List fileItems = context.getDiskFileUploadFile(fu);
                for (FileItem fi : fileItems) {
                    String name;
                    if (fi.isFormField()) continue;
                    String fileName = fi.getFieldName();
                    String[] fileInfo = fileName.split("@");
                    fileId = fileInfo[0];
                    userId = fileInfo[1];
                    if (fileInfo.length > 2 && (HussarString.isEmpty(path = fileInfo[2]) || "null".equals(path))) {
                        path = "";
                    }
                    if ((name = fi.getName()).length() == 0) continue;
                    if (name.lastIndexOf(".") == -1) {
                        throw new Exception("\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u660e\u786e\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01");
                    }
                    String fileType = name.substring(name.lastIndexOf(".") + 1, name.length());
                    String deleteSql = " delete from  JXD7_PM_FILE WHERE ID='" + fileId + "'";
                    DbOper.executeNonQuery((String)deleteSql);
                    if (dao.saveCommonsFile(fileId, "", userId, fi, "", path)) {
                        successInfo.append(String.valueOf(fileName) + "@" + fileId + "@");
                        bSuccess = "true";
                        continue;
                    }
                    successInfo.append(String.valueOf(fileName) + "@" + "@");
                    bSuccess = "false";
                }
            }
            catch (Exception e) {
                String expMsg = e.getMessage();
                bSuccess = "false";
                System.out.println("\u4e0a\u4f20\u5143\u4ef6\u51fa\u9519:" + expMsg);
                if (expMsg.indexOf("size exceeds") != -1) {
                    expMsg = "\u4e0a\u4f20\u7684\u6587\u4ef6\u957f\u5ea6\u8d85\u51fa\u9650\u5236\u3002";
                }
                if (expMsg.indexOf("extension of the file") == -1) break block14;
                expMsg = "\u6240\u9009\u62e9\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e0a\u4f20\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01";
            }
        }
        return bSuccess;
    }

    public static void downLoadData(String listStyleId, Map<String, String> urlParamsMap) {
        MobileResponseBo response = AppConfig.getMobileResponse();
        String keyValue = urlParamsMap.get("PKVALUE");
        if (HussarString.isEmpty(keyValue)) {
            response.setMsg("\u8bf7\u9009\u62e9\u8981\u4e0b\u8f7d\u7684\u6570\u636e\uff01");
            return;
        }
        keyValue = "'" + keyValue.replace(",", "','") + "'";
        ArrayList<DataSet> downloadDatas = new ArrayList<DataSet>();
        try {
            DataSet data = DataSyncServices.downLoadDataJson(listStyleId, keyValue);
            if (data != null) {
                downloadDatas.add(data);
            }
            if (downloadDatas.size() > 0) {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(downloadDatas);
                MobileMethod nextMethod = new MobileMethod();
                nextMethod.setType(Const.Action.ActionType.MOBILE);
                nextMethod.setMethodName("SAVEDOWNLOADDATA");
                nextMethod.setParams(params);
                response.setNextMethod(nextMethod);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
        }
    }

    public static void downLoadData(String tableName, String pkCol, Map<String, String> urlParamsMap) {
        MobileResponseBo response = AppConfig.getMobileResponse();
        String pkValue = urlParamsMap.get("PKVALUE");
        if (HussarString.isEmpty(pkValue)) {
            response.setMsg("\u8bf7\u9009\u62e9\u8981\u4e0b\u8f7d\u7684\u6570\u636e\uff01");
            return;
        }
        pkValue = "'" + pkValue.replace(",", "','") + "'";
        ArrayList<DataSet> downloadDatas = new ArrayList<DataSet>();
        try {
            DataSet data = DataSyncServices.downLoadDataJson("", tableName, pkCol, pkValue);
            if (data != null) {
                downloadDatas.add(data);
            }
            if (downloadDatas.size() > 0) {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(downloadDatas);
                MobileMethod nextMethod = new MobileMethod();
                nextMethod.setType(Const.Action.ActionType.MOBILE);
                nextMethod.setMethodName("SAVEDOWNLOADDATA");
                nextMethod.setParams(params);
                response.setNextMethod(nextMethod);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
        }
    }

    public static void updateDownLoadDataFlag(List<String> sheetids) {
    }

    public static void SaveUpLoadData(List<DataSet> datas, int listId) {
        MobileResponseBo response = AppConfig.getMobileResponse();
        if (DataSyncServices.uploadData(datas)) {
            HashMap ids = new HashMap();
            for (DataSet data : datas) {
                ArrayList<String> items = new ArrayList<String>();
                for (DataItem dataItem : data.getDatas()) {
                    items.add(dataItem.getAttrs().get(data.getKeys().get(0)));
                }
                if (items.size() > 0) {
                    ids.put(data.getTableName(), items);
                }
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(ids);
                params.add(String.valueOf(listId));
                MobileMethod nextMethod = new MobileMethod();
                nextMethod.setType(Const.Action.ActionType.MOBILE);
                nextMethod.setMethodName("DEALSUCCESSDATA");
                nextMethod.setParams(params);
                response.setNextMethod(nextMethod);
            }
        } else {
            response.setMsg("\u6570\u636e\u4e0a\u4f20\u5931\u8d25\uff01");
        }
    }

    public static void userSignByCode(String patternId, int signCellId, String userCode, String pwd) throws Exception {
        IFormPatternBo formPatternServices;
        IFormPatternBo formPattern;
        IFormCellBo cell;
        MobileResponseBo response = AppConfig.getMobileResponse();
        IFormSessionBo_M formSessionServices = Factory.getService(Const.LAYER.MOBILE, IFormSessionBo_M.class);
        HashMap<Integer, HussarJsonObject> formPatternData = null;
        if (!HussarString.isEmpty(patternId) && (cell = (formPattern = (formPatternServices = Factory.getService(Const.LAYER.MOBILE, IFormPatternBo.class)).load(patternId)).getCellById(signCellId)) instanceof FormCellSign) {
            formPatternData = new HashMap<Integer, HussarJsonObject>();
            HussarJsonObject userSignData = ((FormCellSign)cell).getUserInfoWithCheck(userCode, pwd);
            formPatternData.put(signCellId, userSignData);
        }
        IFormSessionBo_M formSession = formSessionServices.createRefreshSession("self", patternId, formPatternData, null, null);
        ArrayList<IFormSessionBo_M> mobileForms = new ArrayList<IFormSessionBo_M>(10);
        mobileForms.add(formSession);
        response.setMobileForms(mobileForms);
    }

    public static void getUserDefineMobilePage(String openType, String target, String patternId, boolean isReadOnly, int closePageNum, Map<String, String> urlParamsMap, String formInstanceId) throws Exception {
        ServerMethod.getMobilePage(openType, target, patternId, isReadOnly, closePageNum, urlParamsMap, formInstanceId);
        MobileResponseBo response = AppConfig.getMobileResponse();
        IFormSessionBo_M formSession = response.getMobileForms().get(0);
        IFormPatternBo pattern = formSession.getMobileFormPattern();
        FormCellPo textPo = new FormCellPo();
        textPo.setCellId(1);
        textPo.setName("\u6587\u672c");
        textPo.setByName("1");
        textPo.setCellType(10);
        textPo.setLimit(Const.Permit.Limit.EDIT);
        IFormCellBo cell1 = Factory.getFormCell(Const.LAYER.MOBILE, textPo.getCellType());
        if (cell1 != null) {
            cell1.init(pattern, textPo);
        }
        pattern.addCell(cell1);
        FormCellPo radioPo = new FormCellPo();
        radioPo.setCellId(2);
        radioPo.setByName("2");
        radioPo.setName("\u5355\u9009\u6309\u94ae");
        radioPo.setCellType(30);
        radioPo.setLimit(Const.Permit.Limit.EDIT);
        IFormCellBo radio = Factory.getFormCell(Const.LAYER.MOBILE, radioPo.getCellType());
        if (radio != null) {
            radio.init(pattern, radioPo);
        }
        pattern.addCell(radio);
        Options options = new Options();
        OptionBo option = new OptionBo();
        option.setText("\u7537");
        option.setValue("1");
        options.addOpts(option);
        formSession.setFormCellPatternData(2, options);
    }
}

