/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.form.services;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.form72.bo.IFormPatternBo;
import com.sdjxd.hussar.core.utils.FileTools;
import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.hussar.mobile.form.dao.MobilePatternDao;
import com.sdjxd.hussar.mobile.utils.GzipTool;
import com.sdjxd.pms.platform.base.Global;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class PatternFileServices_M {
    private static Logger log = Logger.getLogger(PatternFileServices_M.class);
    private static MobilePatternDao dao;

    static {
        try {
            dao = Factory.getDao(MobilePatternDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createMobilePatternFiles() {
        String path = String.valueOf(Global.getPath().replace("\\", "/")) + "resource/mobile_res/mobilepattern/";
        FileTools.delAllFile(path);
        boolean fileResult = true;
        try {
            String patternId;
            List<String> patternIds = dao.getAllMobilePatternId();
            if (patternIds == null) return fileResult;
            Iterator<String> iterator = patternIds.iterator();
            do {
                if (iterator.hasNext()) continue;
                return fileResult;
            } while (PatternFileServices_M.createMobilePatternFileById(patternId = iterator.next()));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            return false;
        }
    }

    private static boolean createMobilePatternFileById(String patternId) throws Exception {
        IFormPatternBo formPatternServices = Factory.getService(Const.LAYER.MOBILE, IFormPatternBo.class);
        IFormPatternBo formPattern = formPatternServices.loadFormDb(patternId);
        String patternJson = GzipTool.gzip(HussarJson.gson_toJson(formPattern));
        String patternFileName = FileTools.getFileAbsolutePath("/resource/mobile_res/mobilepattern/" + patternId + ".pattern");
        FileTools.writeResult(patternJson, patternFileName, "utf-8");
        return true;
    }
}

