/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.form.bo.cell;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.bo.HussarJsonObject;
import com.sdjxd.hussar.core.entity72.bo.support.entity.EntityInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormCellInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormInstanceBo;
import com.sdjxd.hussar.core.form72.bo.IFormPatternBo;
import com.sdjxd.hussar.core.form72.bo.cell.FormCellBo;
import com.sdjxd.hussar.core.form72.platEntity72.bo.support.PlatEntityInstanceBo;
import com.sdjxd.hussar.core.form72.po.FormCellEventPo;
import com.sdjxd.hussar.core.form72.po.FormCellPo;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.utils.FileTools;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.mobile.form.bo.cellData.chart.BarAndLineChart;
import com.sdjxd.hussar.mobile.form.bo.cellData.chart.BarChart;
import com.sdjxd.hussar.mobile.form.bo.cellData.chart.BaseChart;
import com.sdjxd.hussar.mobile.form.bo.cellData.chart.DashBoard;
import com.sdjxd.hussar.mobile.form.bo.cellData.chart.LineChart;
import com.sdjxd.hussar.mobile.form.bo.cellData.chart.PieChart;
import com.sdjxd.hussar.mobile.form.bo.cellData.chart.RadarChart;
import com.sdjxd.hussar.mobile.form.dao.MobileCellDao;
import com.sdjxd.hussar.mobile.form.po.ChartSrcPo;
import com.sdjxd.pms.platform.data.DbOper;
import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.RowSet;
import org.dom4j.Document;

public class ChartCell
extends FormCellBo {
    private static MobileCellDao mdao = null;
    private ChartSrcPo chartsrc;

    static {
        try {
            mdao = Factory.getDao(MobileCellDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init(IFormPatternBo formPattern, FormCellPo cellPo) throws Exception {
        this.tl_init(formPattern, cellPo);
        this.chartsrc = mdao.getChartSrcInfo(this.patternId, this.cellId);
    }

    @Override
    public void initEntityInstanceData(FormInstanceBo formInstance, EntityInstanceBo entityInstance) throws Exception {
    }

    @Override
    public void initFormInstanceData(PlatEntityInstanceBo platEntityInstance, EntityInstanceBo entityInstance, FormInstanceBo formInstance) throws Exception {
    }

    @Override
    public boolean hasCellData() {
        return this.chartsrc != null;
    }

    @Override
    public HussarJsonObject getCellData(String tempfilter) throws Exception {
        BaseChart chart = null;
        if (this.chartsrc != null) {
            if (this.chartsrc.getDatasourceType() == Const.Form.Cell.Chart.DataSourceType.XMLFILE) {
                if (!HussarString.isEmpty(this.chartsrc.getFileInfo())) {
                    String filePath = FileTools.getFileAbsolutePath(this.chartsrc.getFileInfo());
                    Document chartDoc = FileTools.readFile(filePath);
                    chart = this.initChartByDoc(chartDoc);
                }
            } else if (!HussarString.isEmpty(this.chartsrc.getPacl()) && !HussarString.isEmpty(this.chartsrc.getMethod())) {
                Class<?> cls = Class.forName(this.chartsrc.getPacl());
                Object obj = cls.newInstance();
                Method method = cls.getMethod(this.chartsrc.getMethod(), new Class[0]);
                method.setAccessible(true);
                Object o = method.invoke(obj, new Object[0]);
                chart = (BaseChart)method.invoke(obj, new Object[0]);
            }
        }
        return chart;
    }

    @Override
    public void modifyFormInstance(IUserBo user, FormInstanceBo formInstanceBo, FormCellInstanceBo cellData) {
    }

    @Override
    public void addEvent(FormCellEventPo eventPo) throws Exception {
    }

    @Override
    public void initPlatEntityInstanceData(FormInstanceBo formInstanceBo, PlatEntityInstanceBo platEntityInstanceBo) throws Exception {
    }

    private BaseChart initChartByDoc(Document chartDoc) {
        String chartType = chartDoc.selectSingleNode("/char/chartType").getText();
        if ("PIECHART".equals(chartType)) {
            PieChart p = new PieChart();
            p.setChartName(chartDoc.selectSingleNode("/char/chartName").getText());
            String chartNameValgin = chartDoc.selectSingleNode("/char/chartNameValgin").getText();
            p.setChartValgin(Const.Form.Cell.Chart.Valgin.valueOf(chartNameValgin));
            String colorStyle = chartDoc.selectSingleNode("/char/colorStyle").getText();
            p.setColorStyle(Const.Form.Cell.Chart.ColorStyle.valueOf(colorStyle));
            String radius = chartDoc.selectSingleNode("/char/radius").getText();
            if (!HussarString.isEmpty(radius)) {
                p.setRadius(Integer.parseInt(radius));
            }
            String titlesString = chartDoc.selectSingleNode("/char/titlesString").getText();
            String valuesString = chartDoc.selectSingleNode("/char/valuesString").getText();
            String dataSql = chartDoc.selectSingleNode("/char/datasource/sql").getText();
            if (!dataSql.equals("")) {
                String datasourceName = chartDoc.selectSingleNode("/char/datasource/name").getText();
                String valuesColumn = chartDoc.selectSingleNode("/char/datasource/valuesColumn").getText();
                String titlesColumn = chartDoc.selectSingleNode("/char/datasource/titlesColumn").getText();
                titlesString = "";
                valuesString = "";
                try {
                    RowSet rs = DbOper.executeQuery((String)datasourceName, (String)dataSql);
                    while (rs.next()) {
                        titlesString = String.valueOf(titlesString) + rs.getString(titlesColumn) + ",";
                        valuesString = String.valueOf(valuesString) + rs.getString(valuesColumn) + ",";
                    }
                    titlesString = titlesString.equals("") ? "" : titlesString.substring(0, titlesString.length() - 1);
                    valuesString = valuesString.equals("") ? "" : valuesString.substring(0, valuesString.length() - 1);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            p.setTitlesArray(titlesString);
            p.setValuesArray(valuesString);
            return p;
        }
        if ("BARCHART".equals(chartType)) {
            BarChart p = new BarChart();
            p.setChartName(chartDoc.selectSingleNode("/char/chartName").getText());
            String chartNameValgin = chartDoc.selectSingleNode("/char/chartNameValgin").getText();
            p.setChartValgin(Const.Form.Cell.Chart.Valgin.valueOf(chartNameValgin));
            String colorStyle = chartDoc.selectSingleNode("/char/colorStyle").getText();
            p.setColorStyle(Const.Form.Cell.Chart.ColorStyle.valueOf(colorStyle));
            p.setItemWidth(Integer.parseInt(chartDoc.selectSingleNode("/char/itemWidth").getText()));
            p.setShowLegend("true".equalsIgnoreCase(chartDoc.selectSingleNode("/char/showLegend").getText()));
            p.setX_TITLE(chartDoc.selectSingleNode("/char/xTitle").getText());
            p.setX_TITLE_STYLE(Integer.parseInt(chartDoc.selectSingleNode("/char/xTitleStyle").getText()));
            p.setY_LEFT_TITLE(chartDoc.selectSingleNode("/char/yLiftTitle").getText());
            p.setY_RIGHT_TITLE(chartDoc.selectSingleNode("/char/yRightTitle").getText());
            p.setLeftValuesArray(chartDoc.selectSingleNode("/char/leftValuesName").getText());
            p.setRightValuesArray(chartDoc.selectSingleNode("/char/rightValuesName").getText());
            String titlesString = chartDoc.selectSingleNode("/char/titlesString").getText();
            String leftValuesString = chartDoc.selectSingleNode("/char/leftValuesString").getText();
            String rightValuesString = chartDoc.selectSingleNode("/char/rightValuesString").getText();
            String datasourceName = chartDoc.selectSingleNode("/char/datasource/name").getText();
            String dataSql = chartDoc.selectSingleNode("/char/datasource/sql").getText();
            if (!"".equals(dataSql)) {
                String titlesColumn = chartDoc.selectSingleNode("/char/datasource/titlesColumn").getText();
                String leftValuesColumn = chartDoc.selectSingleNode("/char/datasource/leftValuesColumn").getText();
                String rightValuesColumn = chartDoc.selectSingleNode("/char/datasource/rightValuesColumn").getText();
                titlesString = "";
                leftValuesString = "";
                rightValuesString = "";
                try {
                    RowSet rs = DbOper.executeQuery((String)datasourceName, (String)dataSql);
                    while (rs.next()) {
                        titlesString = String.valueOf(titlesString) + rs.getString(titlesColumn) + ",";
                        if (!"".equals(leftValuesColumn)) {
                            leftValuesString = String.valueOf(leftValuesString) + rs.getString(leftValuesColumn) + ",";
                        }
                        if ("".equals(rightValuesColumn)) continue;
                        rightValuesString = String.valueOf(rightValuesString) + rs.getString(rightValuesColumn) + ",";
                    }
                    titlesString = titlesString.equals("") ? "" : titlesString.substring(0, titlesString.length() - 1);
                    leftValuesString = leftValuesString.equals("") ? "" : leftValuesString.substring(0, leftValuesString.length() - 1);
                    rightValuesString = rightValuesString.equals("") ? "" : rightValuesString.substring(0, rightValuesString.length() - 1);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            p.setTitlesArray(titlesString);
            p.setLeftValuesArray(leftValuesString);
            p.setRightValuesArray(rightValuesString);
            return p;
        }
        if ("LINECHART".equals(chartType)) {
            LineChart p = new LineChart();
            p.setChartName(chartDoc.selectSingleNode("/char/chartName").getText());
            String chartNameValgin = chartDoc.selectSingleNode("/char/chartNameValgin").getText();
            p.setChartValgin(Const.Form.Cell.Chart.Valgin.valueOf(chartNameValgin));
            String colorStyle = chartDoc.selectSingleNode("/char/colorStyle").getText();
            p.setColorStyle(Const.Form.Cell.Chart.ColorStyle.valueOf(colorStyle));
            p.setItemWidth(Integer.parseInt(chartDoc.selectSingleNode("/char/itemWidth").getText()));
            p.setShowLegend("true".equalsIgnoreCase(chartDoc.selectSingleNode("/char/showLegend").getText()));
            p.setX_TITLE(chartDoc.selectSingleNode("/char/xTitle").getText());
            p.setX_TITLE_STYLE(Integer.parseInt(chartDoc.selectSingleNode("/char/xTitleStyle").getText()));
            p.setY_LEFT_TITLE(chartDoc.selectSingleNode("/char/yLeftTitle").getText());
            p.setY_RIGHT_TITLE(chartDoc.selectSingleNode("/char/yRightTitle").getText());
            p.setLeftValuesArray(chartDoc.selectSingleNode("/char/leftValuesName").getText());
            p.setRightValuesArray(chartDoc.selectSingleNode("/char/rightValuesName").getText());
            String titlesString = chartDoc.selectSingleNode("/char/titlesString").getText();
            String leftValuesString = chartDoc.selectSingleNode("/char/leftValuesString").getText();
            String rightValuesString = chartDoc.selectSingleNode("/char/rightValuesString").getText();
            String datasourceName = chartDoc.selectSingleNode("/char/datasource/name").getText();
            String dataSql = chartDoc.selectSingleNode("/char/datasource/sql").getText();
            if (!"".equals(dataSql)) {
                String titlesColumn = chartDoc.selectSingleNode("/char/datasource/titlesColumn").getText();
                String leftValuesColumn = chartDoc.selectSingleNode("/char/datasource/leftValuesColumn").getText();
                String rightValuesColumn = chartDoc.selectSingleNode("/char/datasource/rightValuesColumn").getText();
                titlesString = "";
                leftValuesString = "";
                rightValuesString = "";
                try {
                    RowSet rs = DbOper.executeQuery((String)datasourceName, (String)dataSql);
                    while (rs.next()) {
                        titlesString = String.valueOf(titlesString) + rs.getString(titlesColumn) + ",";
                        if (!"".equals(leftValuesColumn)) {
                            leftValuesString = String.valueOf(leftValuesString) + rs.getString(leftValuesColumn) + ",";
                        }
                        if ("".equals(rightValuesColumn)) continue;
                        rightValuesString = String.valueOf(rightValuesString) + rs.getString(rightValuesColumn) + ",";
                    }
                    titlesString = titlesString.equals("") ? "" : titlesString.substring(0, titlesString.length() - 1);
                    leftValuesString = leftValuesString.equals("") ? "" : leftValuesString.substring(0, leftValuesString.length() - 1);
                    rightValuesString = rightValuesString.equals("") ? "" : rightValuesString.substring(0, rightValuesString.length() - 1);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            p.setTitlesArray(titlesString);
            p.setLeftValuesArray(leftValuesString);
            p.setRightValuesArray(rightValuesString);
            return p;
        }
        if ("BARANDLINECHART".equals(chartType)) {
            BarAndLineChart p = new BarAndLineChart();
            p.setChartName(chartDoc.selectSingleNode("/char/chartName").getText());
            String chartNameValgin = chartDoc.selectSingleNode("/char/chartNameValgin").getText();
            p.setChartValgin(Const.Form.Cell.Chart.Valgin.valueOf(chartNameValgin));
            String colorStyle = chartDoc.selectSingleNode("/char/colorStyle").getText();
            p.setColorStyle(Const.Form.Cell.Chart.ColorStyle.valueOf(colorStyle));
            p.setItemWidth(Integer.parseInt(chartDoc.selectSingleNode("/char/itemWidth").getText()));
            p.setShowLegend("true".equalsIgnoreCase(chartDoc.selectSingleNode("/char/showLegend").getText()));
            p.setX_TITLE(chartDoc.selectSingleNode("/char/xTitle").getText());
            p.setX_TITLE_STYLE(Integer.parseInt(chartDoc.selectSingleNode("/char/xTitleStyle").getText()));
            p.setY_LEFT_TITLE(chartDoc.selectSingleNode("/char/yLeftTitle").getText());
            p.setY_RIGHT_TITLE(chartDoc.selectSingleNode("/char/yRightTitle").getText());
            p.setBar_left_valuesName(chartDoc.selectSingleNode("/char/barLeftValuesName").getText());
            p.setBar_Right_valuesName(chartDoc.selectSingleNode("/char/barRightValuesName").getText());
            p.setLine_left_valuesName(chartDoc.selectSingleNode("/char/lineLeftValuesName").getText());
            p.setLine_Right_valuesName(chartDoc.selectSingleNode("/char/lineRightValuesName").getText());
            String titlesString = chartDoc.selectSingleNode("/char/titlesString").getText();
            String barLeftValuesString = chartDoc.selectSingleNode("/char/barLeftValuesString").getText();
            String barRightValuesString = chartDoc.selectSingleNode("/char/barRightValuesString").getText();
            String lineLeftValuesString = chartDoc.selectSingleNode("/char/lineLeftValuesString").getText();
            String lineRightValuesString = chartDoc.selectSingleNode("/char/lineRightValuesString").getText();
            String datasourceName = chartDoc.selectSingleNode("/char/datasource/name").getText();
            String dataSql = chartDoc.selectSingleNode("/char/datasource/sql").getText();
            if (!"".equals(dataSql)) {
                String titlesColumn = chartDoc.selectSingleNode("/char/datasource/titlesColumn").getText();
                String barLeftValuesColumn = chartDoc.selectSingleNode("/char/datasource/barLeftValuesColumn").getText();
                String barRightValuesColumn = chartDoc.selectSingleNode("/char/datasource/barRightValuesColumn").getText();
                String lineLeftValuesColumn = chartDoc.selectSingleNode("/char/datasource/lineLeftValuesColumn").getText();
                String lineRightValuesColumn = chartDoc.selectSingleNode("/char/datasource/lineRightValuesColumn").getText();
                titlesString = "";
                barLeftValuesString = "";
                barRightValuesString = "";
                lineLeftValuesString = "";
                lineRightValuesString = "";
                try {
                    RowSet rs = DbOper.executeQuery((String)datasourceName, (String)dataSql);
                    while (rs.next()) {
                        titlesString = String.valueOf(titlesString) + rs.getString(titlesColumn) + ",";
                        if (!"".equals(barLeftValuesColumn)) {
                            barLeftValuesString = String.valueOf(barLeftValuesString) + rs.getString(barLeftValuesColumn) + ",";
                        }
                        if (!"".equals(barRightValuesColumn)) {
                            barRightValuesString = String.valueOf(barRightValuesString) + rs.getString(barRightValuesColumn) + ",";
                        }
                        if (!"".equals(lineLeftValuesColumn)) {
                            lineLeftValuesString = String.valueOf(lineLeftValuesString) + rs.getString(lineLeftValuesColumn) + ",";
                        }
                        if ("".equals(lineRightValuesColumn)) continue;
                        lineRightValuesString = String.valueOf(lineRightValuesString) + rs.getString(lineRightValuesColumn) + ",";
                    }
                    titlesString = titlesString.equals("") ? "" : titlesString.substring(0, titlesString.length() - 1);
                    barLeftValuesString = barLeftValuesString.equals("") ? "" : barLeftValuesString.substring(0, barLeftValuesString.length() - 1);
                    barRightValuesString = barRightValuesString.equals("") ? "" : barRightValuesString.substring(0, barRightValuesString.length() - 1);
                    lineLeftValuesString = lineLeftValuesString.equals("") ? "" : lineLeftValuesString.substring(0, lineLeftValuesString.length() - 1);
                    lineRightValuesString = lineRightValuesString.equals("") ? "" : lineRightValuesString.substring(0, lineRightValuesString.length() - 1);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            p.setTitlesArray(titlesString);
            p.setBarLeftValuesArray(barLeftValuesString);
            p.setBarRightValuesArray(barRightValuesString);
            p.setLineLeftValuesArray(lineLeftValuesString);
            p.setLineRightValuesArray(lineRightValuesString);
            return p;
        }
        if ("RADARCHART".equals(chartType)) {
            RadarChart p = new RadarChart();
            p.setChartName(chartDoc.selectSingleNode("/char/chartName").getText());
            String chartNameValgin = chartDoc.selectSingleNode("/char/chartNameValgin").getText();
            p.setChartValgin(Const.Form.Cell.Chart.Valgin.valueOf(chartNameValgin));
            String colorStyle = chartDoc.selectSingleNode("/char/colorStyle").getText();
            p.setColorStyle(Const.Form.Cell.Chart.ColorStyle.valueOf(colorStyle));
            String radius = chartDoc.selectSingleNode("/char/radius").getText();
            if (!HussarString.isEmpty(radius)) {
                p.setRadius(Integer.parseInt(radius));
            }
            p.setFill("true".equalsIgnoreCase(chartDoc.selectSingleNode("/char/fill").getText()));
            String titlesString = chartDoc.selectSingleNode("/char/titlesString").getText();
            String valuesString = chartDoc.selectSingleNode("/char/valuesString").getText();
            String dataSql = chartDoc.selectSingleNode("/char/datasource/sql").getText();
            if (!dataSql.equals("")) {
                String datasourceName = chartDoc.selectSingleNode("/char/datasource/name").getText();
                String valuesColumn = chartDoc.selectSingleNode("/char/datasource/valuesColumn").getText();
                String titlesColumn = chartDoc.selectSingleNode("/char/datasource/titlesColumn").getText();
                titlesString = "";
                valuesString = "";
                try {
                    RowSet rs = DbOper.executeQuery((String)datasourceName, (String)dataSql);
                    while (rs.next()) {
                        titlesString = String.valueOf(titlesString) + rs.getString(titlesColumn) + ",";
                        valuesString = String.valueOf(valuesString) + rs.getString(valuesColumn) + ",";
                    }
                    titlesString = titlesString.equals("") ? "" : titlesString.substring(0, titlesString.length() - 1);
                    valuesString = valuesString.equals("") ? "" : valuesString.substring(0, valuesString.length() - 1);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            p.setTitlesArray(titlesString);
            p.setValuesArray(valuesString);
            return p;
        }
        if ("DASHBOARD".equals(chartType)) {
            String angle;
            String min;
            DashBoard p = new DashBoard();
            p.setChartName(chartDoc.selectSingleNode("/char/chartName").getText());
            String chartNameValgin = chartDoc.selectSingleNode("/char/chartNameValgin").getText();
            p.setChartValgin(Const.Form.Cell.Chart.Valgin.valueOf(chartNameValgin));
            String colorStyle = chartDoc.selectSingleNode("/char/colorStyle").getText();
            p.setColorStyle(Const.Form.Cell.Chart.ColorStyle.valueOf(colorStyle));
            String max = chartDoc.selectSingleNode("/char/max").getText();
            if (!HussarString.isEmpty(max)) {
                p.setMax(Integer.parseInt(max));
            }
            if (!HussarString.isEmpty(min = chartDoc.selectSingleNode("/char/min").getText())) {
                p.setMin(Integer.parseInt(min));
            }
            if (!HussarString.isEmpty(angle = chartDoc.selectSingleNode("/char/angle").getText())) {
                p.setAngle(Integer.parseInt(angle));
            }
            String titlesString = chartDoc.selectSingleNode("/char/titlesString").getText();
            String valuesString = chartDoc.selectSingleNode("/char/valuesString").getText();
            String dataSql = chartDoc.selectSingleNode("/char/datasource/sql").getText();
            if (!dataSql.equals("")) {
                String datasourceName = chartDoc.selectSingleNode("/char/datasource/name").getText();
                String valuesColumn = chartDoc.selectSingleNode("/char/datasource/valuesColumn").getText();
                String titlesColumn = chartDoc.selectSingleNode("/char/datasource/titlesColumn").getText();
                titlesString = "";
                valuesString = "";
                try {
                    RowSet rs = DbOper.executeQuery((String)datasourceName, (String)dataSql);
                    while (rs.next()) {
                        titlesString = String.valueOf(titlesString) + rs.getString(titlesColumn) + ",";
                        valuesString = String.valueOf(valuesString) + rs.getString(valuesColumn) + ",";
                    }
                    titlesString = titlesString.equals("") ? "" : titlesString.substring(0, titlesString.length() - 1);
                    valuesString = valuesString.equals("") ? "" : valuesString.substring(0, valuesString.length() - 1);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            p.setTitlesArray(titlesString);
            p.setValuesArray(valuesString);
            return p;
        }
        return null;
    }
}

