/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.form.bo;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.bo.HussarJsonObject;
import com.sdjxd.hussar.core.form72.bo.FormCellInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormSessionBo;
import com.sdjxd.hussar.core.form72.bo.IFormPatternBo;
import com.sdjxd.hussar.core.form72.service.FormLimitServices;
import com.sdjxd.hussar.core.permit72.bo.ILimitValue;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.utils.Guid;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.hussar.mobile.base.bo.MobileResponseBo;
import com.sdjxd.hussar.mobile.form.bo.IFormSessionBo_M;
import com.sdjxd.hussar.mobile.workFlow.services.IWorkFlowServices_M;
import java.util.HashMap;
import java.util.Map;

public class FormSessionBo_M
extends FormSessionBo
implements IFormSessionBo_M {
    @Expose(serialize=true, deserialize=true)
    protected Const.Form.OpenType openType;
    @Expose(serialize=true, deserialize=true)
    protected String target;
    @Expose(serialize=true, deserialize=true)
    protected IFormPatternBo mobileFormPattern;
    @Expose(serialize=true, deserialize=true)
    private Map<String, String> urlParamsMap;

    protected FormSessionBo_M() {
    }

    @Override
    public IFormSessionBo_M create(IUserBo user, String formPatternId, String formInstanceDataId, boolean isReadOnly, Const.Form.OpenType openType, String target, Map<String, String> urlParamsMap) throws Exception {
        return this.create(user, formPatternId, formInstanceDataId, isReadOnly, openType, target, true, urlParamsMap);
    }

    @Override
    public IFormSessionBo_M create(IUserBo user, String formPatternId, String formInstanceDataId, boolean isReadOnly, Const.Form.OpenType openType, String target, boolean isloadPatternData, Map<String, String> urlParamsMap) throws Exception {
        IFormPatternBo formPattern;
        FormSessionBo_M formSessionBo = new FormSessionBo_M();
        IFormPatternBo formPatternServices = Factory.getService(Const.LAYER.MOBILE, IFormPatternBo.class);
        formSessionBo.formPattern = formPattern = formPatternServices.load(formPatternId);
        formSessionBo.patternId = formPatternId;
        if (isloadPatternData) {
            formSessionBo.formPatternData = formPattern.getFormPatternData();
        }
        formSessionBo.id = Guid.create();
        if (HussarString.isEmpty(formInstanceDataId)) {
            formSessionBo.formInstanceBo = formSessionBo.formPattern.createFormInstance(user);
            formSessionBo.formInstanceBo.setReadOnly(isReadOnly);
        } else {
            formSessionBo.formInstanceBo = formSessionBo.formPattern.openFormInstance(user, formInstanceDataId, isReadOnly);
        }
        formSessionBo.openType = openType;
        formSessionBo.target = target;
        formSessionBo.mobileFormPattern = this.getMobilePatternBo(formPattern);
        formSessionBo.userLimitGroups = FormLimitServices.getFormCurLimitGroupIds(user.getId(), formPatternId, formSessionBo.formPattern.getUsedLimitGroupIds());
        formSessionBo.urlParamsMap = urlParamsMap;
        if (!formSessionBo.formInstanceBo.isReadOnly()) {
            formSessionBo.updateOpenFlag(user);
        }
        formSessionBo.saveToCache();
        return formSessionBo;
    }

    @Override
    public IFormSessionBo_M createUserDefineFromSession(IUserBo user, String formPatternId, Const.Form.OpenType openType, String target, Map<String, String> urlParamsMap) throws Exception {
        IFormPatternBo formPattern;
        FormSessionBo_M formSessionBo = new FormSessionBo_M();
        IFormPatternBo formPatternServices = Factory.getService(Const.LAYER.MOBILE, IFormPatternBo.class);
        formSessionBo.formPattern = formPattern = formPatternServices.load(formPatternId);
        formSessionBo.patternId = formPatternId;
        formSessionBo.id = Guid.create();
        formSessionBo.openType = openType;
        formSessionBo.target = target;
        formSessionBo.mobileFormPattern = this.getMobilePatternBo(formPattern);
        formSessionBo.userLimitGroups = FormLimitServices.getFormCurLimitGroupIds(user.getId(), formPatternId, formSessionBo.formPattern.getUsedLimitGroupIds());
        formSessionBo.urlParamsMap = urlParamsMap;
        formSessionBo.saveToCache();
        return formSessionBo;
    }

    @Override
    public IFormSessionBo_M create(IUserBo user, String formPatternId, String formInstanceDataId, boolean isReadOnly) throws Exception {
        return this.create(user, formPatternId, formInstanceDataId, isReadOnly, Const.Form.OpenType.NEW, "self", null);
    }

    @Override
    public IFormSessionBo_M create(IUserBo user, String formPatternId, Const.Form.OpenType openType, String target) throws Exception {
        return this.create(user, formPatternId, null, true, openType, target, null);
    }

    @Override
    public IFormSessionBo_M load(String formSessionId) throws Exception {
        return (IFormSessionBo_M)Global.getContext().getSession(formSessionId);
    }

    @Override
    public IFormSessionBo_M createRefreshSession(String target, String formPatternId, HashMap<Integer, HussarJsonObject> formPatternData, HashMap<Integer, FormCellInstanceBo> data, HashMap<String, ILimitValue> limit) {
        FormSessionBo_M formSessionBo = (FormSessionBo_M)this.createRefreshSession(target, formPatternId);
        formSessionBo.formPatternData = formPatternData;
        FormInstanceBo formInstance = new FormInstanceBo();
        formInstance.addData(data);
        formSessionBo.formInstanceBo = formInstance;
        formSessionBo.formPatternCellLimits = limit;
        return formSessionBo;
    }

    @Override
    public IFormSessionBo_M createRefreshSession(String target, String formPatternId) {
        FormSessionBo_M formSessionBo = new FormSessionBo_M();
        formSessionBo.patternId = formPatternId;
        formSessionBo.openType = Const.Form.OpenType.OLD;
        formSessionBo.target = target;
        return formSessionBo;
    }

    @Override
    public IFormSessionBo_M openFormSessonByFlow(IUserBo user, String formPatternId, String flowId, String formInstanceDataId, Const.Form.OpenType openType, String target) throws Exception {
        return this.openFormSessonByFlow(user, formPatternId, flowId, formInstanceDataId, openType, target, null);
    }

    @Override
    public IFormSessionBo_M openFormSessonByFlow(IUserBo user, String formPatternId, String flowId, String formInstanceDataId, Const.Form.OpenType openType, String target, Map<String, String> urlParamsMap) throws Exception {
        IFormPatternBo formPattern;
        FormSessionBo_M formSessionBo = new FormSessionBo_M();
        IFormPatternBo formPatternServices = Factory.getService(Const.LAYER.MOBILE, IFormPatternBo.class);
        formSessionBo.formPattern = formPattern = formPatternServices.load(formPatternId);
        formSessionBo.patternId = formPatternId;
        formSessionBo.formPatternData = formPattern.getFormPatternData();
        formSessionBo.id = Guid.create();
        formSessionBo.saveToCache();
        formSessionBo.formInstanceBo = HussarString.isEmpty(formInstanceDataId) ? formSessionBo.formPattern.createFormInstanceWithFlow(user, flowId) : formSessionBo.formPattern.openFormInstanceWithFlow(user, formInstanceDataId, -1);
        formSessionBo.openType = openType;
        formSessionBo.target = target;
        formSessionBo.mobileFormPattern = this.getMobilePatternBo(formPattern);
        IWorkFlowServices_M workFlowServices = Factory.getService(Const.LAYER.MOBILE, IWorkFlowServices_M.class);
        formSessionBo.hasPermit = false;
        if (formSessionBo.formInstanceBo.getFlowNodeInstanceId() != -1) {
            formSessionBo.userLimitGroups = workFlowServices.getFormSessionPermitGroupsByFlow(formSessionBo, user);
        }
        formSessionBo.formInstanceBo.setOpenByFlow(true);
        formSessionBo.urlParamsMap = urlParamsMap;
        if (!formSessionBo.formInstanceBo.isReadOnly() && formSessionBo.hasPermit) {
            formSessionBo.updateOpenFlag(user);
        }
        return formSessionBo;
    }

    @Override
    public void setFormCellPatternData(int cellId, HussarJsonObject cellPatternData) {
        if (this.formPatternData != null) {
            this.formPatternData.put(cellId, cellPatternData);
        } else {
            this.formPatternData = new HashMap();
            this.formPatternData.put(cellId, cellPatternData);
        }
    }

    @Override
    public void modifySessionByFlowNodeInstanceId(IUserBo user, int flowNodeInstanceId, String formPatternId) throws Exception {
        this.formInstanceBo.initFlowInfo(flowNodeInstanceId);
        if (this.formInstanceBo.getFlowNodeInstanceId() != -1) {
            this.formInstanceBo.initFlowInfo(flowNodeInstanceId);
        }
        IWorkFlowServices_M workFlowServices = Factory.getService(Const.LAYER.MOBILE, IWorkFlowServices_M.class);
        this.hasPermit = false;
        this.userLimitGroups = workFlowServices.getFormSessionPermitGroupsByFlow(this, user);
        if (!this.formInstanceBo.isReadOnly() && this.hasPermit) {
            this.updateOpenFlag(user);
        }
    }

    private IFormPatternBo getMobilePatternBo(IFormPatternBo patternBo) {
        if (AppConfig.getModel().equalsIgnoreCase("debug")) {
            return patternBo;
        }
        return null;
    }

    @Override
    public boolean updateOpenFlag(IUserBo user) throws Exception {
        MobileResponseBo response = AppConfig.getMobileResponse();
        StringBuffer reason = new StringBuffer();
        if (this.formPattern != null && this.formInstanceBo != null) {
            if (this.formInstanceBo.isOpenByFlow()) {
                if (!this.formInstanceBo.getFlowInstance().updateOpener(true)) {
                    this.formInstanceBo.setReadOnly(true);
                    reason.append("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u88ab").append(this.formInstanceBo.getFlowInstance().getOpener().getName()).append("\u6253\u5f00\uff0c\u5c06\u4ee5\u53ea\u8bfb\u65b9\u5f0f\u6253\u5f00\uff01");
                    response.setMsg(reason.toString());
                    return false;
                }
                if (!this.formPattern.updateOpenFlag(user, this.formInstanceBo)) {
                    this.formInstanceBo.getFlowInstance().updateOpener(false);
                    reason.append("\u8868\u5355\u5b9e\u4f8b\u5df2\u88ab").append(this.formInstanceBo.getOpener().getName()).append("\u6253\u5f00\uff0c\u5c06\u4ee5\u53ea\u8bfb\u65b9\u5f0f\u6253\u5f00\uff01");
                    response.setMsg(reason.toString());
                    return false;
                }
                return true;
            }
            if (!this.formPattern.updateOpenFlag(user, this.formInstanceBo)) {
                reason.append("\u8868\u5355\u5b9e\u4f8b\u5df2\u88ab").append(this.formInstanceBo.getOpener().getName()).append("\u6253\u5f00\uff0c\u5c06\u4ee5\u53ea\u8bfb\u65b9\u5f0f\u6253\u5f00\uff01");
                response.setMsg(reason.toString());
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public IFormPatternBo getMobileFormPattern() {
        return this.mobileFormPattern;
    }
}

