/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.base.bo;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.hussar.mobile.base.bo.MobileClientBo;
import com.sdjxd.hussar.mobile.base.bo.MobileResponseBo;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class MobileRequestBo {
    private static final String CUR_CLIENT_SESSION_KEY = "_MOBILECLIENT";
    private static final String CUR_USER_SESSION_KEY = "_MOBILEUSER";
    private static Logger log = Logger.getLogger(MobileRequestBo.class);
    @Expose(serialize=true, deserialize=true)
    private String className;
    @Expose(serialize=true, deserialize=true)
    private String methodName;
    @Expose(serialize=true, deserialize=true)
    private ArrayList<Object> params;
    @Expose(serialize=true, deserialize=true)
    private IUserBo mobileUser;
    @Expose(serialize=true, deserialize=true)
    private MobileClientBo client;
    @Expose(serialize=true, deserialize=true)
    private String contextId;
    @Expose(serialize=true, deserialize=true)
    private String patternId;
    @Expose(serialize=true, deserialize=true)
    private Map<String, String> urlMap;

    public Map<String, String> getUrlMap() {
        return this.urlMap;
    }

    public void setUrlMap(Map<String, String> urlMap) {
        this.urlMap = urlMap;
    }

    public void addUrlMap(Map<String, String> urlMap) {
        if (this.urlMap == null) {
            this.urlMap = urlMap;
        } else {
            this.urlMap.putAll(urlMap);
        }
    }

    public String getUrlParam(String key) {
        return this.urlMap.get(key);
    }

    public String getPatternId() {
        return this.patternId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public ArrayList<Object> getParams() {
        return this.params;
    }

    public void setParams(ArrayList<Object> params) {
        this.params = params;
    }

    public IUserBo getMobileUser() {
        return this.mobileUser;
    }

    public void setMobileUser(IUserBo mobileUser) {
        this.mobileUser = mobileUser;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public MobileClientBo getClient() {
        return this.client;
    }

    public void setClient(MobileClientBo client) {
        this.client = client;
    }

    protected MobileClientBo getCurrentClient() throws Exception {
        MobileClientBo client = null;
        if (Global.getContext() != null) {
            client = (MobileClientBo)Global.getContext().getSession(CUR_CLIENT_SESSION_KEY);
        }
        return client;
    }

    public boolean registClient() throws Exception {
        if (Global.getContext() != null) {
            Global.getContext().setSession(CUR_CLIENT_SESSION_KEY, this.client);
            return true;
        }
        return false;
    }

    protected IUserBo getCurrentUser() throws Exception {
        IUserBo client = null;
        if (Global.getContext() != null) {
            client = (IUserBo)Global.getContext().getSession(CUR_USER_SESSION_KEY);
        }
        return client;
    }

    public boolean registUser() throws Exception {
        if (Global.getContext() != null) {
            Global.getContext().setSession(CUR_USER_SESSION_KEY, this.mobileUser);
            return true;
        }
        return false;
    }

    public boolean loadRequestUser() throws Exception {
        boolean result = false;
        if (AppConfig.getIsUseSession()) {
            if (this.getCurrentUser() != null && this.getCurrentClient() != null) {
                this.setMobileUser(this.getCurrentUser());
                this.setClient(this.getCurrentClient());
                result = true;
            } else {
                AppConfig.getMobileResponse().setStatuCode(MobileResponseBo.StatusCode.SESSIONTIMEOUT);
            }
        } else if (this.getMobileUser() != null && this.getMobileUser().getCode() != null) {
            if (this.getMobileUser().checkUser()) {
                this.registUser();
                this.registClient();
                result = true;
            } else {
                result = false;
            }
        }
        return result;
    }
}

