/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.mobile.base;

import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.bo.EncodedProperties;
import com.sdjxd.hussar.mobile.base.bo.MobileRequestBo;
import com.sdjxd.hussar.mobile.base.bo.MobileResponseBo;
import com.sdjxd.hussar.mobile.key.services.KeyServices;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.rpc.ServiceException;

public class AppConfig {
    static Properties appConfig;
    private static String model;
    private static Map<String, Object> configMap;

    public static String getConfig(String key) {
        String value;
        if (appConfig == null || model == null || model.equalsIgnoreCase("debug")) {
            appConfig = AppConfig.loadProperties("mobileAppConfig.properties", "GBK");
            model = appConfig.getProperty("MODEL").trim();
        }
        return (value = appConfig.getProperty(key)) == null ? "" : value.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addMobileAppConfig(String key, String value) {
        appConfig.put(key, value);
        OutputStream outStream = null;
        try {
            try {
                outStream = new FileOutputStream(String.valueOf(Global.getRealPath()) + "/WEB-INF/mobileAppConfig.properties");
                appConfig.store(outStream, null);
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (outStream == null) return;
                try {
                    outStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (outStream == null) return;
                try {
                    outStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getServerResVersionCode() {
        return AppConfig.getConfig("SERVERRESVERSIONCODE");
    }

    public static void setServerResVersionCode(String code) {
        AppConfig.addMobileAppConfig("SERVERRESVERSIONCODE", code);
    }

    public static boolean getIsUseGzip() {
        return true;
    }

    public static boolean getIsUseKey() {
        return Boolean.parseBoolean(AppConfig.getConfig("ISUSEKEY"));
    }

    public static boolean getIsUseSession() {
        return Boolean.parseBoolean(AppConfig.getConfig("ISUSESESSION"));
    }

    public static int getLoginModel() {
        return Integer.parseInt(AppConfig.getConfig("LOGINMODEL"));
    }

    public static String getModel() {
        if (model == null) {
            model = AppConfig.getConfig("MODEL");
        }
        return model;
    }

    public static String getPath() {
        return Global.getRealPath();
    }

    public static Map<String, Object> getConfigMap() throws MalformedURLException, RemoteException, ServiceException {
        if (configMap == null || model == null || model.equalsIgnoreCase("debug")) {
            HashMap<String, Object> configInfo = new HashMap<String, Object>();
            boolean isUseKey = Boolean.parseBoolean(AppConfig.getConfig("ISUSEKEY"));
            configInfo.put("isUseKey", isUseKey);
            if (isUseKey) {
                String publicKey = KeyServices.getPublicKey();
                configInfo.put("publicKey", publicKey);
            }
            configInfo.put("isUseGzip", true);
            configInfo.put("isShowToDo", Boolean.parseBoolean(AppConfig.getConfig("isShowToDo")));
            configInfo.put("phoneNumServer", AppConfig.getConfig("PHONENUMSERVER"));
            configInfo.put("isUseSession", Boolean.parseBoolean(AppConfig.getConfig("ISUSESESSION")));
            configInfo.put("loginModel", Integer.parseInt(AppConfig.getConfig("LOGINMODEL")));
            configInfo.put("maxWaitTime", Integer.parseInt(AppConfig.getConfig("THREADSLEEPTIME")) * Integer.parseInt(AppConfig.getConfig("LOOPNUM")));
            configMap = configInfo;
        }
        return configMap;
    }

    public static String getFileAbsolutePath(String filePath) {
        String path = String.valueOf(Global.getRealPath().replace("\\", "/")) + filePath;
        return path;
    }

    public static void setMobileRequest(MobileRequestBo request) {
        Global.getContext().setRequest("mobileRequest", request);
    }

    public static void setMobileResponse(MobileResponseBo response) {
        Global.getContext().setRequest("mobileResponse", response);
    }

    public static MobileRequestBo getMobileRequest() {
        return (MobileRequestBo)Global.getContext().getRequest("mobileRequest");
    }

    public static MobileResponseBo getMobileResponse() {
        return (MobileResponseBo)Global.getContext().getRequest("mobileResponse");
    }

    private static Properties loadProperties(String location, String encoding) {
        EncodedProperties properties = new EncodedProperties();
        properties.load(location);
        return properties;
    }

    public static String getSessionId() {
        return Global.getContext().getSessionId();
    }
}

