/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.license;

import com.sdjxd.hussar.license.HardWareUtils;
import com.sdjxd.hussar.license.LicenseManagerHolder;
import com.sdjxd.pms.platform.base.Global;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultKeyStoreParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;

public class VerifyLicense {
    private static Logger log = Logger.getLogger(VerifyLicense.class);
    private static String PUBLICALIAS = "";
    private static String STOREPWD = "";
    private static String SUBJECT = "";
    private static String licPath = "";
    private static String pubPath = "";
    private static boolean isChecked = false;
    private static boolean checkedResult = false;

    public void setParam(String propertiesPath) {
        Properties prop = new Properties();
        InputStream in = this.getClass().getResourceAsStream(propertiesPath);
        try {
            prop.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PUBLICALIAS = prop.getProperty("PUBLICALIAS");
        STOREPWD = prop.getProperty("STOREPWD");
        SUBJECT = prop.getProperty("SUBJECT");
        licPath = prop.getProperty("licPath");
        pubPath = prop.getProperty("pubPath");
    }

    public boolean verify() {
        block14: {
            isChecked = true;
            LicenseManager licenseManager = LicenseManagerHolder.getLicenseManager(VerifyLicense.initLicenseParams());
            try {
                licenseManager.install(new File(String.valueOf(Global.getPath()) + licPath));
                log.info((Object)"\u670d\u52a1\u7aef\u5b89\u88c5\u8bc1\u4e66\u6210\u529f!");
            }
            catch (Exception e) {
                log.info((Object)"\u670d\u52a1\u7aef\u8bc1\u4e66\u5b89\u88c5\u5931\u8d25!");
                return false;
            }
            try {
                LicenseContent content = licenseManager.verify();
                Map hardInfo = (Map)content.getExtra();
                int num = 0;
                if (HardWareUtils.getCPUSerial() != null && HardWareUtils.getCPUSerial().equalsIgnoreCase((String)hardInfo.get("CPU"))) {
                    ++num;
                } else if (HardWareUtils.getCPUSerial() == null && hardInfo.get("CPU") == null) {
                    ++num;
                }
                if (HardWareUtils.getMotherboardSN() != null && HardWareUtils.getMotherboardSN().equalsIgnoreCase((String)hardInfo.get("MOTHERBOARD"))) {
                    ++num;
                } else if (HardWareUtils.getMotherboardSN() == null && hardInfo.get("MOTHERBOARD") == null) {
                    ++num;
                }
                if (HardWareUtils.getMac() != null && HardWareUtils.getMac().equalsIgnoreCase((String)hardInfo.get("MAC"))) {
                    ++num;
                } else if (HardWareUtils.getMac() == null && hardInfo.get("MAC") == null) {
                    ++num;
                }
                if (num <= 1) break block14;
                log.info((Object)"\u670d\u52a1\u7aef\u9a8c\u8bc1\u8bc1\u4e66\u6210\u529f!");
                checkedResult = true;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info((Object)"\u670d\u52a1\u7aef\u8bc1\u4e66\u9a8c\u8bc1\u5931\u6548!");
                checkedResult = false;
                return false;
            }
        }
        checkedResult = false;
        log.info((Object)"\u670d\u52a1\u7aef\u8bc1\u4e66\u9a8c\u8bc1\u5931\u6548!");
        return false;
    }

    private static LicenseParam initLicenseParams() {
        Preferences preference = Preferences.userNodeForPackage(VerifyLicense.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(STOREPWD);
        DefaultKeyStoreParam privateStoreParam = new DefaultKeyStoreParam(VerifyLicense.class, pubPath, PUBLICALIAS, STOREPWD, null);
        DefaultLicenseParam licenseParams = new DefaultLicenseParam(SUBJECT, preference, (KeyStoreParam)privateStoreParam, (CipherParam)cipherParam);
        return licenseParams;
    }

    public static int verifyHard() {
        if (isChecked) {
            if (checkedResult) {
                return 1;
            }
            return 0;
        }
        VerifyLicense vLicense = new VerifyLicense();
        vLicense.setParam("param.properties");
        if (vLicense.verify()) {
            return 1;
        }
        return 0;
    }

    public static String convertString() {
        if (isChecked) {
            if (checkedResult) {
                return "1";
            }
            return "0";
        }
        VerifyLicense vLicense = new VerifyLicense();
        vLicense.setParam("param.properties");
        if (vLicense.verify()) {
            return "1";
        }
        return "0";
    }
}

