/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.license;

import com.sdjxd.pms.platform.base.Global;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Properties;

public class HardWareUtils {
    public static String getMotherboardSN() {
        if (System.getProperty("os.name").equalsIgnoreCase("Linux")) {
            return HardWareUtils.getMotherboardSN_linux();
        }
        return HardWareUtils.getMotherboardSN_windows();
    }

    private static String getMotherboardSN_linux() {
        String result = "";
        try {
            String line;
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "dmidecode |grep 'Serial Number'| head -n 1"});
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u65e0\u4e3b\u677f\u5e8f\u5217\u53f7\u88ab\u8bfb\u53d6";
        }
        if (result.trim().length() < 1 || result == null) {
            result = "\u65e0\u4e3b\u677f\u5e8f\u5217\u53f7\u88ab\u8bfb\u53d6";
        }
        return result.trim();
    }

    private static String getMotherboardSN_windows() {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u65e0\u4e3b\u677f\u5e8f\u5217\u53f7\u88ab\u8bfb\u53d6";
        }
        if (result.trim().length() < 1 || result == null) {
            result = "\u65e0\u4e3b\u677f\u5e8f\u5217\u53f7\u88ab\u8bfb\u53d6";
        }
        return result.trim();
    }

    public static String getHardDiskSN(String drive) {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive + "\")\n" + "Wscript.Echo objDrive.SerialNumber";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return result.trim();
    }

    public static String getCPUSerial() {
        if (System.getProperty("os.name").equalsIgnoreCase("Linux")) {
            return HardWareUtils.getCPUSerial_linux();
        }
        return HardWareUtils.getCPUSerial_windows();
    }

    private static String getCPUSerial_linux() {
        String result = "";
        try {
            String line;
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "dmidecode -t 4 | grep ID | head -n 1"});
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return "\u65e0CPU_ID\u88ab\u8bfb\u53d6";
        }
        if (result.trim().length() < 1 || result == null) {
            result = "\u65e0CPU_ID\u88ab\u8bfb\u53d6";
        }
        return result.trim();
    }

    private static String getCPUSerial_windows() {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("tmp", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_Processor\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.ProcessorId \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            input.close();
            file.delete();
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return "\u65e0CPU_ID\u88ab\u8bfb\u53d6";
        }
        if (result.trim().length() < 1 || result == null) {
            result = "\u65e0CPU_ID\u88ab\u8bfb\u53d6";
        }
        return result.trim();
    }

    public static String getMac() {
        if (System.getProperty("os.name").equalsIgnoreCase("Linux")) {
            return HardWareUtils.getMac_linux();
        }
        return HardWareUtils.getMac_windows();
    }

    private static String getMac_linux() {
        String result = "";
        try {
            String line;
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "lshw -c network | grep serial | head -n 1"});
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return "\u65e0MAC\u88ab\u8bfb\u53d6";
        }
        if (result.trim().length() < 1 || result == null) {
            result = "\u65e0MAC\u88ab\u8bfb\u53d6";
        }
        return result.trim();
    }

    private static String getMac_windows() {
        String result = "";
        try {
            String line;
            Process process = Runtime.getRuntime().exec("ipconfig /all");
            InputStreamReader ir = new InputStreamReader(process.getInputStream(), "gb2312");
            LineNumberReader input = new LineNumberReader(ir);
            while ((line = input.readLine()) != null) {
                String MACAddr;
                if (line.indexOf("Physical Address") <= 0 && line.indexOf("\u7269\u7406\u5730\u5740") <= 0 || line.indexOf("-") <= 0) continue;
                result = MACAddr = line.substring(line.indexOf("-") - 2);
                break;
            }
        }
        catch (IOException e) {
            System.err.println("IOException " + e.getMessage());
            return "\u65e0MAC\u88ab\u8bfb\u53d6";
        }
        if (result.trim().length() < 1 || result == null) {
            result = "\u65e0MAC\u88ab\u8bfb\u53d6";
        }
        return result.trim();
    }

    public static void writeHardInfo() {
        Properties prop = new Properties();
        prop.put("CPU", HardWareUtils.getCPUSerial());
        prop.put("MOTHERBOARD", HardWareUtils.getMotherboardSN());
        prop.put("MAC", HardWareUtils.getMac());
        try {
            FileOutputStream out = new FileOutputStream(String.valueOf(Global.getPath()) + "serverHardInfo.properties");
            prop.store(out, "the properties's comment");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HardWareUtils.writeHardInfo();
    }
}

