/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.jxdedit.resource.service;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.jxdedit.resource.dao.ResDao;
import com.sdjxd.hussar.jxdedit.resource.po.ResPo;
import com.sdjxd.hussar.mobile.utils.FileMD5Util;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.Guid;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ResServices {
    protected static ResDao dao;

    static {
        try {
            dao = Factory.getDao(ResDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkInRes(String resId, String resType, String resName, String fileStr) throws Exception {
        ResPo resPo = new ResPo();
        resPo.setResId(resId);
        resPo.setResName(resName);
        resPo.setResType(Integer.parseInt(resType));
        resPo.setFileContent(fileStr);
        resPo.setFileMd5(FileMD5Util.getMD5String(fileStr));
        resPo.setUse(true);
        resPo.setUserId(User.getCurrentUser().getId());
        resPo.setUserName(User.getCurrentUser().getName());
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        resPo.setCheckInTime(df.format(date));
        resPo.setFileId(Guid.create());
        String curVerion = dao.getResVersion(resId);
        String versionCode = "";
        if (curVerion == null) {
            versionCode = "1.0";
        } else if (curVerion.indexOf(",") > 0) {
            String[] versionInfos = curVerion.split(",");
            String mainVersionCode = versionInfos[0];
            String childVersionCode = versionInfos[1];
            if (childVersionCode.indexOf(".") <= 0) throw new Exception("\u8d44\u6e90\u7248\u672c\u53f7\u683c\u5f0f\u6709\u8bef\uff01\u5e94\u4e3a\uff081.0,0.0\uff09\u683c\u5f0f");
            String[] childVersionCodeInfo = childVersionCode.split("\\.");
            String childVersionBigNum = childVersionCodeInfo[0];
            String childVersionSmallNum = childVersionCodeInfo[1];
            versionCode = String.valueOf(mainVersionCode) + "," + childVersionBigNum + "." + (Integer.parseInt(childVersionSmallNum) + 1);
        } else {
            if (curVerion.indexOf(".") <= 0) throw new Exception("\u8d44\u6e90\u7248\u672c\u53f7\u683c\u5f0f\u6709\u8bef\uff01\u5e94\u4e3a\uff081.0\uff09\u683c\u5f0f");
            String[] mainVersionCodeInfo = curVerion.split("\\.");
            String mainVersionBigNum = mainVersionCodeInfo[0];
            String mainVersionSmallNum = mainVersionCodeInfo[1];
            versionCode = String.valueOf(mainVersionBigNum) + "." + (Integer.parseInt(mainVersionSmallNum) + 1);
        }
        resPo.setVersionCode(versionCode);
        if (!dao.saveRes(resPo)) return "false";
        return "true";
    }

    public static String getCurResContent(String resId) throws SQLException {
        return dao.getCurResContent(resId);
    }

    public static String getResContentByVersion(String resId, String verSionCode) {
        return dao.getResContentByVersion(resId, verSionCode);
    }

    public static String ImportRes(String sqlStr, String resId, String resType, String resName, String versionCode, String fileStr) {
        Gson gson = new Gson();
        List sqlList = (List)gson.fromJson(sqlStr, new TypeToken<List<String>>(){}.getType());
        ResPo resPo = new ResPo();
        resPo.setResId(resId);
        resPo.setResName(resName);
        resPo.setResType(Integer.parseInt(resType));
        resPo.setFileContent(fileStr);
        resPo.setFileMd5(FileMD5Util.getMD5String(fileStr));
        resPo.setUse(true);
        resPo.setUserId(User.getCurrentUser().getId());
        resPo.setUserName(User.getCurrentUser().getName());
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        resPo.setCheckInTime(df.format(date));
        resPo.setFileId(Guid.create());
        resPo.setVersionCode(versionCode);
        try {
            if (dao.importRes(sqlList, resPo)) {
                return "true";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "false";
    }
}

