/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.explorer.form72.service.cell;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.form72.bo.FormInstanceBo;
import com.sdjxd.hussar.core.form72.bo.FormStyleBo;
import com.sdjxd.hussar.core.form72.bo.IFormCellBo;
import com.sdjxd.hussar.core.form72.bo.IFormPatternBo;
import com.sdjxd.hussar.core.form72.po.FormCellPo;
import com.sdjxd.hussar.explorer.form72.service.bo.FormStyleExplorerBo;
import com.sdjxd.hussar.explorer.form72.service.cell.IFormCellExplorerBo;
import java.util.ArrayList;

public class FormCellExplorerBo
implements IFormCellExplorerBo {
    private IFormCellBo core;
    private int cellId;
    private FormStyleExplorerBo baseStyle;
    private FormStyleExplorerBo readonlyStyle;
    private FormStyleExplorerBo printStyle;

    protected FormCellExplorerBo() {
    }

    @Override
    public void create(IFormPatternBo formPattern) throws Exception {
        ArrayList cellPos = null;
        int i = 0;
        while (i < cellPos.size()) {
            FormCellPo formCellPo = (FormCellPo)cellPos.get(i);
            IFormCellBo cell = Factory.getFormCell(Const.LAYER.EXPLORER, formCellPo.getCellType());
            cell.init(formPattern, formCellPo);
            formPattern.addCell(cell);
            ++i;
        }
    }

    @Override
    public void init(IFormPatternBo formPattern, FormCellPo cellPo) throws Exception {
        this.cellId = cellPo.getCellId();
        this.core = formPattern.getCell(cellPo.getByName());
        this.baseStyle = new FormStyleExplorerBo();
        this.baseStyle.addCss(cellPo.getBorderStyle());
        this.baseStyle.addCss(cellPo.getFontStyle());
        this.baseStyle.addCss(cellPo.getAlignStyle());
        this.baseStyle.addCss(cellPo.getTextColorStyle());
        this.baseStyle.addCss(FormStyleBo.Key.zIndex, cellPo.getzIndex());
        this.baseStyle.addCss(FormStyleBo.Key.borderWidth, cellPo.getLineWidth());
        this.readonlyStyle = new FormStyleExplorerBo();
        this.readonlyStyle.addCss(cellPo.getReadBkColorStyle());
        this.printStyle = new FormStyleExplorerBo();
        this.printStyle.addCss(cellPo.getPrintStyleClass());
    }

    @Override
    public void saveInstance(FormInstanceBo formInstance) throws Exception {
    }

    @Override
    public Object getCellData() throws Exception {
        return null;
    }

    @Override
    public String getByName() {
        return this.core.getByName();
    }

    @Override
    public int getId() {
        return 0;
    }
}

