/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils.exception;

import com.sdjxd.hussar.core.utils.HussarJson;
import com.sdjxd.hussar.core.utils.exception.HussarException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class HussarInvokeException
extends HussarException {
    static final long serialVersionUID = -1L;
    protected String classPath;
    protected String methodName;
    protected Object[] args;
    protected String message;
    private static Logger log = Logger.getLogger(HussarInvokeException.class);

    public HussarInvokeException(String classPath, String methodName, Object[] args, Exception exp) {
        this.classPath = classPath;
        this.methodName = methodName;
        this.args = args;
        this.initCause(exp);
        String argStr = HussarJson.gson_toJson(args);
        this.message = new StringBuffer(128).append(classPath).append(".").append(methodName).append(" INVOKE ").append("ERROR\u3002ARGUMENTS:").append(argStr).toString();
        log.error((Object)this.message, (Throwable)this);
    }

    public HussarInvokeException(EXPTYPE expType, String classPath, String methodName, Object[] args, Throwable exp) {
        this.classPath = classPath;
        this.methodName = methodName;
        this.args = args;
        if (EXPTYPE.InvocationTarget == expType) {
            this.initCause(((InvocationTargetException)exp).getTargetException());
        } else {
            this.initCause(exp);
        }
        String argStr = HussarJson.gson_toJson(args);
        this.message = new StringBuffer(128).append(classPath).append(".").append(methodName).append(" INVOKE ").append(expType.toString()).append("ERROR\u3002ARGUMENTS:").append(argStr).toString();
        log.error((Object)this.message, (Throwable)this);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static enum EXPTYPE {
        IllegalAccess,
        InvocationTarget,
        IllegalArgument;

    }
}

