/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sdjxd.hussar.core.utils.IJson;
import java.io.IOException;

public class IJsonAdapterFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        if (!IJson.class.isAssignableFrom(rawType)) {
            return null;
        }
        return new IJsonSerializableAdapter<T>(type);
    }

    public class IJsonSerializableAdapter<T>
    extends TypeAdapter<T> {
        private final TypeToken<T> typeToken;

        public IJsonSerializableAdapter(TypeToken<T> type) {
            this.typeToken = type;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                String json = ((IJson)value).toJson();
                if (json == null) {
                    out.nullValue();
                } else {
                    out.value(json);
                }
            }
        }

        @Override
        public T read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            Class<T> rawType = this.typeToken.getRawType();
            try {
                IJson a = (IJson)rawType.newInstance();
                return a.fromJson(reader.nextString());
            }
            catch (Exception e) {
                e.printStackTrace();
                IOException e1 = new IOException(e.getMessage());
                throw e1;
            }
        }
    }
}

