/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.bo.Context;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.permit72.service.IUserService;
import com.sdjxd.hussar.core.utils.HussarBean;
import com.sdjxd.hussar.core.utils.HussarDate;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.pms.platform.data.DataSource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HussarString {
    private static Logger log = Logger.getLogger(HussarString.class);

    public static String format(String str, String ... arg) {
        String ostr = str;
        int i = 0;
        while (i < arg.length) {
            ostr = ostr.replace("{" + i + "}", arg[i]);
            ++i;
        }
        return ostr;
    }

    public static String format(String str, Object ... arg) {
        String ostr = str;
        int i = 0;
        while (i < arg.length) {
            ostr = ostr.replace("{" + i + "}", arg[i] == null ? "" : arg[i].toString());
            ++i;
        }
        return ostr;
    }

    public static String leftPad(String str, int length, char paddingChar) {
        return StringUtils.leftPad((String)str, (int)length, (char)paddingChar);
    }

    public static String rightPad(String str, int length, char paddingChar) {
        return StringUtils.rightPad((String)str, (int)length, (char)paddingChar);
    }

    public static String toUnicode(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(str.length() * 6);
        char[] c = str.toCharArray();
        int i = 0;
        while (i < c.length) {
            buffer.append("\\u");
            buffer.append(HussarString.leftPad(Integer.toHexString(c[i]), 4, '0'));
            ++i;
        }
        return buffer.toString();
    }

    public static String escapeUrl(String str) {
        try {
            return URLEncoder.encode(str, "gbk");
        }
        catch (UnsupportedEncodingException exp) {
            return str;
        }
    }

    public static String unescapeUrl(String str) {
        try {
            return URLDecoder.decode(str, "gbk");
        }
        catch (UnsupportedEncodingException exp) {
            return str;
        }
    }

    public static String escapeHtml(String str) {
        return StringEscapeUtils.escapeHtml((String)str);
    }

    public static String getPureText(String text) {
        return text.replaceAll("<(.*)>", "");
    }

    public static String escapeSql(String str) {
        return StringEscapeUtils.escapeSql((String)str);
    }

    public static String escapeJavaScript(String str) {
        return StringEscapeUtils.escapeJavaScript((String)str);
    }

    public static String trimLeft(String str, String trimStr) {
        int len;
        if (trimStr == null || (len = trimStr.length()) <= 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        while (len <= sb.length() && sb.substring(0, len).equals(trimStr)) {
            sb.delete(0, len);
        }
        return sb.toString();
    }

    public static String trimRight(String str, String trimStr) {
        int len;
        if (trimStr == null || (len = trimStr.length()) <= 0) {
            return str;
        }
        int newLen = str.length();
        StringBuffer sb = new StringBuffer(str);
        while (len <= newLen && sb.substring(newLen - len, newLen).equals(trimStr)) {
            sb.setLength(newLen -= len);
        }
        return sb.toString();
    }

    public static String escapeXml(String str) {
        return StringEscapeUtils.escapeXml((String)str);
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
            } else {
                byte[] b;
                try {
                    b = Character.toString(c).getBytes("utf-8");
                }
                catch (Exception ex) {
                    b = new byte[]{};
                }
                int j = 0;
                while (j < b.length) {
                    int k = b[j];
                    if (k < 0) {
                        k += 256;
                    }
                    sb.append("%" + Integer.toHexString(k).toUpperCase());
                    ++j;
                }
            }
            ++i;
        }
        String s_utf8 = sb.toString();
        sb.delete(0, sb.length());
        sb.setLength(0);
        sb = null;
        return s_utf8;
    }

    public static String replaceKeyWord(String sstr) {
        if (sstr == null || sstr.length() == 0) {
            return sstr;
        }
        return HussarString.replaceKeyWord(sstr, null, null);
    }

    public static String replaceKeyWord(String sstr, Object ... objs) {
        if (sstr == null || sstr.length() == 0) {
            return sstr;
        }
        String ostr = sstr;
        String regex = "\\[(\\w+)\\.([^\\]]*)\\]";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(ostr);
        Context context = null;
        try {
            context = Global.getContext();
        }
        catch (Exception exp) {
            log.error((Object)"\u83b7\u53d6\u4e0a\u4e0b\u6587\u5931\u8d25");
        }
        HashMap<String, String> replacement = new HashMap<String, String>();
        while (m.find()) {
            String matchValue;
            String matchStr;
            block27: {
                String matchArg;
                String matchName;
                block33: {
                    block34: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block26: {
                                                matchStr = m.group();
                                                matchName = m.group(1);
                                                matchArg = m.group(2);
                                                matchValue = matchStr;
                                                if (replacement.containsKey(matchStr)) continue;
                                                if (!matchName.equals("mobileUrl") || context == null) break block26;
                                                if (AppConfig.getMobileRequest() != null) {
                                                    matchValue = AppConfig.getMobileRequest().getUrlParam(matchArg);
                                                }
                                                break block27;
                                            }
                                            if (!matchName.equals("url") || context == null) break block28;
                                            matchValue = context.getParameter(matchArg);
                                            break block27;
                                        }
                                        if (!matchName.equals("req") || context == null) break block29;
                                        matchValue = (String)context.getRequest(matchArg);
                                        break block27;
                                    }
                                    if (!matchName.equals("user")) break block30;
                                    IUserBo user = null;
                                    try {
                                        IUserService userService = Factory.getService(Const.LAYER.CORE, IUserService.class);
                                        user = userService.getCurrentUser();
                                    }
                                    catch (Exception exp) {
                                        log.error((Object)"\u521b\u5efa\u7528\u6237\u4e1a\u52a1\u5904\u7406\u5bf9\u8c61\u5931\u8d25");
                                    }
                                    if (user != null) {
                                        matchValue = matchArg.equals("id") ? user.getId() : (matchArg.equals("name") ? user.getName() : (matchArg.equals("code") ? user.getCode() : (matchArg.equals("org") ? user.getDeptName() : (matchArg.equals("orgid") ? user.getDeptId() : (matchArg.equals("comp") ? user.getCompName() : (matchArg.equals("compid") ? user.getCompId() : HussarBean.getFieldValueString(user, matchArg)))))));
                                    }
                                    break block27;
                                }
                                if (!matchName.equals("sess") || context == null) break block31;
                                matchValue = (String)context.getSession(matchArg);
                                break block27;
                            }
                            if (!matchName.equals("globalconfig")) break block32;
                            try {
                                matchValue = Global.getConfig(matchArg);
                            }
                            catch (Exception exp) {
                                log.error((Object)"\u83b7\u53d6\u914d\u7f6e\u53c2\u6570\u5931\u8d25");
                            }
                            break block27;
                        }
                        if (!matchName.equals("app")) break block33;
                        if (!matchArg.equals("path")) break block34;
                        matchValue = Global.getRealPath();
                        break block27;
                    }
                    if (!matchArg.equals("name")) break block27;
                    matchValue = Global.getContextPath();
                    break block27;
                }
                if (matchName.equals("db")) {
                    if (matchArg.equals("mode")) {
                        matchValue = DataSource.getDataSource().getSchema();
                    }
                } else if (matchName.equals("now")) {
                    Date curDate = new Date();
                    if (matchArg.equals("weekth")) {
                        matchValue = Integer.toString(HussarDate.getWeekOfYear());
                    } else if (matchArg.equals("weekbegin")) {
                        Date beginDate = HussarDate.getFirstDayOfWeek(curDate);
                        matchValue = HussarDate.formatDateTime(beginDate);
                    } else if (matchArg.equals("weekend")) {
                        Date endDate = HussarDate.getLastDayOfWeek(curDate);
                        matchValue = HussarDate.formatDateTime(endDate);
                    } else if (matchArg.equals("preMonth")) {
                        Date preMonth = HussarDate.getPreMonth(curDate);
                        matchValue = HussarDate.formatDateTime(preMonth);
                    } else {
                        matchValue = matchArg.equals("quarter") ? String.valueOf(HussarDate.getQuarter(curDate)) : HussarDate.getNow(matchArg);
                    }
                } else if (matchName.equals("obj") && objs != null) {
                    int i = 0;
                    while (matchValue == null && i < objs.length) {
                        matchValue = HussarBean.getFieldValueString(objs[i], matchArg);
                        ++i;
                    }
                }
            }
            if (matchValue == null) {
                matchValue = "";
            }
            replacement.put(matchStr, matchValue);
        }
        replacement.put("$appRoot", Global.getContextPath());
        return HussarString.replace(ostr, replacement);
    }

    public static String replace(String sstr, Map<String, String> replacement) {
        String ostr = sstr;
        for (Map.Entry<String, String> entry : replacement.entrySet()) {
            String oldStr = entry.getKey();
            String newStr = entry.getValue();
            ostr = ostr.replace(oldStr, newStr);
        }
        return ostr;
    }

    public static String trim(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    public static String concatKey(Map<?, ?> map) {
        return HussarString.concatKey(map, ",");
    }

    public static String concatKey(Map<?, ?> map, String compart1) {
        StringBuffer sb = new StringBuffer(128);
        Iterator<?> it = map.keySet().iterator();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(compart1).append(it.next());
        }
        return sb.toString();
    }

    public static String join(String[] array, String sep) {
        StringBuffer sb = new StringBuffer(1024);
        int i = 0;
        while (i < array.length) {
            sb.append(sep);
            sb.append(array[i]);
            ++i;
        }
        if (sb.length() > 0) {
            return sb.substring(sep.length());
        }
        return sb.toString();
    }

    public static String join(int[] array, String sep) {
        StringBuffer sb = new StringBuffer(1024);
        int i = 0;
        while (i < array.length) {
            sb.append(sep);
            sb.append(array[i]);
            ++i;
        }
        if (sb.length() > 0) {
            return sb.substring(sep.length());
        }
        return sb.toString();
    }

    public static String concat(Object[] array) {
        return HussarString.concat(array, ",");
    }

    public static String concat(Object[] array, int start, int end) {
        return HussarString.concat(array, ",", start, end);
    }

    public static String concat(Object[] array, String s) {
        return HussarString.concat(array, s, 0, array.length);
    }

    public static String concat(Object[] array, String s, int start, int end) {
        StringBuffer r = new StringBuffer(array.length * 2);
        int i = start;
        while (i >= 0 && i < end && i < array.length) {
            r.append(s).append(array[i]);
            ++i;
        }
        if (r.length() >= s.length()) {
            return r.substring(s.length());
        }
        return "";
    }

    public static String concat(int[] array) {
        return HussarString.concat(array, ",");
    }

    public static String concat(int[] array, String s) {
        StringBuffer r = new StringBuffer(array.length * 2);
        int i = 0;
        while (i < array.length) {
            r.append(s).append(array[i]);
            ++i;
        }
        return r.substring(s.length());
    }

    public static String encryptStr(String arg0) {
        byte[] digesta = null;
        try {
            MessageDigest alga = MessageDigest.getInstance("MD5");
            alga.update(arg0.getBytes());
            digesta = alga.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return HussarString.byte2hex(digesta);
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            ++n;
        }
        return hs.toUpperCase();
    }

    public static String match(String sstr, String regex) {
        try {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(sstr);
            if (m.find()) {
                return m.group(m.groupCount());
            }
            return "";
        }
        catch (Exception exp) {
            return "";
        }
    }

    public static String nullToStr(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String replace(String str, String oldStr, String newStr) {
        if (str == null) {
            return null;
        }
        String repstr = str;
        if (newStr.indexOf("$") != -1) {
            while (newStr.indexOf("$") != -1) {
                newStr.replace("$", "<:s:>");
            }
            newStr.replaceAll("<:s:>", "\\\\\\\\\\$");
        }
        return repstr.replaceAll(HussarString.toUnicode(oldStr), newStr);
    }
}

