/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sdjxd.hussar.core.utils.HussarBean;
import com.sdjxd.hussar.core.utils.HussarDate;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.core.utils.IJsonAdapterFactory;
import com.sdjxd.hussar.core.utils.exception.HussarInvokeException;
import com.sdjxd.hussar.core.utils.exception.HussarMethodNotFoundException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class HussarJson {
    private static Gson gson = new GsonBuilder().registerTypeAdapterFactory(new IJsonAdapterFactory()).excludeFieldsWithoutExposeAnnotation().create();

    public static String toPureJson(Object obj) {
        Class<?> classType;
        if (obj == null) {
            return null;
        }
        if (HussarBean.isWrapClass(obj.getClass())) {
            return HussarJson.wrap2PureJson(obj);
        }
        try {
            return (String)HussarBean.invokeMethod(obj, "toPureJson", null);
        }
        catch (HussarMethodNotFoundException hussarMethodNotFoundException) {
        }
        catch (HussarInvokeException hussarInvokeException) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("{");
        Class<?> parentType = classType = obj.getClass();
        do {
            Field[] field = classType.getDeclaredFields();
            int index = 0;
            while (index < field.length) {
                sb.append(HussarJson.toPureJson(obj, field[index]));
                ++index;
            }
        } while ((classType = classType.getSuperclass()) != null && !classType.equals(parentType));
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public static Object parse(String source) {
        if (source == null || "".equals(source) || "null".equals(source)) {
            return null;
        }
        if (source.startsWith("[")) {
            return HussarJson.parseArray(JSONArray.fromObject((Object)source), null);
        }
        if (source.startsWith("{")) {
            return HussarJson.parse((JSON)JSONObject.fromObject((Object)source), null);
        }
        try {
            JSONObject json = JSONObject.fromObject((Object)("{_c:'wrap',value:" + source + "}"));
            return json.get("value");
        }
        catch (JSONException exp) {
            return source;
        }
    }

    private static String map2PureJson(Map<Object, Object> map) {
        StringBuffer sb = new StringBuffer(128);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\"").append(":").append(HussarJson.toPureJson(entry.getValue())).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.insert(0, "{");
        sb.append("}");
        return sb.toString();
    }

    private static String wrap2PureJson(Object obj) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        StringBuffer sb = new StringBuffer(128);
        Class<?> classType = obj.getClass();
        if (classType.equals(String.class) || classType.equals(StringBuffer.class)) {
            String str = classType.equals(StringBuffer.class) ? ((StringBuffer)obj).toString() : (String)obj;
            sb.append("\"");
            sb.append(HussarJson.str2PureJson(str));
            sb.append("\"");
        } else if (classType.equals(Date.class)) {
            sb.append("\"");
            sb.append(HussarDate.formatDateTime((Date)obj));
            sb.append("\"");
        } else if (classType.isArray()) {
            sb.append("[");
            int len = Array.getLength(obj);
            int index = 0;
            while (index < len) {
                sb.append(HussarJson.toPureJson(Array.get(obj, index))).append(",");
                ++index;
            }
            if (len > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
        } else if (obj instanceof List) {
            sb.append("[");
            List array = (List)obj;
            int index = 0;
            while (index < array.size()) {
                sb.append(HussarJson.toPureJson(array.get(index))).append(",");
                ++index;
            }
            if (array.size() > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
        } else if (obj instanceof Map) {
            sb.append(HussarJson.map2PureJson((Map)obj));
        } else {
            sb.append(obj);
        }
        return sb.toString();
    }

    private static String str2PureJson(String sstr) {
        if (sstr == null) {
            return "";
        }
        String ostr = HussarString.replace(sstr, "\\", "\\\\\\\\");
        ostr = HussarString.replace(ostr, "\r\n", "\\\\n");
        ostr = HussarString.replace(ostr, "\n", "\\\\n");
        ostr = HussarString.replace(ostr, "\"", "\\\\\"");
        ostr = HussarString.replace(ostr, "</", "<\\\\/");
        return ostr;
    }

    private static String toPureJson(Object obj, Field field) {
        StringBuffer sb = new StringBuffer(128);
        if (!Modifier.isStatic(field.getModifiers())) {
            sb.append(field.getName());
            sb.append(":");
            Object fieldValue = null;
            try {
                field.setAccessible(true);
                fieldValue = field.get(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fieldValue == null) {
                sb.append(fieldValue);
            } else {
                sb.append(HussarJson.toPureJson(fieldValue));
            }
            sb.append(",");
        }
        return sb.toString();
    }

    private static Object parse(JSON json, Class<?> classType) {
        if (json == null) {
            return null;
        }
        if (json instanceof JSONArray && (classType == null || classType.isArray())) {
            return HussarJson.parseArray((JSONArray)json, classType);
        }
        if (json instanceof JSONArray && classType != null && classType.getName().equals("java.util.ArrayList")) {
            ArrayList<Object> list = new ArrayList<Object>();
            JSONArray jsonArray = (JSONArray)json;
            int len = jsonArray.size();
            int index = 0;
            while (index < len) {
                list.add(HussarJson.parse(jsonArray.get(index), null));
                ++index;
            }
            return list;
        }
        if (!(json instanceof JSONObject)) {
            return null;
        }
        JSONObject jsonObject = (JSONObject)json;
        if (jsonObject.isNullObject()) {
            return null;
        }
        Object obj = null;
        String classPath = classType != null && !jsonObject.containsKey((Object)"_c") ? classType.getName() : (jsonObject.containsKey((Object)"_c") ? jsonObject.getString("_c") : "java.util.HashMap");
        if (classType != null && "".equals(classPath)) {
            classPath = classType.getName();
        }
        if ("json".equals(classPath)) {
            obj = jsonObject;
        } else if ("java.util.ArrayList".equals(classPath)) {
            ArrayList<Object> list = new ArrayList<Object>();
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            int len = jsonArray.size();
            int index = 0;
            while (index < len) {
                list.add(HussarJson.parse(jsonArray.get(index), null));
                ++index;
            }
            obj = list;
        } else if ("java.util.HashMap".equals(classPath)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equals("_c")) continue;
                map.put(key, HussarJson.parse(jsonObject.get(key), null));
            }
            obj = map;
        } else {
            Class<?> clz = classType == null ? HussarBean.getClassType(classPath) : classType;
            try {
                Method parseMethod = HussarBean.getMethod(clz, "parse", new Class[]{JSONObject.class});
                return HussarBean.invokeMethod(null, parseMethod, new Object[]{jsonObject});
            }
            catch (HussarMethodNotFoundException parseMethod) {
            }
            catch (HussarInvokeException parseMethod) {
                // empty catch block
            }
            Class<?> fieldType = null;
            obj = HussarBean.getInstance(classPath);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equals("_c")) continue;
                fieldType = HussarBean.getFieldType(obj, key);
                HussarBean.setFieldValue(obj, key, HussarJson.parse(jsonObject.get(key), fieldType));
            }
        }
        return obj;
    }

    private static Object parse(Object json, Class<?> classType) {
        if (json instanceof JSONObject && ((JSONObject)json).isNullObject()) {
            return null;
        }
        if (classType != null) {
            if (classType.isArray()) {
                return HussarJson.parseArray((JSONArray)json, classType);
            }
            if (json instanceof JSON) {
                return HussarJson.parse((JSON)json, classType);
            }
        } else {
            if (json instanceof JSONObject) {
                return HussarJson.parse((JSON)json, classType);
            }
            if (json instanceof JSONArray) {
                return HussarJson.parseArray((JSONArray)json, classType);
            }
            if (json instanceof JSONNull) {
                return null;
            }
        }
        return json;
    }

    private static Object parseArray(JSONArray jsonArray, Class<?> classType) {
        Object element;
        int i;
        int len = jsonArray.size();
        Class componentType = null;
        Object[] objArray = new Object[len];
        if (classType == null || classType.getComponentType() == null) {
            if (len > 0) {
                i = 0;
                while (i < len) {
                    objArray[i] = element = HussarJson.parse(jsonArray.get(i), classType);
                    if (element != null && !Object.class.equals(componentType)) {
                        if (componentType == null) {
                            componentType = element.getClass();
                        } else if (!componentType.equals(element.getClass())) {
                            componentType = Object.class;
                        }
                    }
                    ++i;
                }
            } else {
                componentType = Object.class;
            }
        } else {
            componentType = classType.getComponentType();
            i = 0;
            while (i < len) {
                objArray[i] = element = HussarJson.parse(jsonArray.get(i), componentType);
                ++i;
            }
        }
        Object array = Array.newInstance(componentType, len);
        i = 0;
        while (i < len) {
            Array.set(array, i, objArray[i]);
            ++i;
        }
        return array;
    }

    public static Object[] strToArray(String str) {
        Object[] array;
        Object obj = HussarJson.parse(str);
        if (obj == null) {
            array = null;
        } else if (!obj.getClass().isArray()) {
            array = (Object[])Array.newInstance(obj.getClass(), 1);
            array[0] = obj;
        } else {
            array = (Object[])obj;
        }
        return array;
    }

    public static <T> T gson_fromJson(String json, Class<T> classOfT) {
        return gson.fromJson(json, classOfT);
    }

    public static <T> T gson_fromJson(String json, Type typeOfT) {
        return gson.fromJson(json, typeOfT);
    }

    public static String gson_toJson(Object src) {
        return gson.toJson(src);
    }
}

