/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils;

import com.sdjxd.hussar.core.utils.HussarBean;
import com.sdjxd.hussar.core.utils.exception.HussarInvokeException;
import org.apache.log4j.Logger;

public class HussarHandle {
    private static Logger log = Logger.getLogger(HussarHandle.class);
    private Class carrier;
    private String methodName;
    private String name;
    public static int INVOKE_SYNC = 0;
    public static int INVOKE_ASYNC = 1;
    public static int INVOKE_EXCEPTION = 0;
    public static int INVOKE_IGNORE = 1;
    private int invokeType = 0;
    private int exception = 0;

    public HussarHandle() {
    }

    public HussarHandle(Class carrier, String methodName) {
        this();
        this.carrier = carrier;
        this.methodName = methodName;
        this.name = new StringBuffer(128).append(carrier.getName()).append(".").append(methodName).toString();
    }

    public HussarHandle(String classPath, String methodName) {
        this(HussarBean.getClassType(classPath), methodName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke(Object[] args) throws HussarInvokeException {
        Boolean ret = Boolean.FALSE;
        if (this.invokeType == INVOKE_SYNC) {
            try {
                ret = (Boolean)HussarBean.invokeMethod((Object)this.carrier, this.methodName, args);
                return ret;
            }
            catch (Exception exp) {
                if (this.exception != INVOKE_EXCEPTION) return ret;
                throw new HussarInvokeException(this.name, this.methodName, args, exp);
            }
        }
        try {
            ret = (Boolean)HussarBean.invokeMethod((Object)this.carrier, this.methodName, args);
            return ret;
        }
        catch (Exception exp) {
            if (this.exception != INVOKE_EXCEPTION) return ret;
            throw new HussarInvokeException(this.name, this.methodName, args, exp);
        }
    }

    public String getName() {
        return this.name;
    }
}

