/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class HussarDate {
    public static final String FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_TIME = "HH:mm:ss";
    private static final String[] datePattern = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss"};

    public static Calendar getCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String getCurrentDate(String pattern) {
        Date date = new Date();
        String s = HussarDate.dateToStr(date, pattern);
        return s;
    }

    public static Date parseDate(String source) {
        if (source == null || source.length() == 0) {
            return null;
        }
        Date date = null;
        int i = 0;
        while (i < datePattern.length) {
            date = HussarDate.parseDate(source, datePattern[i]);
            if (date != null) break;
            ++i;
        }
        return date;
    }

    public static Calendar parseCal(String source) {
        if (source == null || source.length() == 0) {
            return null;
        }
        Calendar date = null;
        int i = 0;
        while (i < datePattern.length) {
            date = HussarDate.parseCal(source, datePattern[i]);
            if (date != null) break;
            ++i;
        }
        return date;
    }

    public static Date parseDate(String dateStr, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = dateFormat.parse(dateStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Calendar parseCal(String dateStr, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Calendar date = Calendar.getInstance();
        try {
            date.setTime(dateFormat.parse(dateStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static int diffDate(Date end, Date start) {
        return (int)(HussarDate.getMillis(end) / 86400000L - HussarDate.getMillis(start) / 86400000L);
    }

    public static long diffSecond(Date end, Date start) {
        return (HussarDate.getMillis(end) - HussarDate.getMillis(start)) / 1000L;
    }

    private static long getMillis(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getTimeInMillis();
    }

    public static String getNow() {
        Date now = new Date();
        return HussarDate.formatDateTime(now);
    }

    public static String getNow(String pattern) {
        Date now = new Date();
        return HussarDate.formatDate(now, pattern);
    }

    public static String formatDate(String dateStr, String pattern) {
        Date date = HussarDate.parseDate(dateStr);
        return HussarDate.formatDate(date, pattern);
    }

    public static String formatTime(Date date) {
        String pattern = FORMAT_TIME;
        return HussarDate.formatDate(date, pattern);
    }

    public static String formatDate(Date date) {
        return HussarDate.formatDate(date, FORMAT_DATE);
    }

    public static String formatDateTime(Date date) {
        return HussarDate.formatDate(date, FORMAT_DATETIME);
    }

    public static String formatDateTime(Calendar cal) {
        if (cal == null) {
            return "";
        }
        return HussarDate.formatDate(cal.getTime(), FORMAT_DATETIME);
    }

    public static String formatDate(Date date, String pattern) {
        String dateTimePattern = pattern;
        if (date == null) {
            if (dateTimePattern.length() > 2 && dateTimePattern.substring(dateTimePattern.length() - 2).equals("_e")) {
                dateTimePattern = dateTimePattern.replaceAll("(yy|YY){1,2}", "        ");
                dateTimePattern = dateTimePattern.replaceAll("(M){1,2}", "    ");
                dateTimePattern = dateTimePattern.replaceAll("(d|D){1,2}", "    ");
                dateTimePattern = dateTimePattern.replaceAll("(h|H){1,2}", "    ");
                dateTimePattern = dateTimePattern.replaceAll("(m){1,2}", "    ");
                dateTimePattern = dateTimePattern.replaceAll("(s|S){1,2}", "    ");
                return dateTimePattern.substring(0, dateTimePattern.length() - 2);
            }
            return "";
        }
        if (dateTimePattern != null && dateTimePattern.length() > 2 && dateTimePattern.substring(dateTimePattern.length() - 2).equals("_e")) {
            dateTimePattern = dateTimePattern.substring(0, dateTimePattern.length() - 2);
        }
        if (dateTimePattern == null || dateTimePattern.length() == 0) {
            return HussarDate.formatDateTime(date);
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        try {
            sdf.applyPattern(dateTimePattern);
        }
        catch (IllegalArgumentException exp) {
            sdf.applyPattern(FORMAT_DATETIME);
        }
        return sdf.format(date);
    }

    public static int getCurrYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static int getCurrMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(2) + 1;
    }

    public static String getCurrtWeekDay() {
        Date date = new Date();
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static int getCurrDay() {
        Calendar cal = Calendar.getInstance();
        return cal.get(5);
    }

    public static int getWeekOfYear(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.setTime(date);
        return c.get(3);
    }

    public static int getWeekOfYear() {
        return HussarDate.getWeekOfYear(new Date());
    }

    public static int getMaxWeekNumOfYear(int year) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, 11, 31, 23, 59, 59);
        return HussarDate.getWeekOfYear(c.getTime());
    }

    public static Date getFirstDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return HussarDate.getFirstDayOfWeek(cal.getTime());
    }

    public static Date getLastDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return HussarDate.getLastDayOfWeek(cal.getTime());
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static Date getFirstDayOfFirstWeek(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.set(year, month, 1);
        c.set(8, 1);
        c.set(7, 2);
        return c.getTime();
    }

    public static Date getYesterday() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(5, c.get(5) - 1);
        Date date = c.getTime();
        return date;
    }

    public static Date getTomorrow() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(5, c.get(5) + 1);
        Date date = c.getTime();
        return date;
    }

    public static Date getPreMonth(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        c.add(2, -1);
        return c.getTime();
    }

    public static int getQuarter(Date date) {
        int month = date.getMonth();
        if (month < 4) {
            return 1;
        }
        if (month < 7) {
            return 2;
        }
        if (month < 10) {
            return 3;
        }
        return 4;
    }

    public static int getDayCountByTwoDates(String strDate1, String strDate2) {
        int differ = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat(FORMAT_DATETIME);
            Date date1 = format.parse(strDate1);
            Date date2 = format.parse(strDate2);
            differ = (int)((date1.getTime() - date2.getTime()) / 86400000L);
        }
        catch (Exception e) {
            System.out.println("\u6bd4\u8f83\u4e24\u4e2a\u65e5\u671f\u76f8\u5dee\u5929\u6570\u51fa\u9519\uff1a" + e.getMessage());
            differ = -1;
        }
        return differ;
    }

    public static float getDayCountFloatByTwoDates(String strDate1, String strDate2) {
        float differ = 0.0f;
        try {
            SimpleDateFormat format = new SimpleDateFormat(FORMAT_DATETIME);
            Date date1 = format.parse(strDate1);
            Date date2 = format.parse(strDate2);
            BigDecimal b1 = new BigDecimal(String.valueOf(date1.getTime()));
            BigDecimal b2 = new BigDecimal(String.valueOf(date2.getTime()));
            double b3 = b1.subtract(b2).doubleValue();
            BigDecimal b4 = new BigDecimal(b3);
            BigDecimal b5 = new BigDecimal("86400000");
            double result = b4.divide(b5, 10, 1).doubleValue();
            differ = Float.parseFloat(String.valueOf(result));
        }
        catch (Exception e) {
            System.out.println("\u6bd4\u8f83\u4e24\u4e2a\u65e5\u671f\u76f8\u5dee\u5929\u6570\u51fa\u9519\uff1a" + e.getMessage());
            differ = -1.0f;
        }
        return differ;
    }

    public static String dateToStr(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        String pat = pattern;
        if (pat == null || pat.length() == 0) {
            pat = FORMAT_DATETIME;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pat);
        return sdf.format(date);
    }

    public static Calendar addSeconds(Calendar cal, int amount) {
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(cal.getTime());
        cal2.add(13, amount);
        return cal2;
    }
}

