/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils;

import com.sdjxd.hussar.core.utils.exception.HussarInvokeException;
import com.sdjxd.hussar.core.utils.exception.HussarMethodNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class HussarBean {
    private static Logger log = Logger.getLogger(HussarBean.class);
    private static HashMap<String, Object> cache = new HashMap();

    public static Class<?> getClassType(String classPath) {
        Class<?> classType = null;
        if (classPath != null && classPath.length() > 0) {
            try {
                classType = Class.forName(classPath);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classType;
    }

    public static <T> Class<T> getClassType(Class<T> define, String classPath) {
        Class<?> classType = null;
        if (classPath != null && classPath.length() > 0) {
            try {
                classType = Class.forName(classPath);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classType;
    }

    public static Class<?>[] getClassType(Object[] objs) {
        int argSize = objs == null ? 0 : objs.length;
        Class[] argTypes = new Class[argSize];
        int i = 0;
        while (i < argSize) {
            argTypes[i] = objs[i] == null ? null : objs[i].getClass();
            ++i;
        }
        return argTypes;
    }

    public static Method getMethod(String classPath, String methodName, Object[] arguments) throws HussarMethodNotFoundException {
        return HussarBean.getMethod(classPath, methodName, HussarBean.getClassType(arguments));
    }

    public static Method getMethod(String classPath, String methodName, Class<?>[] argTypes) throws HussarMethodNotFoundException {
        Class<?> classType = HussarBean.getClassType(classPath);
        return HussarBean.getMethod(classType, methodName, argTypes);
    }

    public static Method getMethod(Class<?> classType, String methodName, Class<?>[] argTypes) throws HussarMethodNotFoundException {
        if (classType == null || methodName == null || argTypes == null) {
            throw new HussarMethodNotFoundException(HussarMethodNotFoundException.EXPTYPE.InfoLess, classType == null ? null : classType.getName(), methodName);
        }
        Method method = null;
        ArrayList<Method> list = HussarBean.listMethod(classType, methodName, argTypes);
        if (list.size() <= 0) {
            throw new HussarMethodNotFoundException(classType.getName(), methodName, argTypes);
        }
        method = list.get(0);
        return method;
    }

    public static final Object invokeMethod(String classPath, String methodName, Object[] arguments) throws HussarInvokeException, HussarMethodNotFoundException {
        Method method = HussarBean.getMethod(classPath, methodName, arguments);
        return HussarBean.invokeMethod(null, method, arguments);
    }

    public static final Object invokeMethod(Object owner, String methodName, Object[] arguments) throws HussarInvokeException, HussarMethodNotFoundException {
        if (owner == null || methodName == null) {
            throw new HussarMethodNotFoundException(HussarMethodNotFoundException.EXPTYPE.InfoLess, owner == null ? null : owner.getClass().getName(), methodName);
        }
        Method method = HussarBean.getMethod(owner.getClass(), methodName, HussarBean.getClassType(arguments));
        return HussarBean.invokeMethod(owner, method, arguments);
    }

    public static final Object invokeMethod(Object owner, Method method, Object[] arguments) throws HussarInvokeException {
        Object ret;
        try {
            Class<?>[] types = method.getParameterTypes();
            int j = 0;
            while (j < types.length) {
                if (types[j].getName().equals("int") && arguments[j] instanceof Double) {
                    double argumentValue = (Double)arguments[j];
                    arguments[j] = (int)argumentValue;
                }
                ++j;
            }
            method.setAccessible(true);
            int modifier = method.getModifiers();
            ret = Modifier.isStatic(modifier) ? method.invoke(null, arguments) : method.invoke(owner, arguments);
        }
        catch (IllegalAccessException exp) {
            throw new HussarInvokeException(HussarInvokeException.EXPTYPE.IllegalAccess, method.getDeclaringClass().getName(), method.getName(), arguments, exp);
        }
        catch (InvocationTargetException exp) {
            throw new HussarInvokeException(HussarInvokeException.EXPTYPE.InvocationTarget, method.getDeclaringClass().getName(), method.getName(), arguments, exp);
        }
        catch (IllegalArgumentException exp) {
            throw new HussarInvokeException(HussarInvokeException.EXPTYPE.IllegalArgument, method.getDeclaringClass().getName(), method.getName(), arguments, exp);
        }
        return ret;
    }

    public static ArrayList<Method> listMethod(String classPath, String methodName, Object[] arguments) {
        Class<?> classType = HussarBean.getClassType(classPath);
        Class<?>[] argTypes = HussarBean.getClassType(arguments);
        return HussarBean.listMethod(classType, methodName, argTypes);
    }

    public static ArrayList<Method> listMethod(String classPath, String methodName, Object[] arguments, int modifier) {
        Class<?> classType = HussarBean.getClassType(classPath);
        int argSize = arguments == null ? 0 : arguments.length;
        Class[] argTypes = new Class[argSize];
        int i = 0;
        while (i < argSize) {
            argTypes[i] = arguments[i] == null ? null : arguments[i].getClass();
            ++i;
        }
        return HussarBean.listMethod(classType, methodName, argTypes, modifier);
    }

    private static ArrayList<Method> listMethod(Class<?> classType, String methodName, Class<?>[] argTypes) {
        return HussarBean.listMethod(classType, methodName, argTypes, 1);
    }

    private static ArrayList<Method> listMethod(Class<?> classType, String methodName, Class<?>[] argTypes, int modifier) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methods = classType.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (!(methodName != null && !method.getName().equals(methodName) || modifier >= 0 && (method.getModifiers() & modifier) == 0)) {
                boolean isMatch;
                Class<?>[] types = method.getParameterTypes();
                if (types.length == argTypes.length) {
                    isMatch = true;
                    int j = 0;
                    while (j < types.length) {
                        if (!(argTypes[j] == null || "java.lang.Double".equals(argTypes[j].getName()) && "int".equals(types[j].getName()) || "java.lang.Boolean".equals(argTypes[j].getName()) && "boolean".equals(types[j].getName()) || types[j].isAssignableFrom(argTypes[j]))) {
                            isMatch = false;
                            break;
                        }
                        ++j;
                    }
                } else {
                    isMatch = false;
                }
                if (isMatch) {
                    list.add(method);
                }
            }
            ++i;
        }
        return list;
    }

    public static boolean isWrapClass(Class<?> clz) {
        Package pack;
        boolean wrap;
        boolean bl = wrap = clz.isPrimitive() || clz.isArray();
        if (!wrap && (pack = clz.getPackage()) != null) {
            String packageName = pack.getName();
            wrap = packageName.equals("java.lang") || packageName.equals("java.util");
        }
        return wrap;
    }

    public static String getFieldValueString(Object obj, String name) {
        Object fieldValue = HussarBean.getFieldValue(obj, name);
        if (fieldValue == null) {
            return "";
        }
        if (fieldValue instanceof String) {
            return (String)fieldValue;
        }
        return fieldValue.toString();
    }

    public static final Object getFieldValue(Object obj, String name) {
        if (obj == null) {
            return null;
        }
        for (Class<?> classType = obj.getClass(); classType != null; classType = classType.getSuperclass()) {
            try {
                Field field = classType.getField(name);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (NoSuchFieldException exp1) {
                continue;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break;
            }
        }
        return null;
    }

    public static Object getSingleInstance(String classPath) {
        Object instance = cache.get(classPath);
        if (instance == null) {
            instance = HussarBean.getInstance(classPath);
            cache.put(classPath, instance);
        }
        return instance;
    }

    public static <T> T getSingleInstance(Class<T> define) {
        String classPath = HussarBean.getName(define);
        Object instance = cache.get(classPath);
        if (instance == null) {
            instance = HussarBean.getInstance(define, null);
            cache.put(classPath, instance);
        }
        return (T)instance;
    }

    public static Object getInstance(String classPath) {
        return HussarBean.getInstance(classPath, null);
    }

    public static Object getInstance(String classPath, Object[] par) {
        Object o = null;
        if (classPath == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(classPath);
            o = HussarBean.getInstance(cls, par);
        }
        catch (ClassNotFoundException e) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage());
            log.error((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage()));
        }
        catch (Exception e) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage());
        }
        return o;
    }

    public static <T> T getInstance(Class<T> define, Object[] par) {
        String classPath = null;
        Object o = null;
        if (define == null) {
            return null;
        }
        try {
            classPath = HussarBean.getName(define);
            Constructor<Object> con = null;
            if (par == null) {
                Constructor<?>[] constructors = define.getDeclaredConstructors();
                int i = 0;
                while (i < constructors.length) {
                    con = constructors[i];
                    Class<?>[] parTypes = con.getParameterTypes();
                    if (parTypes != null && parTypes.length != 0) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                Class[] parTypes = new Class[par.length];
                int i = 0;
                while (i < par.length) {
                    parTypes[i] = par[i].getClass();
                    if (parTypes[i] == Integer.class) {
                        parTypes[i] = Integer.TYPE;
                    }
                    ++i;
                }
                con = define.getDeclaredConstructor(parTypes);
            }
            if (con != null) {
                con.setAccessible(true);
                o = con.newInstance(par);
            }
        }
        catch (NoSuchMethodException exp) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + exp.getMessage());
            log.debug((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + exp.getMessage()));
        }
        catch (Exception exp) {
            System.out.println("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + exp.getMessage());
            log.debug((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + exp.getMessage()));
        }
        return (T)o;
    }

    public static String getName(Class<?> define) {
        if (define != null) {
            return define.getName();
        }
        return null;
    }

    public static boolean isExist(String classPath) {
        boolean exist = false;
        if (classPath != null) {
            try {
                Class<?> cls = Class.forName(classPath);
                exist = true;
            }
            catch (ClassNotFoundException e) {
                exist = false;
            }
            catch (Exception e) {
                log.error((Object)("\u53c2\u6570:" + classPath + "\u5f02\u5e38:" + e.getMessage()));
            }
        }
        return exist;
    }

    public static final Class<?> getFieldType(Object obj, String name) {
        if (obj == null) {
            return null;
        }
        for (Class<?> classType = obj.getClass(); classType != null; classType = classType.getSuperclass()) {
            try {
                Field field = classType.getDeclaredField(name);
                field.setAccessible(true);
                return field.getType();
            }
            catch (NoSuchFieldException exp1) {
                continue;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break;
            }
        }
        return null;
    }

    public static final void setFieldValue(Object obj, String name, Object value) {
        Class<?> classType = obj.getClass();
        Field field = null;
        do {
            try {
                field = classType.getDeclaredField(name);
                field.setAccessible(true);
                field.set(obj, value);
                break;
            }
            catch (NoSuchFieldException exp1) {
                classType = classType.getSuperclass();
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break;
            }
        } while (classType != null);
    }
}

