/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.log4j.Logger;

public class Guid {
    private final Logger logger = Logger.getLogger(Guid.class);
    private String valueBeforeMD5 = "";
    private String valueAfterMD5 = "";
    private static Random myRand;
    private static SecureRandom mySecureRand;
    private static String s_id;
    private static final int PAD_BELOW = 16;
    private static final int TWO_BYTES = 255;

    static {
        mySecureRand = new SecureRandom();
        long secureInitializer = mySecureRand.nextLong();
        myRand = new Random(secureInitializer);
        try {
            s_id = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Guid() {
        this.getRandomGUID(false);
    }

    private void getRandomGUID(boolean secure) {
        MessageDigest md5 = null;
        StringBuffer sbValueBeforeMD5 = new StringBuffer(128);
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)("Error: " + e));
        }
        try {
            long time = System.currentTimeMillis();
            long rand = 0L;
            rand = secure ? mySecureRand.nextLong() : myRand.nextLong();
            sbValueBeforeMD5.append(s_id);
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(time));
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(rand));
            this.valueBeforeMD5 = sbValueBeforeMD5.toString();
            md5.update(this.valueBeforeMD5.getBytes());
            byte[] array = md5.digest();
            StringBuffer sb = new StringBuffer(32);
            int j = 0;
            while (j < array.length) {
                int b = array[j] & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
                ++j;
            }
            this.valueAfterMD5 = sb.toString();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error:" + e));
        }
    }

    private String toStandardString() {
        String raw = this.valueAfterMD5.toUpperCase();
        StringBuffer sb = new StringBuffer(64);
        sb.append(raw.substring(0, 8));
        sb.append("-");
        sb.append(raw.substring(8, 12));
        sb.append("-");
        sb.append(raw.substring(12, 16));
        sb.append("-");
        sb.append(raw.substring(16, 20));
        sb.append("-");
        sb.append(raw.substring(20));
        return sb.toString();
    }

    public static String create() {
        return Guid.create(true);
    }

    public static String create(boolean standard) {
        Guid myGUID = new Guid();
        if (standard) {
            return myGUID.toStandardString();
        }
        return myGUID.valueAfterMD5.toUpperCase();
    }
}

