/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.utils;

import com.sdjxd.hussar.core.base72.Global;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class FileTools {
    public static String getFileAbsolutePath(String filePath) throws Exception {
        String path = String.valueOf(Global.getRealPath().replace("\\", "/")) + filePath;
        return path;
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        int i = 0;
        while (i < tempList.length) {
            temp = path.endsWith(File.separator) ? new File(String.valueOf(path) + tempList[i]) : new File(String.valueOf(path) + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (temp.isDirectory()) {
                FileTools.delAllFile(String.valueOf(path) + "/" + tempList[i]);
                FileTools.delFolder(String.valueOf(path) + "/" + tempList[i]);
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public static void delFolder(String folderPath) {
        try {
            FileTools.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeResult(String tempXml, String filePath, String encode) {
        String dir;
        File root;
        int dirLength = filePath.lastIndexOf("/");
        if (dirLength > 0 && !(root = new File(dir = filePath.substring(0, dirLength))).exists()) {
            root.mkdirs();
        }
        try {
            ByteArrayInputStream stringInputStream = new ByteArrayInputStream(tempXml.getBytes(encode));
            BufferedInputStream br = new BufferedInputStream(stringInputStream);
            FileOutputStream out = new FileOutputStream(new File(filePath));
            int chByte = br.read();
            while (chByte != -1) {
                out.write(chByte);
                chByte = br.read();
            }
            stringInputStream.close();
            out.close();
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Document readFile(String fileName) {
        File aFile = new File(fileName);
        Document doc = null;
        try {
            FileInputStream fin = new FileInputStream(aFile);
            SAXReader reader = new SAXReader();
            doc = reader.read((InputStream)fin);
            fin.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return doc;
    }

    public static String getFilePathByOSType(String filePath) {
        return filePath.replace("\\", File.separator);
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        finally {
            if (inBuff != null) {
                inBuff.close();
            }
            if (outBuff != null) {
                outBuff.close();
            }
        }
    }
}

