/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.permit72.service.support;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.base72.bo.Context;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.permit72.exception.LoginException;
import com.sdjxd.hussar.core.permit72.service.IUserService;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.StringTool;
import java.util.Calendar;
import java.util.Hashtable;

public class UserService
implements IUserService {
    private static ThreadLocal currentCoreUser = new ThreadLocal();
    private final String CUR_USER_SESSION_KEY = "_HUSSARUSER";
    private int allLoginCount = 0;
    private Hashtable<String, Integer> loginCountMap = new Hashtable();
    private Hashtable<String, Integer> failedCountMap = new Hashtable();
    private Hashtable<String, Calendar> failedTimeMap = new Hashtable();

    protected UserService() {
    }

    @Override
    public IUserBo load(String userId) throws Exception {
        return this.load(Const.Permit.User.ID_TYPE.USERID, userId);
    }

    @Override
    public IUserBo load(Const.Permit.User.ID_TYPE idType, String userId) throws Exception {
        IUserBo user = Factory.getBo(Const.LAYER.CORE, IUserBo.class);
        user.init(idType, userId);
        return user;
    }

    public static void setCurrentUser(String userId) {
        if (StringTool.isEmpty((String)userId)) {
            currentCoreUser.remove();
        } else {
            currentCoreUser.set(userId);
        }
    }

    @Override
    public IUserBo getCurrentUser() throws Exception {
        IUserBo user = null;
        String userId = (String)currentCoreUser.get();
        if (StringTool.isEmpty((String)userId)) {
            if (Global.getContext() != null) {
                user = (IUserBo)Global.getContext().getSession("_HUSSARUSER");
            }
        } else {
            user = this.load(userId);
        }
        return user;
    }

    @Override
    public boolean register(IUserBo user) throws Exception {
        if (Global.getContext() != null) {
            Global.getContext().setSession("_HUSSARUSER", user);
            return true;
        }
        return false;
    }

    @Override
    public boolean unregister() {
        if (Global.getContext() != null) {
            Global.getContext().setSession("_HUSSARUSER", null);
            return true;
        }
        return false;
    }

    @Override
    public boolean login(IUserBo user, String password) throws Exception {
        boolean success = false;
        if (user.login(password)) {
            this.register(user);
            success = true;
            User.loginNoPass((String)user.getCode());
        }
        return success;
    }

    public boolean validate(IUserBo user, String password) throws LoginException {
        boolean result = false;
        int maxLoginCount = Global.getParamService().getParamInt("usmaxsession");
        int userMaxLogin = Global.getParamService().getParamInt("ususermaxsession");
        if (maxLoginCount >= 0 && this.allLoginCount >= maxLoginCount) {
            throw new LoginException(LoginException.ALLLOGINUPPER);
        }
        if (userMaxLogin >= 0 && this.loginCountMap.contains(user.getId()) && this.loginCountMap.get(user.getId()) >= userMaxLogin) {
            throw new LoginException(LoginException.CURLOGINUPPER);
        }
        int maxTryLogin = Global.getParamService().getParamInt("pwmaxfail");
        int failedCount = 0;
        if (this.failedCountMap.contains(user.getId())) {
            failedCount = this.failedCountMap.get(user.getId());
        }
        if (maxTryLogin > 0) {
            int banMinute = Global.getParamService().getParamInt("pwbanminute");
            Calendar banCal = Calendar.getInstance();
            banCal.add(12, -banMinute);
            if (failedCount >= maxTryLogin && this.failedTimeMap.get(user.getId()).after(banCal)) {
                throw new LoginException(LoginException.FAILEDUPPER);
            }
        }
        try {
            user.validate(password);
        }
        catch (LoginException validateExp) {
            if (validateExp.getType().equals(LoginException.WRONG)) {
                this.failedCountMap.put(user.getId(), failedCount);
            }
            throw validateExp;
        }
        int loginCount = 1;
        if (this.loginCountMap.contains(user.getId())) {
            loginCount += this.loginCountMap.get(user.getId()).intValue();
        }
        this.loginCountMap.put(user.getId(), loginCount);
        ++this.allLoginCount;
        result = true;
        Context context = Global.getContext();
        Global.log(user.getId(), "\u7528\u6237\u767b\u9646", "", "\u767b\u9646\u6210\u529f", Const.LOGTYPE.LOGIN, context.getRemoteAddr());
        return result;
    }

    @Override
    public void logout(IUserBo user) {
        this.unregister();
    }

    @Override
    public void changePasswd(IUserBo user, String oldPassword, String newPassword) throws LoginException {
        user.changePasswd(oldPassword, newPassword);
    }
}

