/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.permit72.service.support;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.permit72.IPermitController;
import com.sdjxd.hussar.core.permit72.bo.ILimitGroupBo;
import com.sdjxd.hussar.core.permit72.bo.IRoleBo;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.permit72.service.ILimitGroupService;
import com.sdjxd.hussar.core.permit72.service.IUserService;
import java.util.ArrayList;
import java.util.HashMap;

public class PermitController
implements IPermitController {
    @Override
    public IUserBo getUserBo(String userId) throws Exception {
        IUserBo user = Factory.getBo(Const.LAYER.CORE, IUserBo.class);
        user.init(Const.Permit.User.ID_TYPE.USERID, userId);
        return user;
    }

    @Override
    public IUserBo getUserBo(Const.Permit.User.ID_TYPE idType, String userId) throws Exception {
        IUserBo user = Factory.getService(Const.LAYER.CORE, IUserBo.class);
        user.init(idType, userId);
        return user;
    }

    @Override
    public boolean validate(Const.Permit.User.ID_TYPE idType, String userId, String password) throws Exception {
        IUserBo user = Factory.getService(Const.LAYER.CORE, IUserBo.class);
        user.init(idType, userId);
        if (user != null) {
            return user.validate(password);
        }
        return false;
    }

    @Override
    public void changePasswd(Const.Permit.User.ID_TYPE idType, String userId, String oldPassword, String newPassword) throws Exception {
        IUserService userService = Factory.getService(Const.LAYER.CORE, IUserService.class);
        IUserBo user = Factory.getBo(Const.LAYER.CORE, IUserBo.class);
        user.init(idType, userId);
        if (user != null) {
            userService.changePasswd(user, oldPassword, newPassword);
        }
    }

    @Override
    public void logout(Const.Permit.User.ID_TYPE idType, String userId) throws Exception {
        IUserService userService = Factory.getService(Const.LAYER.CORE, IUserService.class);
        IUserBo user = Factory.getService(Const.LAYER.CORE, IUserBo.class);
        user.init(idType, userId);
        userService.logout(user);
    }

    @Override
    public IUserBo getCurrentUser() throws Exception {
        IUserService userService = Factory.getService(Const.LAYER.CORE, IUserService.class);
        return userService.getCurrentUser();
    }

    @Override
    public boolean login(Const.Permit.User.ID_TYPE idType, String userId, String password) throws Exception {
        IUserService userService = Factory.getService(Const.LAYER.CORE, IUserService.class);
        IUserBo user = Factory.getService(Const.LAYER.CORE, IUserBo.class);
        user.init(idType, userId);
        return userService.login(user, password);
    }

    @Override
    public IRoleBo getRoleBo(String roleId) throws Exception {
        IRoleBo role = Factory.getService(Const.LAYER.CORE, IRoleBo.class);
        role.init(roleId);
        return role;
    }

    @Override
    public ILimitGroupBo getLimitGroup(String groupId) throws Exception {
        ILimitGroupService groupService = Factory.getService(Const.LAYER.CORE, ILimitGroupService.class);
        ILimitGroupBo group = groupService.load(groupId);
        return group;
    }

    @Override
    public ArrayList<ILimitGroupBo> getLimitGroupByUser(String userId) throws Exception {
        ILimitGroupService groupService = Factory.getService(Const.LAYER.CORE, ILimitGroupService.class);
        ArrayList<ILimitGroupBo> groups = groupService.getUserLimitGroup(userId);
        return groups;
    }

    public HashMap<String, ILimitGroupBo> getLimitGroupByPattern(String patternId) throws Exception {
        ILimitGroupService groupService = Factory.getService(Const.LAYER.CORE, ILimitGroupService.class);
        HashMap<String, ILimitGroupBo> groups = groupService.getPatternLimitGroup(patternId);
        return groups;
    }

    @Override
    public ArrayList<ILimitGroupBo> getLimitGroup(String userId, String patternId) throws Exception {
        ILimitGroupService groupService = Factory.getService(Const.LAYER.CORE, ILimitGroupService.class);
        ArrayList<ILimitGroupBo> groups = groupService.getLimitGroup(userId, patternId);
        return groups;
    }

    @Override
    public ArrayList<ILimitGroupBo> getLimitGroupByScene(String userId, String patternId) throws Exception {
        ILimitGroupService groupService = Factory.getService(Const.LAYER.CORE, ILimitGroupService.class);
        ArrayList<ILimitGroupBo> groups = groupService.getLimitGroupByScene(userId, patternId);
        return groups;
    }

    @Override
    public ArrayList<String> getLimitGroupIdByScene(String userId, String patternId) throws Exception {
        ILimitGroupService groupService = Factory.getService(Const.LAYER.CORE, ILimitGroupService.class);
        ArrayList<String> groups = groupService.getLimitGroupIdByScene(userId, patternId);
        return groups;
    }

    @Override
    public HashMap<String, ILimitGroupBo> getLimitGroupMapByScene(String userId, String patternId) throws Exception {
        ILimitGroupService groupService = Factory.getService(Const.LAYER.CORE, ILimitGroupService.class);
        ArrayList<ILimitGroupBo> groups = groupService.getLimitGroupByScene(userId, patternId);
        HashMap<String, ILimitGroupBo> map = new HashMap<String, ILimitGroupBo>();
        int i = 0;
        while (i < groups.size()) {
            map.put(groups.get(i).getId(), groups.get(i));
            ++i;
        }
        return map;
    }
}

