/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.permit72.service.support;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.permit72.bo.ILimitGroupBo;
import com.sdjxd.hussar.core.permit72.bo.ILimitItem;
import com.sdjxd.hussar.core.permit72.bo.ILimitValue;
import com.sdjxd.hussar.core.permit72.dao.LimitGroupDao;
import com.sdjxd.hussar.core.permit72.po.LimitGroupPo;
import com.sdjxd.hussar.core.permit72.po.LimitItemPo;
import com.sdjxd.hussar.core.permit72.po.LimitValuePo;
import com.sdjxd.hussar.core.permit72.service.ILimitGroupService;
import com.sdjxd.hussar.core.permit72.service.ILimitItemService;
import com.sdjxd.hussar.core.permit72.service.ILimitValueService;
import java.util.ArrayList;
import java.util.HashMap;

public class LimitGroupService
implements ILimitGroupService {
    private LimitGroupService() {
    }

    @Override
    public ILimitGroupBo load(String limitGroupId) throws Exception {
        ILimitItemService limitItemService = Factory.getService(Const.LAYER.CORE, ILimitItemService.class);
        ILimitValueService limitValueService = Factory.getService(Const.LAYER.CORE, ILimitValueService.class);
        LimitGroupDao dao = Factory.getDao(LimitGroupDao.class);
        LimitGroupPo po = dao.getLimitGroup(limitGroupId);
        ILimitGroupBo limitGroup = null;
        if (po != null) {
            limitGroup = Factory.getBo(Const.LAYER.CORE, ILimitGroupBo.class);
            limitGroup.init(po);
            ArrayList<LimitItemPo> limitItemPos = dao.getLimitItem(limitGroup.getId());
            HashMap<String, ArrayList<LimitValuePo>> allLimitValuePos = dao.getLimitValue(limitGroup.getId());
            int i = 0;
            while (i < limitItemPos.size()) {
                ILimitItem item = limitItemService.load(limitItemPos.get(i));
                ArrayList<LimitValuePo> limitValuePos = allLimitValuePos.get(item.getItemId());
                int k = 0;
                while (k < limitValuePos.size()) {
                    ILimitValue limitValue = limitValueService.load(limitValuePos.get(k));
                    item.addLimitValue(limitValue);
                    ++k;
                }
                limitGroup.addItem(item);
                ++i;
            }
        }
        return limitGroup;
    }

    @Override
    public ArrayList<ILimitGroupBo> getUserLimitGroup(String userId) throws Exception {
        ArrayList<ILimitGroupBo> groups = new ArrayList<ILimitGroupBo>();
        ILimitItemService limitItemService = Factory.getService(Const.LAYER.CORE, ILimitItemService.class);
        ILimitValueService limitValueService = Factory.getService(Const.LAYER.CORE, ILimitValueService.class);
        LimitGroupDao groupDao = Factory.getService(Const.LAYER.CORE, LimitGroupDao.class);
        ArrayList<LimitGroupPo> pos = groupDao.getLimitGroupByUser(userId);
        HashMap<String, ArrayList<LimitItemPo>> allPos = groupDao.getLimitItemByUser(userId);
        HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> allLimitValuePos = groupDao.getLimitValueByUser(userId);
        int i = 0;
        while (i < pos.size()) {
            LimitGroupPo po = pos.get(i);
            ILimitGroupBo bo = Factory.getBo(Const.LAYER.CORE, ILimitGroupBo.class);
            bo.init(po);
            ArrayList<LimitItemPo> itemPos = allPos.get(po.getId());
            HashMap<String, ArrayList<LimitValuePo>> itemLimitValuePos = allLimitValuePos.get(po.getId());
            int j = 0;
            while (j < itemPos.size()) {
                ILimitItem item = limitItemService.load(itemPos.get(j));
                bo.addItem(item);
                ArrayList<LimitValuePo> limitValuePos = itemLimitValuePos.get(item.getItemId());
                int k = 0;
                while (k < limitValuePos.size()) {
                    ILimitValue limitValue = limitValueService.load(limitValuePos.get(k));
                    item.addLimitValue(limitValue);
                    ++k;
                }
                groups.add(bo);
                ++j;
            }
            ++i;
        }
        return groups;
    }

    @Override
    public HashMap<String, ILimitGroupBo> getPatternLimitGroup(String patternId) throws Exception {
        HashMap<String, ILimitGroupBo> map = new HashMap<String, ILimitGroupBo>();
        ArrayList<ILimitGroupBo> groups = new ArrayList<ILimitGroupBo>();
        ILimitItemService limitItemService = Factory.getService(Const.LAYER.CORE, ILimitItemService.class);
        ILimitValueService limitValueService = Factory.getService(Const.LAYER.CORE, ILimitValueService.class);
        LimitGroupDao groupDao = Factory.getService(Const.LAYER.CORE, LimitGroupDao.class);
        ArrayList<LimitGroupPo> pos = groupDao.getLimitGroupByPattern(patternId);
        HashMap<String, ArrayList<LimitItemPo>> allPos = groupDao.getLimitItemByPattern(patternId);
        HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> allLimitValuePos = groupDao.getLimitValueByPattern(patternId);
        int i = 0;
        while (i < pos.size()) {
            LimitGroupPo po = pos.get(i);
            ILimitGroupBo bo = Factory.getBo(Const.LAYER.CORE, ILimitGroupBo.class);
            bo.init(po);
            ArrayList<LimitItemPo> itemPos = allPos.get(po.getId());
            HashMap<String, ArrayList<LimitValuePo>> itemLimitValuePos = allLimitValuePos.get(po.getId());
            int j = 0;
            while (j < itemPos.size()) {
                ILimitItem item = limitItemService.load(itemPos.get(j));
                if (patternId.equals(item.getEntityPatternId())) {
                    ArrayList<LimitValuePo> limitValuePos;
                    bo.addItem(item);
                    if (itemLimitValuePos != null && (limitValuePos = itemLimitValuePos.get(item.getItemId())) != null) {
                        int k = 0;
                        while (k < limitValuePos.size()) {
                            ILimitValue limitValue = limitValueService.load(limitValuePos.get(k));
                            item.addLimitValue(limitValue);
                            ++k;
                        }
                    }
                    groups.add(bo);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < groups.size()) {
            map.put(((ILimitGroupBo)groups.get(i)).getId(), (ILimitGroupBo)groups.get(i));
            ++i;
        }
        return map;
    }

    @Override
    public ArrayList<ILimitGroupBo> getLimitGroup(String userId, String patternId) throws Exception {
        ArrayList<ILimitGroupBo> groups = new ArrayList<ILimitGroupBo>();
        ILimitItemService limitItemService = Factory.getService(Const.LAYER.CORE, ILimitItemService.class);
        ILimitValueService limitValueService = Factory.getService(Const.LAYER.CORE, ILimitValueService.class);
        LimitGroupDao groupDao = Factory.getService(Const.LAYER.CORE, LimitGroupDao.class);
        ArrayList<LimitGroupPo> pos = groupDao.getLimitGroup(userId, patternId);
        HashMap<String, ArrayList<LimitItemPo>> allPos = groupDao.getLimitItem(userId, patternId);
        HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> allLimitValuePos = groupDao.getLimitValue(userId, patternId);
        int i = 0;
        while (i < pos.size()) {
            LimitGroupPo po = pos.get(i);
            ILimitGroupBo bo = Factory.getBo(Const.LAYER.CORE, ILimitGroupBo.class);
            bo.init(po);
            ArrayList<LimitItemPo> itemPos = allPos.get(po.getId());
            HashMap<String, ArrayList<LimitValuePo>> itemLimitValuePos = allLimitValuePos.get(po.getId());
            int j = 0;
            while (j < itemPos.size()) {
                ILimitItem item = limitItemService.load(itemPos.get(j));
                if (patternId.equals(item.getEntityPatternId())) {
                    bo.addItem(item);
                    ArrayList<LimitValuePo> limitValuePos = itemLimitValuePos.get(item.getItemId());
                    int k = 0;
                    while (k < limitValuePos.size()) {
                        ILimitValue limitValue = limitValueService.load(limitValuePos.get(k));
                        item.addLimitValue(limitValue);
                        ++k;
                    }
                    groups.add(bo);
                }
                ++j;
            }
            ++i;
        }
        return groups;
    }

    @Override
    public ArrayList<ILimitGroupBo> getLimitGroupByScene(String userId, String patternId) throws Exception {
        ArrayList<ILimitGroupBo> groups = new ArrayList<ILimitGroupBo>();
        ILimitItemService limitItemService = Factory.getService(Const.LAYER.CORE, ILimitItemService.class);
        ILimitValueService limitValueService = Factory.getService(Const.LAYER.CORE, ILimitValueService.class);
        LimitGroupDao groupDao = Factory.getService(Const.LAYER.CORE, LimitGroupDao.class);
        ArrayList<LimitGroupPo> pos = groupDao.getLimitGroupByScene(userId, patternId);
        HashMap<String, ArrayList<LimitItemPo>> allPos = groupDao.getLimitItemByScene(userId, patternId);
        HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> allLimitValuePos = groupDao.getLimitValueByScene(userId, patternId);
        int i = 0;
        while (i < pos.size()) {
            LimitGroupPo po = pos.get(i);
            ILimitGroupBo bo = Factory.getBo(Const.LAYER.CORE, ILimitGroupBo.class);
            groups.add(bo);
            bo.init(po);
            ArrayList<LimitItemPo> itemPos = allPos.get(po.getId());
            HashMap<String, ArrayList<LimitValuePo>> itemLimitValuePos = allLimitValuePos.get(po.getId());
            int j = 0;
            while (j < itemPos.size()) {
                ILimitItem item = limitItemService.load(itemPos.get(j));
                if (patternId.equals(item.getEntityPatternId())) {
                    bo.addItem(item);
                    ArrayList<LimitValuePo> limitValuePos = itemLimitValuePos.get(item.getItemId());
                    if (limitValuePos != null) {
                        int k = 0;
                        while (k < limitValuePos.size()) {
                            ILimitValue limitValue = limitValueService.load(limitValuePos.get(k));
                            item.addLimitValue(limitValue);
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return groups;
    }

    @Override
    public ArrayList<String> getLimitGroupIdByScene(String userId, String patternId) throws Exception {
        ArrayList<ILimitGroupBo> allGroups = this.getLimitGroupByScene(userId, patternId);
        ArrayList<String> enableGroupIds = new ArrayList<String>();
        int i = 0;
        while (i < allGroups.size()) {
            ILimitGroupBo group = allGroups.get(i);
            enableGroupIds.add(group.getId());
            ++i;
        }
        return enableGroupIds;
    }
}

