/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.permit72.dao.support.sql;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.permit72.dao.LimitGroupDao;
import com.sdjxd.hussar.core.permit72.po.LimitGroupPo;
import com.sdjxd.hussar.core.permit72.po.LimitItemPo;
import com.sdjxd.hussar.core.permit72.po.LimitValuePo;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.tool.StringTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class LimitGroupDaoImpl
implements LimitGroupDao {
    private Logger daoLogger = Logger.getLogger(LimitGroupDaoImpl.class);

    private LimitGroupDaoImpl() {
    }

    @Override
    public LimitGroupPo getLimitGroup(String limitGroupId) throws SQLException {
        LimitGroupPo po = null;
        StringBuffer sql = new StringBuffer(128);
        sql.append("SELECT PG.MODULEID, PG.GROUPNAME, PG.GROUPSCENE ");
        sql.append("FROM [S].JXD7_QX_PERMITGROUP PG WHERE ");
        sql.append("PG.GROUPID = ?");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{limitGroupId});
            if (rowSet.next()) {
                po = new LimitGroupPo();
                po.setId(limitGroupId);
                po.setByName(limitGroupId);
                po.setName(rowSet.getString("GROUPNAME"));
                po.setModuleId(rowSet.getString("MODULEID"));
                po.setScene(rowSet.getString("GROUPSCENE"));
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u6743\u9650\u7ec4\u7f16\u7801\u83b7\u53d6\u6743\u9650\u7ec4\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u6743\u9650\u7ec4\u7f16\u7801\u4e3a\uff1a" + limitGroupId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return po;
    }

    @Override
    public ArrayList<LimitItemPo> getLimitItem(String limitGroupId) throws SQLException {
        LimitItemPo po = null;
        ArrayList<LimitItemPo> list = new ArrayList<LimitItemPo>();
        StringBuffer sql = new StringBuffer(128);
        sql.append("SELECT PI.ITEMID, PI.ITEMNAME, PI.PATTERNID, PI.ITEMTYPE ");
        sql.append("FROM [S].JXD7_QX_PERMITITEM PI WHERE ");
        sql.append("PI.GROUPID = ?");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{limitGroupId});
            while (rowSet.next()) {
                po = new LimitItemPo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setItemName(rowSet.getString("ITEMNAME"));
                po.setGroupId(limitGroupId);
                po.setEntityPatternId(rowSet.getString("PATTERNID"));
                po.setLimitType(Const.Permit.LimitType.values()[rowSet.getInt("ITEMTYPE")]);
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u6743\u9650\u7ec4\u7f16\u7801\u83b7\u53d6\u6743\u9650\u9879\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u6743\u9650\u7ec4\u7f16\u7801\u4e3a\uff1a" + limitGroupId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return list;
    }

    @Override
    public HashMap<String, ArrayList<LimitValuePo>> getLimitValue(String limitGroupId) throws SQLException {
        HashMap<String, ArrayList<LimitValuePo>> map = new HashMap<String, ArrayList<LimitValuePo>>();
        ArrayList<LimitValuePo> list = null;
        LimitValuePo po = null;
        String lastItemId = null;
        StringBuffer sql = new StringBuffer(128);
        sql.append("SELECT PI.GROUPID, PV.ITEMID, PV.ITEMPROBYNAME, PV.DSCONDITION, PV.PERMITVALUE, PV.CHILDRENPERMIT ");
        sql.append("FROM [S].JXD7_QX_PERMITVALUE PV, [S].JXD7_QX_PERMITITEM PI WHERE ");
        sql.append("PV.ITEMID = PI.ITEMID AND PI.GROUPID = ? ORDER BY PV.ITEMID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{limitGroupId});
            while (rowSet.next()) {
                po = new LimitValuePo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setPropertyByName(rowSet.getString("ITEMPROBYNAME"));
                po.setDsCondition(rowSet.getString("DSCONDITION"));
                po.setLimit(Const.Permit.Limit.values()[rowSet.getInt("PERMITVALUE")]);
                String strChildrenLimit = rowSet.getString("CHILDRENPERMIT");
                if (!HussarString.isEmpty(strChildrenLimit) && !"[]".equals(strChildrenLimit)) {
                    String[][] children = (String[][])StringTool.strToArray((String)strChildrenLimit);
                    ArrayList<LimitValuePo> childList = new ArrayList<LimitValuePo>();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            LimitValuePo childPo = new LimitValuePo();
                            childPo.setPropertyByName(children[i][0]);
                            childPo.setLimit(Const.Permit.Limit.values()[Integer.parseInt(children[i][1])]);
                            childList.add(childPo);
                            ++i;
                        }
                    }
                    po.setChildrenLimit(childList);
                }
                if (list == null || !po.getItemId().equals(lastItemId)) {
                    list = new ArrayList<LimitValuePo>();
                    lastItemId = po.getItemId();
                    map.put(lastItemId, list);
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u6743\u9650\u7ec4\u7f16\u7801\u83b7\u53d6\u6743\u9650\u503c\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u6743\u9650\u7ec4\u7f16\u7801\u4e3a\uff1a" + limitGroupId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return map;
    }

    @Override
    public ArrayList<LimitGroupPo> getLimitGroupByUser(String userId) throws Exception {
        ArrayList<LimitGroupPo> list = new ArrayList<LimitGroupPo>();
        LimitGroupPo po = null;
        StringBuffer sql = new StringBuffer(228);
        sql.append("SELECT PG.GROUPID, PG.GROUPNAME, PG.MODULEID, PG.GROUPSCENE ");
        sql.append("FROM [S].JXD7_QX_PERMITGROUP PG, [S].JXD7_QX_USERGROUP UG WHERE ");
        sql.append("PG.GROUPID = UG.GROUPID AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(")");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append(")))");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitGroupPo();
                po.setId(rowSet.getString("GROUPID"));
                po.setByName(rowSet.getString("GROUPID"));
                po.setName(rowSet.getString("GROUPNAME"));
                po.setModuleId(rowSet.getString("MODULEID"));
                po.setScene(rowSet.getString("GROUPSCENE"));
                list.add(po);
            }
        }
        catch (Exception e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u83b7\u53d6\u5236\u5b9a\u4eba\u5458\u6240\u62e5\u6709\u6743\u9650\u7ec4\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return list;
    }

    @Override
    public HashMap<String, ArrayList<LimitItemPo>> getLimitItemByUser(String userId) throws SQLException {
        HashMap<String, ArrayList<LimitItemPo>> map = new HashMap<String, ArrayList<LimitItemPo>>();
        ArrayList<LimitItemPo> list = null;
        String lastGroupId = null;
        LimitItemPo po = null;
        StringBuffer sql = new StringBuffer(228);
        sql.append("SELECT UG.USERID, PI.ITEMID, PI.ITEMNAME, PI.GROUPID, PI.PATTERNID, PI.ITEMTYPE ");
        sql.append("FROM [S].JXD7_QX_PERMITITEM PI, [S].JXD7_QX_USERGROUP UG WHERE ");
        sql.append("PI.GROUPID = UG.GROUPID AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(") ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append("))) ");
        sql.append("ORDER BY PI.GROUPID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitItemPo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setItemName(rowSet.getString("ITEMNAME"));
                po.setGroupId(rowSet.getString("GROUPID"));
                po.setEntityPatternId(rowSet.getString("PATTERNID"));
                po.setLimitType(Const.Permit.LimitType.values()[rowSet.getInt("ITEMTYPE")]);
                if (lastGroupId == null || !lastGroupId.equals(po.getGroupId())) {
                    list = new ArrayList<LimitItemPo>();
                    lastGroupId = po.getGroupId();
                    map.put(lastGroupId, list);
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u83b7\u53d6\u6743\u9650\u9879\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return map;
    }

    @Override
    public HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> getLimitValueByUser(String userId) throws SQLException {
        HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> mapAll = new HashMap<String, HashMap<String, ArrayList<LimitValuePo>>>();
        HashMap map = null;
        ArrayList<LimitValuePo> list = null;
        LimitValuePo po = null;
        String lastItemId = null;
        String lastGroupId = null;
        StringBuffer sql = new StringBuffer(228);
        sql.append("SELECT PI.GROUPID, PV.ITEMID, PV.ITEMPROBYNAME, PV.DSCONDITION, PV.PERMITVALUE, PV.CHILDRENPERMIT ");
        sql.append("FROM [S].JXD7_QX_PERMITVALUE PV, [S].JXD7_QX_PERMITITEM PI, [S].JXD7_QX_USERGROUP UG WHERE ");
        sql.append("PV.ITEMID = PI.ITEMID AND PI.GROUPID = UG.GROUPID ");
        sql.append("AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(") ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append(")))");
        sql.append("ORDER BY PI.GROUPID, PV.ITEMID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitValuePo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setPropertyByName(rowSet.getString("ITEMPROBYNAME"));
                po.setDsCondition(rowSet.getString("DSCONDITION"));
                po.setLimit(Const.Permit.Limit.values()[rowSet.getInt("PERMITVALUE")]);
                String strChildrenLimit = rowSet.getString("CHILDRENPERMIT");
                String[][] children = (String[][])StringTool.strToArray((String)strChildrenLimit);
                ArrayList<LimitValuePo> childList = new ArrayList<LimitValuePo>();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        LimitValuePo childPo = new LimitValuePo();
                        childPo.setPropertyByName(children[i][0]);
                        childPo.setLimit(Const.Permit.Limit.values()[Integer.parseInt(children[i][1])]);
                        childList.add(childPo);
                        ++i;
                    }
                }
                po.setChildrenLimit(childList);
                if (map == null || !lastGroupId.equals(rowSet.getString("GROUPID"))) {
                    map = new HashMap();
                    lastGroupId = rowSet.getString("GROUPID");
                    mapAll.put(lastGroupId, map);
                }
                if (list == null || !lastItemId.equals(po.getItemId())) {
                    list = new ArrayList<LimitValuePo>();
                    lastItemId = po.getItemId();
                    map.put(lastItemId, list);
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u83b7\u53d6\u6743\u9650\u503c\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return mapAll;
    }

    @Override
    public ArrayList<LimitGroupPo> getLimitGroupByPattern(String patternId) throws Exception {
        ArrayList<LimitGroupPo> list = new ArrayList<LimitGroupPo>();
        LimitGroupPo po = null;
        StringBuffer sql = new StringBuffer(128);
        sql.append("SELECT PG.GROUPID, PG.MODULEID, PG.GROUPNAME, PG.GROUPSCENE ");
        sql.append("FROM [S].JXD7_QX_PERMITGROUP PG, [S].JXD7_QX_PERMITITEM PI WHERE ");
        sql.append("PG.GROUPID = PI.GROUPID AND PI.PATTERNID = ?");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId});
            while (rowSet.next()) {
                po = new LimitGroupPo();
                po.setId(rowSet.getString("GROUPID"));
                po.setByName(rowSet.getString("GROUPID"));
                po.setName(rowSet.getString("GROUPNAME"));
                po.setModuleId(rowSet.getString("MODULEID"));
                po.setScene(rowSet.getString("GROUPSCENE"));
                list.add(po);
            }
        }
        catch (Exception e) {
            this.daoLogger.error((Object)("\u6839\u636e\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u6743\u9650\u503c\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return list;
    }

    @Override
    public HashMap<String, ArrayList<LimitItemPo>> getLimitItemByPattern(String patternId) throws SQLException {
        HashMap<String, ArrayList<LimitItemPo>> map = new HashMap<String, ArrayList<LimitItemPo>>();
        ArrayList<LimitItemPo> list = null;
        LimitItemPo po = null;
        String lastPatternId = null;
        StringBuffer sql = new StringBuffer(128);
        sql.append("SELECT PI.ITEMID, PI.ITEMNAME, PI.GROUPID, PI.ITEMTYPE ");
        sql.append("FROM [S].JXD7_QX_PERMITITEM PI WHERE ");
        sql.append("PI.PATTERNID = ? ORDER BY PI.GROUPID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId});
            while (rowSet.next()) {
                po = new LimitItemPo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setItemName(rowSet.getString("ITEMNAME"));
                po.setGroupId(rowSet.getString("GROUPID"));
                po.setLimitType(Const.Permit.LimitType.values()[rowSet.getInt("ITEMTYPE")]);
                po.setEntityPatternId(patternId);
                if (list == null || !lastPatternId.equals(po.getGroupId())) {
                    list = new ArrayList<LimitItemPo>();
                    lastPatternId = po.getGroupId();
                    map.put(lastPatternId, list);
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u6743\u9650\u9879\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return map;
    }

    @Override
    public HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> getLimitValueByPattern(String patternId) throws SQLException {
        HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> mapAll = new HashMap<String, HashMap<String, ArrayList<LimitValuePo>>>();
        HashMap map = null;
        ArrayList<LimitValuePo> list = null;
        LimitValuePo po = null;
        String lastItemId = null;
        String lastGroupId = null;
        StringBuffer sql = new StringBuffer(128);
        sql.append("SELECT PI.GROUPID, PV.ITEMID, PV.ITEMPROBYNAME, PV.DSCONDITION, PV.PERMITVALUE, PV.CHILDRENPERMIT ");
        sql.append("FROM [S].JXD7_QX_PERMITVALUE PV, [S].JXD7_QX_PERMITITEM PI WHERE ");
        sql.append("PV.ITEMID = PI.ITEMID AND PI.PATTERNID = ? ORDER BY PI.GROUPID, PV.ITEMID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId});
            while (rowSet.next()) {
                po = new LimitValuePo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setPropertyByName(rowSet.getString("ITEMPROBYNAME"));
                po.setDsCondition(rowSet.getString("DSCONDITION"));
                po.setLimit(Const.Permit.Limit.values()[rowSet.getInt("PERMITVALUE")]);
                String strChildrenLimit = rowSet.getString("CHILDRENPERMIT");
                if (!HussarString.isEmpty(strChildrenLimit) && !"[]".equals(strChildrenLimit)) {
                    String[][] children = (String[][])StringTool.strToArray((String)strChildrenLimit);
                    ArrayList<LimitValuePo> childList = new ArrayList<LimitValuePo>();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            LimitValuePo childPo = new LimitValuePo();
                            childPo.setPropertyByName(children[i][0]);
                            childPo.setLimit(Const.Permit.Limit.values()[Integer.parseInt(children[i][1])]);
                            childList.add(childPo);
                            ++i;
                        }
                    }
                    po.setChildrenLimit(childList);
                }
                if (map == null || !lastGroupId.equals(rowSet.getString("GROUPID"))) {
                    map = new HashMap();
                    lastGroupId = rowSet.getString("GROUPID");
                    mapAll.put(lastGroupId, map);
                }
                if (list == null || !lastItemId.equals(po.getItemId())) {
                    list = new ArrayList<LimitValuePo>();
                    lastItemId = po.getItemId();
                    map.put(lastItemId, list);
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u6743\u9650\u503c\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return mapAll;
    }

    @Override
    public ArrayList<LimitGroupPo> getLimitGroup(String userId, String patternId) throws Exception {
        ArrayList<LimitGroupPo> list = new ArrayList<LimitGroupPo>();
        LimitGroupPo po = null;
        StringBuffer sql = new StringBuffer(228);
        sql.append("SELECT PG.GROUPID, PG.MODULEID, PG.GROUPNAME, PG.GROUPSCENE ");
        sql.append("FROM [S].JXD7_QX_PERMITGROUP PG, [S].JXD7_QX_USERGROUP UG, [S].JXD7_QX_PERMITITEM PI WHERE ");
        sql.append("PI.PATTERNID = ? AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(") ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append(")))");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId, userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitGroupPo();
                po.setId(rowSet.getString("GROUPID"));
                po.setByName(rowSet.getString("GROUPID"));
                po.setModuleId(rowSet.getString("MODULEID"));
                po.setName(rowSet.getString("GROUPNAME"));
                po.setScene(rowSet.getString("GROUPSCENE"));
                list.add(po);
            }
        }
        catch (Exception e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u3001\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u6743\u9650\u7ec4\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return list;
    }

    @Override
    public HashMap<String, ArrayList<LimitItemPo>> getLimitItem(String userId, String patternId) throws SQLException {
        HashMap<String, ArrayList<LimitItemPo>> map = new HashMap<String, ArrayList<LimitItemPo>>();
        ArrayList<LimitItemPo> list = null;
        LimitItemPo po = null;
        String lastGroupId = null;
        StringBuffer sql = new StringBuffer(228);
        sql.append("SELECT PI.ITEMID, PI.ITEMNAME, PI.GROUPID, PI.PATTERNID, PI.ITEMTYPE ");
        sql.append("FROM [S].JXD7_QX_PERMITITEM PI, [S].JXD7_QX_USERGROUP UG WHERE ");
        sql.append("PI.PATTERNID = ? AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(") ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append("))) ");
        sql.append("ORDER BY PI.GROUPID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId, userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitItemPo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setItemName(rowSet.getString("ITEMNAME"));
                po.setGroupId(rowSet.getString("GROUPID"));
                po.setEntityPatternId(rowSet.getString("PATTERNID"));
                po.setLimitType(Const.Permit.LimitType.values()[rowSet.getInt("ITEMTYPE")]);
                if (list == null || !lastGroupId.equals(po.getGroupId())) {
                    list = new ArrayList<LimitItemPo>();
                    lastGroupId = po.getGroupId();
                    map.put(lastGroupId, list);
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u3001\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u6743\u9650\u9879\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return map;
    }

    @Override
    public HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> getLimitValue(String userId, String patternId) throws SQLException {
        HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> mapAll = new HashMap<String, HashMap<String, ArrayList<LimitValuePo>>>();
        HashMap map = null;
        ArrayList<LimitValuePo> list = null;
        LimitValuePo po = null;
        String lastGroupId = null;
        String lastItemId = null;
        StringBuffer sql = new StringBuffer(228);
        sql.append("SELECT PI.GROUPID, PV.ITEMID, PV.ITEMPROBYNAME, PV.DSCONDITION, PV.PERMITVALUE, PV.CHILDRENPERMIT ");
        sql.append("FROM [S].JXD7_QX_PERMITVALUE PV, [S].JXD7_QX_USERGROUP UG, [S].JXD7_QX_PERMITITEM PI WHERE ");
        sql.append("PI.PATTERNID = ? AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(") ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append(")))");
        sql.append("ORDER BY PI.GROUPID, PV.ITEMID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId, userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitValuePo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setPropertyByName(rowSet.getString("ITEMPROBYNAME"));
                po.setDsCondition(rowSet.getString("DSCONDITION"));
                po.setLimit(Const.Permit.Limit.values()[rowSet.getInt("PERMITVALUE")]);
                String strChildrenLimit = rowSet.getString("CHILDRENPERMIT");
                if (!HussarString.isEmpty(strChildrenLimit) && !"[]".equals(strChildrenLimit)) {
                    String[][] children = (String[][])StringTool.strToArray((String)strChildrenLimit);
                    ArrayList<LimitValuePo> childList = new ArrayList<LimitValuePo>();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            LimitValuePo childPo = new LimitValuePo();
                            childPo.setPropertyByName(children[i][0]);
                            childPo.setLimit(Const.Permit.Limit.values()[Integer.parseInt(children[i][1])]);
                            childList.add(childPo);
                            ++i;
                        }
                    }
                    po.setChildrenLimit(childList);
                }
                if (map == null || !lastGroupId.equals(rowSet.getString("GROUPID"))) {
                    map = new HashMap();
                    lastGroupId = rowSet.getString("GROUPID");
                    mapAll.put(lastGroupId, map);
                }
                if (list == null || !lastItemId.equals(po.getItemId())) {
                    list = new ArrayList<LimitValuePo>();
                    lastItemId = po.getItemId();
                    map.put(lastItemId, list);
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u3001\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u6743\u9650\u503c\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return mapAll;
    }

    @Override
    public ArrayList<LimitGroupPo> getLimitGroupByScene(String userId, String patternId) throws Exception {
        ArrayList<LimitGroupPo> list = new ArrayList<LimitGroupPo>();
        LimitGroupPo po = null;
        StringBuffer sql = new StringBuffer(228);
        sql.append("SELECT PG.GROUPID, PG.MODULEID, PG.GROUPNAME, PG.GROUPSCENE ");
        sql.append("FROM [S].JXD7_QX_PERMITGROUP PG, [S].JXD7_QX_PERMITITEM PI, [S].JXD7_QX_USERGROUP UG WHERE ");
        sql.append("PG.GROUPID=UG.GROUPID AND PI.GROUPID=PG.GROUPID AND PI.PATTERNID = ? AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(") ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append(")))");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId, userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitGroupPo();
                po.setId(rowSet.getString("GROUPID"));
                po.setByName(rowSet.getString("GROUPID"));
                po.setModuleId(rowSet.getString("MODULEID"));
                po.setName(rowSet.getString("GROUPNAME"));
                po.setScene(rowSet.getString("GROUPSCENE"));
                sql.setLength(0);
                if (!HussarString.isEmpty(po.getScene())) {
                    sql.append("SELECT 1 FROM [S].JXD7_QX_PERMITGROUP WHERE ");
                    sql.append(po.getScene());
                    RowSet rowSetByScene = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[0]);
                    if (!rowSetByScene.next()) continue;
                    list.add(po);
                    continue;
                }
                list.add(po);
            }
        }
        catch (Exception e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u3001\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u573a\u666f\u53ef\u7528\u6743\u9650\u7ec4\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return list;
    }

    @Override
    public HashMap<String, ArrayList<LimitItemPo>> getLimitItemByScene(String userId, String patternId) throws SQLException {
        HashMap<String, ArrayList<LimitItemPo>> map = new HashMap<String, ArrayList<LimitItemPo>>();
        ArrayList<LimitItemPo> list = null;
        LimitItemPo po = null;
        String lastGroupId = null;
        StringBuffer sql = new StringBuffer(500);
        sql.append("SELECT PG.GROUPSCENE, PI.ITEMID, PI.ITEMNAME, PI.GROUPID, PI.PATTERNID, PI.ITEMTYPE ");
        sql.append("FROM [S].JXD7_QX_PERMITGROUP PG, [S].JXD7_QX_PERMITITEM PI, [S].JXD7_QX_USERGROUP UG WHERE ");
        sql.append("PG.GROUPID=UG.GROUPID AND PI.GROUPID=PG.GROUPID AND PI.PATTERNID = ? AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(") ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append("))) ");
        sql.append("ORDER BY PI.GROUPID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId, userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitItemPo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setItemName(rowSet.getString("ITEMNAME"));
                po.setGroupId(rowSet.getString("GROUPID"));
                po.setEntityPatternId(rowSet.getString("PATTERNID"));
                po.setLimitType(Const.Permit.LimitType.values()[rowSet.getInt("ITEMTYPE")]);
                if (list == null || !lastGroupId.equals(po.getGroupId())) {
                    list = new ArrayList<LimitItemPo>();
                    lastGroupId = po.getGroupId();
                    sql.setLength(0);
                    if (!HussarString.isEmpty(rowSet.getString("GROUPSCENE"))) {
                        sql.append("SELECT 1 FROM [S].JXD7_QX_PERMITGROUP WHERE ");
                        sql.append(rowSet.getString("GROUPSCENE"));
                        RowSet rowSetByScene = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[0]);
                        if (rowSetByScene.next()) {
                            map.put(lastGroupId, list);
                        }
                    } else {
                        map.put(lastGroupId, list);
                    }
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u3001\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u573a\u666f\u53ef\u7528\u6743\u9650\u9879\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return map;
    }

    @Override
    public HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> getLimitValueByScene(String userId, String patternId) throws SQLException {
        HashMap<String, HashMap<String, ArrayList<LimitValuePo>>> mapAll = new HashMap<String, HashMap<String, ArrayList<LimitValuePo>>>();
        HashMap map = null;
        ArrayList<LimitValuePo> list = null;
        LimitValuePo po = null;
        String lastGroupId = null;
        String lastItemId = null;
        StringBuffer sql = new StringBuffer(228);
        sql.append("SELECT PG.GROUPSCENE, PI.GROUPID, PV.ITEMID, PV.ITEMPROBYNAME, PV.DSCONDITION, PV.PERMITVALUE, PV.CHILDRENPERMIT ");
        sql.append("FROM [S].JXD7_QX_PERMITGROUP PG, [S].JXD7_QX_PERMITVALUE PV, [S].JXD7_QX_USERGROUP UG, [S].JXD7_QX_PERMITITEM PI WHERE ");
        sql.append("PG.GROUPID = UG.GROUPID AND PG.GROUPID = PI.GROUPID AND PI.ITEMID = PV.ITEMID AND PI.PATTERNID = ? AND ((UG.USERID = ? AND UG.USERTYPE =").append(Const.Permit.UserType.USER.ordinal()).append(") ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE UR WHERE UR.USERID = ? AND UR.ROLEID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.ROLE.ordinal()).append(")) ");
        sql.append("OR (EXISTS(SELECT 1 FROM [S].JXD7_XT_USER U WHERE U.USERID = ? AND U.DEPTID = UG.USERID AND UG.USERTYPE = ").append(Const.Permit.UserType.DEPT.ordinal()).append(")))");
        sql.append("ORDER BY PI.GROUPID, PV.ITEMID");
        try {
            RowSet rowSet = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[]{patternId, userId, userId, userId});
            while (rowSet.next()) {
                po = new LimitValuePo();
                po.setItemId(rowSet.getString("ITEMID"));
                po.setPropertyByName(rowSet.getString("ITEMPROBYNAME"));
                po.setDsCondition(rowSet.getString("DSCONDITION"));
                po.setLimit(Const.Permit.Limit.values()[rowSet.getInt("PERMITVALUE")]);
                String strChildrenLimit = rowSet.getString("CHILDRENPERMIT");
                if (!HussarString.isEmpty(strChildrenLimit) && !"[]".equals(strChildrenLimit)) {
                    String[][] children = (String[][])StringTool.strToArray((String)strChildrenLimit);
                    ArrayList<LimitValuePo> childList = new ArrayList<LimitValuePo>();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            LimitValuePo childPo = new LimitValuePo();
                            childPo.setPropertyByName(children[i][0]);
                            childPo.setLimit(Const.Permit.Limit.values()[Integer.parseInt(children[i][1])]);
                            childList.add(childPo);
                            ++i;
                        }
                    }
                    po.setChildrenLimit(childList);
                }
                if (map == null || !lastGroupId.equals(rowSet.getString("GROUPID"))) {
                    map = new HashMap();
                    lastGroupId = rowSet.getString("GROUPID");
                    mapAll.put(lastGroupId, map);
                }
                if (list == null || !lastItemId.equals(po.getItemId())) {
                    list = new ArrayList<LimitValuePo>();
                    lastItemId = po.getItemId();
                    sql.setLength(0);
                    if (!HussarString.isEmpty(rowSet.getString("GROUPSCENE"))) {
                        sql.append("SELECT 1 FROM [S].JXD7_QX_PERMITGROUP WHERE ");
                        sql.append(rowSet.getString("GROUPSCENE"));
                        RowSet rowSetByScene = DbOper.executeQuery((String)"defaultds", (String)sql.toString(), (Object[])new String[0]);
                        if (rowSetByScene.next()) {
                            map.put(lastItemId, list);
                        }
                    } else {
                        map.put(lastItemId, list);
                    }
                }
                list.add(po);
            }
        }
        catch (SQLException e) {
            this.daoLogger.error((Object)("\u6839\u636e\u7528\u6237\u7f16\u7801\u3001\u6a21\u677f\u7f16\u7801\u83b7\u53d6\u573a\u666f\u53ef\u7528\u6743\u9650\u503c\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage() + "\n\u7528\u6237\u7f16\u7801\u4e3a\uff1a" + userId + "\n\u6a21\u677f\u7f16\u7801\u4e3a\uff1a" + patternId + "\nsql\u4e3a\uff1a" + sql));
            throw e;
        }
        return mapAll;
    }
}

