/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.permit72.bo.support;

import com.google.gson.annotations.Expose;
import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.permit72.bo.IRoleBo;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.permit72.dao.UserDao;
import com.sdjxd.hussar.core.permit72.exception.LoginException;
import com.sdjxd.hussar.core.permit72.po.RolePo;
import com.sdjxd.hussar.core.permit72.po.UserPo;
import com.sdjxd.hussar.core.permit72.service.IRoleService;
import com.sdjxd.hussar.core.permit72.service.IUserService;
import com.sdjxd.hussar.core.utils.Base64;
import com.sdjxd.pms.platform.organize.User;
import java.util.ArrayList;
import java.util.Calendar;

public class UserBo
implements IUserBo {
    protected UserDao dao = Factory.getDao(UserDao.class);
    @Expose(serialize=true, deserialize=true)
    protected String id;
    @Expose(serialize=true, deserialize=true)
    protected String name;
    @Expose(serialize=true, deserialize=true)
    protected String code;
    @Expose(serialize=true, deserialize=true)
    protected String deptId;
    @Expose(serialize=true, deserialize=true)
    protected String deptName;
    @Expose(serialize=true, deserialize=true)
    protected String compId;
    @Expose(serialize=true, deserialize=true)
    protected String compName;
    @Expose(serialize=true, deserialize=true)
    protected String password;
    private Calendar createPasswordTime;

    protected UserBo() throws Exception {
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void init(String userId) throws Exception {
        this.init(Const.Permit.User.ID_TYPE.USERID, userId);
    }

    @Override
    public void init(Const.Permit.User.ID_TYPE idType, String userId) throws Exception {
        if (Const.Permit.User.ID_TYPE.USERID == idType) {
            this.initBoyPo(this.dao.getUser(userId));
        } else if (Const.Permit.User.ID_TYPE.USERCODE == idType) {
            this.initBoyPo(this.dao.getUserByCode(userId));
        } else if (Const.Permit.User.ID_TYPE.USERCODEENCODE == idType) {
            this.initBoyPo(this.dao.getUserByCode(Base64.decode(userId)));
        } else if (Const.Permit.User.ID_TYPE.USERIDENCODE == idType) {
            this.initBoyPo(this.dao.getUser(Base64.decode(userId)));
        }
    }

    private void initBoyPo(UserPo po) {
        this.id = po.getId();
        this.name = po.getName();
        this.code = po.getCode();
        this.deptId = po.getDeptId();
        this.deptName = po.getDeptName();
        this.compId = po.getCompId();
        this.compName = po.getCompName();
        this.password = po.getPassword();
    }

    @Override
    public ArrayList<IRoleBo> getRoles() throws Exception {
        ArrayList<RolePo> rolePos = this.dao.getUserRoles(this.id);
        int size = rolePos.size();
        ArrayList<IRoleBo> roles = new ArrayList<IRoleBo>();
        IRoleService roleService = Factory.getService(Const.LAYER.CORE, IRoleService.class);
        int i = 0;
        while (i < size) {
            roles.add(roleService.load(rolePos.get(i)));
            ++i;
        }
        return roles;
    }

    public boolean equals(UserBo user) {
        if (user != null) {
            return user.equals(this.getId());
        }
        return false;
    }

    @Override
    public boolean equals(String userId) {
        if (userId != null) {
            return userId.equals(this.getId());
        }
        return false;
    }

    @Override
    public boolean validate(String password) throws LoginException {
        Calendar now = Calendar.getInstance();
        boolean result = true;
        int passwordExpires = Global.getParamService().getParamInt("pwexpires");
        if (passwordExpires > 0) {
            now.add(6, -passwordExpires);
            if (now.after(this.createPasswordTime)) {
                throw new LoginException(LoginException.EXPIRES);
            }
        }
        if (!password.equals(this.password)) {
            throw new LoginException(LoginException.WRONG);
        }
        return result;
    }

    @Override
    public void changePasswd(String oldPassword, String newPassword) throws LoginException {
        if (this.validate(oldPassword) && this.dao.changePassword(this.id, newPassword, Calendar.getInstance())) {
            this.password = newPassword;
        }
    }

    @Override
    public boolean login(String password) throws Exception {
        int i;
        boolean success = false;
        String ipLimit = Global.getParam("iplimit");
        String ipLimitDisable = Global.getParam("iplimitdisable");
        String clientIp = Global.getContext().getRemoteAddr();
        boolean bLimit = false;
        if (ipLimitDisable.length() != 0) {
            String[] ipLimitDisableList = ipLimitDisable.split(",");
            bLimit = false;
            i = 0;
            while (i < ipLimitDisableList.length) {
                if (clientIp.startsWith(ipLimitDisableList[i])) {
                    bLimit = true;
                    break;
                }
                ++i;
            }
            if (bLimit) {
                Global.log(this.id, "", "", "\u7981\u6b62\u767b\u5f55", Const.LOGTYPE.LOGIN, clientIp);
                throw new LoginException(LoginException.IPLIMIT);
            }
        }
        if (ipLimit.length() != 0) {
            String[] ipLimitList = ipLimit.split(",");
            bLimit = true;
            i = 0;
            while (i < ipLimitList.length) {
                if (clientIp.startsWith(ipLimitList[i])) {
                    bLimit = false;
                    break;
                }
                ++i;
            }
            if (bLimit) {
                Global.log(this.id, "", "", "\u7981\u6b62\u767b\u5f55", Const.LOGTYPE.LOGIN, clientIp);
                throw new LoginException(LoginException.IPLIMIT);
            }
        }
        if (this.validate(password)) {
            success = true;
        }
        return success;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDeptId() {
        return this.deptId;
    }

    @Override
    public String getDeptName() {
        return this.deptName;
    }

    @Override
    public String getCompId() {
        return this.compId;
    }

    @Override
    public String getCompName() {
        return this.compName;
    }

    @Override
    public boolean equals(IUserBo user) {
        if (user != null && this.id != null) {
            return this.id.equals(user.getId());
        }
        return false;
    }

    @Override
    public boolean checkUser() {
        boolean loginSucess = false;
        String pwd = this.password;
        try {
            this.init(Const.Permit.User.ID_TYPE.USERCODE, this.code);
            loginSucess = this.login(pwd);
            if (loginSucess) {
                IUserService userService = Factory.getService(Const.LAYER.CORE, IUserService.class);
                userService.register(this);
                User.loginNoPass((String)this.getCode());
            }
            return loginSucess;
        }
        catch (Exception e) {
            e.printStackTrace();
            return loginSucess;
        }
    }
}

