/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.service.support;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.DataCheckAttribute;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.DateTimeAttributeBo;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectComboBox;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectList;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectMenu;
import com.sdjxd.hussar.core.form72.bo.cellAttribute.cellProject.CellProjectTree;
import com.sdjxd.hussar.core.form72.dao.CellAttributeDao;
import com.sdjxd.hussar.core.form72.po.FormCellAttributePo;

public class CellAttributeServices {
    protected static CellAttributeDao dao;

    static {
        try {
            dao = Factory.getDao(CellAttributeDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getFormCellAttribute(String projectId) throws Exception {
        if (projectId == null || "".equals(projectId) || "null".equals(projectId)) {
            return null;
        }
        FormCellAttributePo AttributePo = dao.getFormCellAttributePo(projectId);
        Object attributeBo = null;
        if (AttributePo != null) {
            if (AttributePo.getProjectType() == Const.Form.AttributeType.DATETIME) {
                DateTimeAttributeBo dateTime = new DateTimeAttributeBo(AttributePo);
                attributeBo = dateTime;
            } else if (AttributePo.getProjectType() == Const.Form.AttributeType.DATACHECK) {
                DataCheckAttribute dataCheck = new DataCheckAttribute(AttributePo);
                attributeBo = dataCheck;
            } else if (AttributePo.getProjectType() == Const.Form.AttributeType.COMBOBOX) {
                CellProjectComboBox cellProjectComboBox = new CellProjectComboBox(AttributePo);
                attributeBo = cellProjectComboBox;
            } else if (AttributePo.getProjectType() == Const.Form.AttributeType.TREE) {
                CellProjectTree projectTree = new CellProjectTree(AttributePo);
                attributeBo = projectTree;
            } else if (AttributePo.getProjectType() == Const.Form.AttributeType.LIST) {
                CellProjectList projectList = new CellProjectList(AttributePo);
                attributeBo = projectList;
            } else if (AttributePo.getProjectType() == Const.Form.AttributeType.MENU) {
                CellProjectMenu projectMenu = new CellProjectMenu(AttributePo);
                attributeBo = projectMenu;
            }
        }
        return attributeBo;
    }
}

