/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.hussar.core.form72.platEntity72.bo.support;

import com.sdjxd.hussar.core.base72.Const;
import com.sdjxd.hussar.core.base72.Factory;
import com.sdjxd.hussar.core.base72.Global;
import com.sdjxd.hussar.core.form72.bo.FormCellInstanceBo;
import com.sdjxd.hussar.core.form72.platEntity72.bo.IPlatEntityPatternBo;
import com.sdjxd.hussar.core.form72.platEntity72.bo.support.PlatEntityInstanceBo;
import com.sdjxd.hussar.core.form72.platEntity72.dao.PlatEntityDao;
import com.sdjxd.hussar.core.form72.platEntity72.po.PlatEntityIndexPo;
import com.sdjxd.hussar.core.form72.platEntity72.po.PlatEntityPropertyInstancePo;
import com.sdjxd.hussar.core.permit72.IPermitController;
import com.sdjxd.hussar.core.permit72.bo.IUserBo;
import com.sdjxd.hussar.core.utils.Guid;
import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.mobile.base.AppConfig;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.User;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PlatEntityPatternBo
implements IPlatEntityPatternBo {
    protected static PlatEntityDao dao;
    private static int MAX_OPENTIME;
    private static final int MAX_PROPERTYLENGTH = 150;
    private final String _indexTableSuf = "";
    private final String _textTableSuf = "_TEXT";
    private boolean hasIndexTable;
    private boolean hasTextTable;
    private String tableName;

    static {
        try {
            MAX_OPENTIME = Integer.parseInt(Global.getConfig("MAX_FORM_OPENTIME")) * 60 * 1000;
        }
        catch (Exception exp) {
            MAX_OPENTIME = 36000000;
        }
        try {
            dao = Factory.getDao(PlatEntityDao.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PlatEntityPatternBo() {
    }

    private String getIndexTableName() {
        return String.valueOf(this.tableName);
    }

    private String getTextTableName() {
        return String.valueOf(this.tableName) + "_TEXT";
    }

    @Override
    public PlatEntityPatternBo initByCode(String entityByName) {
        PlatEntityPatternBo platEntityPatternBo = new PlatEntityPatternBo();
        platEntityPatternBo.tableName = entityByName;
        platEntityPatternBo.hasIndexTable = DbOper.isExist((String)platEntityPatternBo.getIndexTableName());
        platEntityPatternBo.hasTextTable = DbOper.isExist((String)platEntityPatternBo.getTextTableName());
        return platEntityPatternBo;
    }

    @Override
    public void saveInstance(IUserBo user, PlatEntityInstanceBo platEntityInstanceBo) throws Exception {
        if (platEntityInstanceBo == null) {
            return;
        }
        if (platEntityInstanceBo.getDataModify() == Const.Data.Modify.MODIFY) {
            this.saveModifyInstance(user, platEntityInstanceBo);
        } else if (platEntityInstanceBo.getDataModify() == Const.Data.Modify.NEW) {
            this.saveNewInstance(user, platEntityInstanceBo);
        } else if (platEntityInstanceBo.getDataModify() == Const.Data.Modify.DELETE) {
            this.deleteInstance(user, platEntityInstanceBo);
        }
        platEntityInstanceBo.setDataModify(Const.Data.Modify.SAVED);
    }

    private void deleteInstance(IUserBo user, PlatEntityInstanceBo platEntityInstanceBo) throws SQLException {
        this.deleteInstance(user, platEntityInstanceBo.getId());
    }

    @Override
    public void deleteInstance(IUserBo user, String platEntityInstanceId) throws SQLException {
        dao.PlatEntityInsatance_Delete(platEntityInstanceId, this.getIndexTableName(), this.getTextTableName(), this.hasIndexTable, this.hasTextTable);
    }

    private void saveModifyInstance(IUserBo user, PlatEntityInstanceBo platEntityInstanceBo) throws SQLException {
        if (this.hasIndexTable) {
            dao.PlatEntityIndexPo_Save(this.getIndexPo(user, platEntityInstanceBo), this.getIndexTableName());
        }
        if (this.hasTextTable) {
            dao.savePlatEntityProperty(this.getEntityPoProperties(user, platEntityInstanceBo), this.getTextTableName(), platEntityInstanceBo.getId());
        }
    }

    private void saveNewInstance(IUserBo user, PlatEntityInstanceBo platEntityInstanceBo) throws Exception {
        if (this.hasIndexTable) {
            dao.PlatEntityIndexPo_Create(this.getIndexPo(user, platEntityInstanceBo), this.getIndexTableName());
        }
        if (this.hasTextTable) {
            dao.savePlatEntityProperty(this.getEntityPoProperties(user, platEntityInstanceBo), this.getTextTableName(), platEntityInstanceBo.getId());
        }
    }

    private PlatEntityIndexPo getIndexPo(IUserBo user, PlatEntityInstanceBo platEntityInstanceBo) throws SQLException {
        PlatEntityIndexPo indexPo = dao.createPlatEntityIndexPo(this.getIndexTableName());
        indexPo.setIndex(platEntityInstanceBo.getIndex());
        indexPo.setId(platEntityInstanceBo.getId());
        return indexPo;
    }

    private ArrayList<PlatEntityPropertyInstancePo> getEntityPoProperties(IUserBo user, PlatEntityInstanceBo platEntityInstanceBo) {
        ArrayList<PlatEntityPropertyInstancePo> properties = new ArrayList<PlatEntityPropertyInstancePo>();
        HashMap<String, FormCellInstanceBo> propertyMap = platEntityInstanceBo.getDataMap();
        Iterator<Map.Entry<String, FormCellInstanceBo>> iter = propertyMap.entrySet().iterator();
        String sheetId = platEntityInstanceBo.getId();
        while (iter.hasNext()) {
            int valueLength;
            int textLength;
            Map.Entry<String, FormCellInstanceBo> entry = iter.next();
            String byName = entry.getKey();
            FormCellInstanceBo cellData = entry.getValue();
            if (cellData == null) continue;
            String text = cellData.getText();
            String value = cellData.getValue();
            if (text == null) {
                text = "";
            }
            if (value == null) {
                value = "";
            }
            int n = (textLength = text.length()) / 150 > (valueLength = value.length()) / 150 ? textLength / 150 + 1 : valueLength / 150 + 1;
            int i = 0;
            while (i < n) {
                int begin = 0 + 150 * i;
                int end = 150 * (i + 1) - 1;
                String text_i = textLength > begin ? (textLength < end ? text.substring(begin, textLength) : text.substring(begin, end)) : "";
                String value_i = valueLength > begin ? (valueLength < end ? value.substring(begin, valueLength) : value.substring(begin, end)) : "";
                PlatEntityPropertyInstancePo property = new PlatEntityPropertyInstancePo();
                property.setPlatEntityInstenceId(sheetId);
                property.setPropertyName(byName);
                property.setSortId(i);
                property.setPropertyText(text_i);
                property.setPropertyValue(value_i);
                properties.add(property);
                ++i;
            }
        }
        return properties;
    }

    @Override
    public PlatEntityInstanceBo createInstance(IUserBo user) {
        PlatEntityInstanceBo platEntityInstance = new PlatEntityInstanceBo();
        platEntityInstance.setId(Guid.create());
        platEntityInstance.setCreaterId(user.getId());
        platEntityInstance.setCreateTime(Calendar.getInstance());
        platEntityInstance.setOpener(user);
        platEntityInstance.setOpenTime(Calendar.getInstance());
        platEntityInstance.setDataModify(Const.Data.Modify.NEW);
        platEntityInstance.setCreateTime(Calendar.getInstance());
        platEntityInstance.setDataStatusId(1);
        return platEntityInstance;
    }

    private PlatEntityInstanceBo loadInstance(IUserBo user, String formInstanceDataId, boolean readOnly) throws Exception {
        if (this.hasIndexTable) {
            PlatEntityInstanceBo platEntityInstance;
            PlatEntityIndexPo indexPo = dao.getPlatEntityIndexPo(formInstanceDataId, this.getIndexTableName());
            if (indexPo != null) {
                ArrayList<PlatEntityPropertyInstancePo> propertyArray;
                platEntityInstance = new PlatEntityInstanceBo();
                platEntityInstance.setId(indexPo.getId());
                platEntityInstance.setIndex(indexPo.getIndex());
                if (!HussarString.isEmpty(indexPo.getOpenerId())) {
                    IUserBo openUser = Factory.getService(Const.LAYER.CORE, IPermitController.class).getUserBo(indexPo.getOpenerId());
                    platEntityInstance.setOpener(openUser);
                    platEntityInstance.setOpenTime(indexPo.getOpenTime());
                }
                platEntityInstance.setDataModify(Const.Data.Modify.SAVED);
                if (this.hasTextTable && (propertyArray = dao.getPlatEntityPropertyInstancePo(formInstanceDataId, this.getTextTableName())) != null) {
                    int i = 0;
                    while (i < propertyArray.size()) {
                        PlatEntityPropertyInstancePo property = propertyArray.get(i);
                        FormCellInstanceBo cellInstance = platEntityInstance.getData(property.getPropertyName());
                        if (cellInstance != null) {
                            cellInstance.addText(property.getPropertyText());
                            cellInstance.addValue(property.getPropertyValue());
                        } else {
                            FormCellInstanceBo cellInstance_new = new FormCellInstanceBo();
                            cellInstance_new.setText(property.getPropertyText());
                            cellInstance_new.setValue(property.getPropertyValue());
                            platEntityInstance.setData(property.getPropertyName(), cellInstance_new);
                        }
                        ++i;
                    }
                }
            } else {
                return null;
            }
            return platEntityInstance;
        }
        return null;
    }

    @Override
    public PlatEntityInstanceBo loadInstance(IUserBo user, String formInstanceDataId) throws SQLException, Exception {
        return this.loadInstance(user, formInstanceDataId, false);
    }

    @Override
    public PlatEntityInstanceBo loadInstanceReadOnly(IUserBo user, String formInstanceDataId) throws Exception {
        return this.loadInstance(user, formInstanceDataId, true);
    }

    @Override
    public void closeFormInstance(IUserBo user, String formInstanceDataId) throws Exception {
        if (this.hasIndexTable) {
            dao.clearOpenerFlag(formInstanceDataId, this.getIndexTableName(), user.getId());
        }
    }

    @Override
    public void clearOpenFlag(IUserBo user, String formInstanceDataId) throws Exception {
        if (this.hasIndexTable) {
            dao.clearOpenerFlag(formInstanceDataId, this.getIndexTableName(), user.getId());
        }
    }

    @Override
    public boolean updateOpenFlag(IUserBo user, PlatEntityInstanceBo platEntityInstanceBo) throws Exception {
        if (this.hasIndexTable && platEntityInstanceBo.getDataModify() != Const.Data.Modify.NEW) {
            Calendar nowTime = Calendar.getInstance();
            if (platEntityInstanceBo.getOpener() == null || user.equals(platEntityInstanceBo.getOpener()) || platEntityInstanceBo.getOpenTime() == null || nowTime.getTime().getTime() - platEntityInstanceBo.getOpenTime().getTime().getTime() > (long)MAX_OPENTIME || AppConfig.getIsUseSession() && !User.userIsOnline((String)platEntityInstanceBo.getOpener().getId())) {
                if (platEntityInstanceBo.getIndex().containsKey("OPENERID") && platEntityInstanceBo.getIndex().containsKey("LASTOPENTIME")) {
                    platEntityInstanceBo.setOpener(user);
                    platEntityInstanceBo.setOpenTime(nowTime);
                    dao.PlatEntityIndexPo_Save(this.getIndexPo(user, platEntityInstanceBo), this.getIndexTableName());
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

